/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.pipes.aggregation;

import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.aggregation.AggregateTest;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.aggregation.AggregateTest$class;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.aggregation.SumFunction;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.aggregation.SumFunctionTest$;
import org.neo4j.cypher.internal.frontend.v2_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001'\ty1+^7Gk:\u001cG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Y\u0011mZ4sK\u001e\fG/[8o\u0015\t)a!A\u0003qSB,7O\u0003\u0002\b\u0011\u0005!aOM04\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0004\u0001Qi\u0002CA\u000b\u001c\u001b\u00051\"BA\f\u0019\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t9\u0011D\u0003\u0002\u001b\u0015\u0005AaM]8oi\u0016tG-\u0003\u0002\u001d-\tq1)\u001f9iKJ4UO\\*vSR,\u0007C\u0001\u0010 \u001b\u0005\u0011\u0011B\u0001\u0011\u0003\u00055\tum\u001a:fO\u0006$X\rV3ti\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\u0012\u0001\n\t\u0003=\u0001AQA\n\u0001\u0005\u0002\u001d\n\u0001c\u0019:fCR,\u0017iZ4sK\u001e\fGo\u001c:\u0015\u0005!Z\u0003C\u0001\u0010*\u0013\tQ#AA\u0006Tk64UO\\2uS>t\u0007\"\u0002\u0017&\u0001\u0004i\u0013!B5o]\u0016\u0014\bC\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005I2\u0011\u0001C2p[6\fg\u000eZ:\n\u0005Qz#AC#yaJ,7o]5p]\u0002")
public class SumFunctionTest
extends CypherFunSuite
implements AggregateTest {
    @Override
    public Object aggregateOn(Seq<Object> values) {
        return AggregateTest$class.aggregateOn(this, values);
    }

    public SumFunction createAggregator(Expression inner) {
        return new SumFunction(inner);
    }

    public SumFunctionTest() {
        AggregateTest$class.$init$(this);
        this.test("singleValueReturnsThatNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result = this.$outer.aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Long.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("singleValueOfDecimalReturnsDecimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result = this.$outer.aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0)}));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToDouble((double)1.0)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Double.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mixOfIntAndDoubleYieldsDouble", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result = this.$outer.aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)1.0)}));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToDouble((double)2.0)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Double.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("mixedLotsOfStuff", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result = this.$outer.aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)Predef$.MODULE$.int2Integer(1).byteValue()), BoxesRunTime.boxToShort((short)Predef$.MODULE$.int2Integer(1).shortValue())}));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Long.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noNumbersEqualsZero", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result = this.$outer.aggregateOn((Seq<Object>)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Long.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("nullDoesNotChangeTheSum", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object result = this.$outer.aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null}));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Long.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("noNumberValuesThrowAnException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$aggregation$SumFunctionTest$$anonfun$$$outer().aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "wut"}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(CypherTypeException.class));
            }

            public /* synthetic */ SumFunctionTest org$neo4j$cypher$internal$compiler$v2_3$pipes$aggregation$SumFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intOverflowTransformsSumToLong", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int halfInt = Integer.MAX_VALUE;
                Object result = this.$outer.aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)halfInt), BoxesRunTime.boxToInteger((int)halfInt), BoxesRunTime.boxToInteger((int)halfInt)}));
                long expected = 3L * (long)halfInt;
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToLong((long)expected)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("typesArentUnnecessaryWidened", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SumFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int thirdOfMaxInt = 0x2AAAAAAA;
                Object result = this.$outer.aggregateOn((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)thirdOfMaxInt), BoxesRunTime.boxToInteger((int)thirdOfMaxInt)}));
                int expected = thirdOfMaxInt + thirdOfMaxInt;
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)expected)), (Object)Equality$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(result).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Long.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

