/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders;

import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.AnyIndex$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.EntityProducerFactory;
import org.neo4j.cypher.internal.compiler.v2_3.commands.NodeByLabel;
import org.neo4j.cypher.internal.compiler.v2_3.commands.SchemaIndex;
import org.neo4j.cypher.internal.compiler.v2_3.commands.SchemaIndexKind;
import org.neo4j.cypher.internal.compiler.v2_3.commands.SingleQueryExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.EntityProducerFactoryTest$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.EntityProducer;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_3.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v2_3.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v2_3.spi.TokenContext;
import org.neo4j.cypher.internal.frontend.v2_3.IndexHintException;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001'\tIRI\u001c;jif\u0004&o\u001c3vG\u0016\u0014h)Y2u_JLH+Z:u\u0015\t\u0019A!\u0001\u0005ck&dG-\u001a:t\u0015\t)a!A\u0007fq\u0016\u001cW\u000f^5p]Bd\u0017M\u001c\u0006\u0003\u000f!\tAA\u001e\u001a`g)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u001c\u001b\u00051\"BA\f\u0019\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t9\u0011D\u0003\u0002\u001b\u0015\u0005AaM]8oi\u0016tG-\u0003\u0002\u001d-\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u0010\u0001\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0003\u0011\u001d\u0019\u0003\u00011A\u0005\u0002\u0011\n1\u0002\u001d7b]\u000e{g\u000e^3yiV\tQ\u0005\u0005\u0002'S5\tqE\u0003\u0002)\r\u0005\u00191\u000f]5\n\u0005):#a\u0003)mC:\u001cuN\u001c;fqRDq\u0001\f\u0001A\u0002\u0013\u0005Q&A\bqY\u0006t7i\u001c8uKb$x\fJ3r)\tqC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0003V]&$\bbB\u001b,\u0003\u0003\u0005\r!J\u0001\u0004q\u0012\n\u0004BB\u001c\u0001A\u0003&Q%\u0001\u0007qY\u0006t7i\u001c8uKb$\b\u0005C\u0004:\u0001\u0001\u0007I\u0011\u0001\u001e\u0002\u000f\u0019\f7\r^8ssV\t1\b\u0005\u0002=\u007f5\tQH\u0003\u0002?\r\u0005A1m\\7nC:$7/\u0003\u0002A{\t)RI\u001c;jif\u0004&o\u001c3vG\u0016\u0014h)Y2u_JL\bb\u0002\"\u0001\u0001\u0004%\taQ\u0001\fM\u0006\u001cGo\u001c:z?\u0012*\u0017\u000f\u0006\u0002/\t\"9Q'QA\u0001\u0002\u0004Y\u0004B\u0002$\u0001A\u0003&1(\u0001\u0005gC\u000e$xN]=!\u0011\u001dA\u0005A1A\u0005\u0002%\u000bqaY8oi\u0016DH/F\u0001K!\tYE*D\u0001\u0007\u0013\tieA\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"1q\n\u0001Q\u0001\n)\u000b\u0001bY8oi\u0016DH\u000f\t\u0005\u0006#\u0002!\tEU\u0001\u000bE\u00164wN]3FC\u000eDG#\u0001\u0018")
public class EntityProducerFactoryTest
extends CypherFunSuite {
    private PlanContext planContext = null;
    private EntityProducerFactory factory = null;
    private final ExecutionContext context = ExecutionContext$.MODULE$.empty();

    public PlanContext planContext() {
        return this.planContext;
    }

    public void planContext_$eq(PlanContext x$1) {
        this.planContext = x$1;
    }

    public EntityProducerFactory factory() {
        return this.factory;
    }

    public void factory_$eq(EntityProducerFactory x$1) {
        this.factory = x$1;
    }

    public ExecutionContext context() {
        return this.context;
    }

    public void beforeEach() {
        super.beforeEach();
        this.planContext_$eq((PlanContext)this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class)));
        this.factory_$eq(new EntityProducerFactory());
    }

    public EntityProducerFactoryTest() {
        this.test("throws_error_when_index_is_missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String label = "label";
                String prop = "prop";
                Mockito.when((Object)this.$outer.planContext().getIndexRule(label, prop)).thenReturn((Object)None$.MODULE$);
                this.$outer.intercept((Function0)new Serializable(this, label, prop){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final String label$1;
                    private final String prop$1;

                    public final EntityProducer<Node> apply() {
                        return (EntityProducer)this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$EntityProducerFactoryTest$$anonfun$$$outer().factory().nodeByIndexHint(true).apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$EntityProducerFactoryTest$$anonfun$$$outer().planContext()), (Object)new SchemaIndex("id", this.label$1, this.prop$1, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)None$.MODULE$)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.label$1 = label$1;
                        this.prop$1 = prop$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IndexHintException.class));
            }

            public /* synthetic */ EntityProducerFactoryTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$EntityProducerFactoryTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("calls_the_right_methods", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String label = "label";
                String prop = "prop";
                IndexDescriptor index = new IndexDescriptor(123, 456);
                int value = 42;
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)this.$outer.planContext().getIndexRule(label, prop)).thenReturn((Object)new Some((Object)index));
                Iterator indexResult = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}));
                Mockito.when((Object)queryContext.indexSeek(index, (Object)BoxesRunTime.boxToInteger((int)value))).thenReturn((Object)indexResult);
                QueryState state = QueryStateHelper$.MODULE$.emptyWith(queryContext, QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                EntityProducer func = (EntityProducer)this.$outer.factory().nodeByIndexHint(true).apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.planContext()), (Object)new SchemaIndex("id", label, prop, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new SingleQueryExpression((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)value)))))));
                this.$outer.convertToAnyShouldWrapper(func.apply((Object)this.$outer.context(), (Object)state)).should(this.$outer.equal(indexResult), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("retries_every_time_if_the_label_did_not_exist_at_plan_building", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String label = "label";
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)this.$outer.planContext().getOptLabelId(label)).thenReturn((Object)None$.MODULE$);
                Mockito.when((Object)queryContext.getOptLabelId(label)).thenReturn((Object)None$.MODULE$);
                QueryState state = QueryStateHelper$.MODULE$.emptyWith(queryContext, QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                EntityProducer func = (EntityProducer)this.$outer.factory().nodeByLabel().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.planContext()), (Object)new NodeByLabel("id", label)));
                this.$outer.convertToAnyShouldWrapper(func.apply((Object)this.$outer.context(), (Object)state)).should(this.$outer.equal(package$.MODULE$.Iterator().empty()), (Object)Equality$.MODULE$.default());
                ((TokenContext)Mockito.verify((Object)queryContext, (VerificationMode)Mockito.times((int)1))).getOptLabelId(label);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_translate_values_to_neo4j", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String labelName2 = "Label";
                String propertyKey = "prop";
                IndexDescriptor index = new IndexDescriptor(123, 456);
                Mockito.when((Object)this.$outer.planContext().getIndexRule(labelName2, propertyKey)).thenReturn((Object)new Some((Object)index));
                EntityProducer producer = (EntityProducer)this.$outer.factory().nodeByIndexHint(true).apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.planContext()), (Object)new SchemaIndex("x", labelName2, propertyKey, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new SingleQueryExpression((Object)new Literal((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))))))));
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                QueryState state = QueryStateHelper$.MODULE$.emptyWith(queryContext, QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                Mockito.when((Object)queryContext.indexSeek(index, (Object)new int[]{1, 2, 3})).thenReturn((Object)package$.MODULE$.Iterator().empty());
                producer.apply((Object)this.$outer.context(), (Object)state);
                ((QueryContext)Mockito.verify((Object)queryContext, (VerificationMode)Mockito.times((int)1))).indexSeek(index, (Object)new int[]{1, 2, 3});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

