/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.planner.logical;

import org.neo4j.cypher.internal.compiler.v2_3.ASTRewriter;
import org.neo4j.cypher.internal.compiler.v2_3.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyLabel;
import org.neo4j.cypher.internal.compiler.v2_3.planner.BeLikeMatcher$;
import org.neo4j.cypher.internal.compiler.v2_3.planner.FakePlan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanningTestSupport2;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanningTestSupport2$class;
import org.neo4j.cypher.internal.compiler.v2_3.planner.PlannerQuery;
import org.neo4j.cypher.internal.compiler.v2_3.planner.QueryGraph;
import org.neo4j.cypher.internal.compiler.v2_3.planner.RealLogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v2_3.planner.SemanticPlan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.SimpleTokenResolver;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cost;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cost$;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.DefaultQueryPlanner;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.greedy.GreedyPlanTable;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.CartesianProduct;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.IdName;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.NodeByLabelScan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.Selection;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.rewriter.LogicalPlanRewriter;
import org.neo4j.cypher.internal.compiler.v2_3.tracing.rewriters.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v2_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v2_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v2_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v2_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Identifier;
import org.neo4j.cypher.internal.frontend.v2_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.BeMatcher;
import org.scalatest.matchers.Matcher;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001'\t93)\u0019:uKNL\u0017M\u001c)s_\u0012,8\r\u001e)mC:t\u0017N\\4J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000f!\tAA\u001e\u001a`g)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!R\u0004\u0005\u0002\u001675\taC\u0003\u0002\u00181\u0005aA/Z:u?\",G\u000e]3sg*\u0011q!\u0007\u0006\u00035)\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00039Y\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0005\u0002\u001f?5\tA!\u0003\u0002!\t\tYBj\\4jG\u0006d\u0007\u000b\\1o]&tw\rV3tiN+\b\u000f]8siJBQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0002")
public class CartesianProductPlanningIntegrationTest
extends CypherFunSuite
implements LogicalPlanningTestSupport2 {
    private final PlannerQuery solved;
    private CypherParser parser;
    private SemanticChecker semanticChecker;
    private final Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer;
    private ASTRewriter astRewriter;
    private SimpleTokenResolver tokenResolver;
    private final LogicalPlanRewriter planRewriter;
    private DefaultQueryPlanner planner;
    private QueryGraphSolver queryGraphSolver;
    private final RealLogicalPlanningConfiguration realConfig;
    private final InputPosition pos;

    @Override
    public PlannerQuery solved() {
        return this.solved;
    }

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    @TraitSetter
    public void parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    @TraitSetter
    public void semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer() {
        return this.rewriterSequencer;
    }

    @Override
    public ASTRewriter astRewriter() {
        return this.astRewriter;
    }

    @Override
    @TraitSetter
    public void astRewriter_$eq(ASTRewriter x$1) {
        this.astRewriter = x$1;
    }

    @Override
    public SimpleTokenResolver tokenResolver() {
        return this.tokenResolver;
    }

    @Override
    @TraitSetter
    public void tokenResolver_$eq(SimpleTokenResolver x$1) {
        this.tokenResolver = x$1;
    }

    @Override
    public LogicalPlanRewriter planRewriter() {
        return this.planRewriter;
    }

    @Override
    public final DefaultQueryPlanner planner() {
        return this.planner;
    }

    @Override
    @TraitSetter
    public final void planner_$eq(DefaultQueryPlanner x$1) {
        this.planner = x$1;
    }

    @Override
    public QueryGraphSolver queryGraphSolver() {
        return this.queryGraphSolver;
    }

    @Override
    @TraitSetter
    public void queryGraphSolver_$eq(QueryGraphSolver x$1) {
        this.queryGraphSolver = x$1;
    }

    @Override
    public RealLogicalPlanningConfiguration realConfig() {
        return this.realConfig;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$solved_$eq(PlannerQuery x$1) {
        this.solved = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$rewriterSequencer_$eq(Function1 x$1) {
        this.rewriterSequencer = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$planRewriter_$eq(LogicalPlanRewriter x$1) {
        this.planRewriter = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$realConfig_$eq(RealLogicalPlanningConfiguration x$1) {
        this.realConfig = x$1;
    }

    @Override
    public PlannerQuery solvedWithEstimation(Cardinality cardinality) {
        return LogicalPlanningTestSupport2$class.solvedWithEstimation(this, cardinality);
    }

    @Override
    public <C extends LogicalPlanningConfiguration> LogicalPlanningTestSupport2.LogicalPlanningEnvironment<C> LogicalPlanningEnvironment(C config) {
        return LogicalPlanningTestSupport2$class.LogicalPlanningEnvironment(this, config);
    }

    @Override
    public FakePlan fakeLogicalPlanFor(Seq<String> id) {
        return LogicalPlanningTestSupport2$class.fakeLogicalPlanFor(this, id);
    }

    @Override
    public SemanticPlan planFor(String queryString) {
        return LogicalPlanningTestSupport2$class.planFor(this, queryString);
    }

    @Override
    public GreedyPlanTable greedyPlanTableWith(Seq<LogicalPlan> plans, LogicalPlanningContext ctx) {
        return LogicalPlanningTestSupport2$class.greedyPlanTableWith(this, plans, ctx);
    }

    @Override
    public LazyLabel lazyLabel(String label, SemanticPlan plan) {
        return LogicalPlanningTestSupport2$class.lazyLabel(this, label, plan);
    }

    @Override
    public PropertyKeyId propertyKeyId(String label, SemanticPlan plan) {
        return LogicalPlanningTestSupport2$class.propertyKeyId(this, label, plan);
    }

    @Override
    public <T extends LogicalPlan> BeMatcher<SemanticPlan> using(ClassTag<T> tag) {
        return LogicalPlanningTestSupport2$class.using(this, tag);
    }

    @Override
    public IdName idName(String name) {
        return LogicalPlanConstructionTestSupport$class.idName(this, name);
    }

    @Override
    public IdName idSymbol(Symbol name) {
        return LogicalPlanConstructionTestSupport$class.idSymbol(this, name);
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v2_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Identifier ident(String name) {
        return AstConstructionTestSupport.class.ident((AstConstructionTestSupport)this, (String)name);
    }

    public HasLabels hasLabels(String identifier, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)identifier, (String)label);
    }

    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)identifier, (String)propKey, (int)intValue);
    }

    public CartesianProductPlanningIntegrationTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        LogicalPlanConstructionTestSupport$class.$init$(this);
        LogicalPlanningTestSupport2$class.$init$(this);
        this.test("should build plans for simple cartesian product", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.planFor("MATCH n, m RETURN n, m").plan()).should(this.$outer.equal(new CartesianProduct((LogicalPlan)new AllNodesScan(new IdName("n"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), (LogicalPlan)new AllNodesScan(new IdName("m"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), this.$outer.solved())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans so the cheaper plan is on the left", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.LogicalPlanningEnvironment(new LogicalPlanningTestSupport2.given(this){
                    {
                        super($outer.org$neo4j$cypher$internal$compiler$v2_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer());
                        this.cost_$eq((PartialFunction<Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput>, Cost>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Object object = A1 != null && A1._1() instanceof Selection ? Cost$.MODULE$.lift(1000.0) : (A1 != null && A1._1() instanceof NodeByLabelScan ? Cost$.MODULE$.lift(20.0) : function1.apply(x1));
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput> x1) {
                                Tuple2<LogicalPlan, Metrics.QueryGraphSolverInput> tuple2 = x1;
                                boolean bl = tuple2 != null && tuple2._1() instanceof Selection ? true : tuple2 != null && tuple2._1() instanceof NodeByLabelScan;
                                return bl;
                            }
                        });
                        this.cardinality_$eq(this.mapCardinality((PartialFunction<PlannerQuery, Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends PlannerQuery, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                QueryGraph queryGraph;
                                A1 A1 = x2;
                                Object object = A1 != null && (queryGraph = A1.graph()).selections().predicates().size() == 1 ? BoxesRunTime.boxToDouble((double)10.0) : function1.apply(x2);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(PlannerQuery x2) {
                                QueryGraph queryGraph;
                                PlannerQuery plannerQuery = x2;
                                boolean bl = plannerQuery != null && (queryGraph = plannerQuery.graph()).selections().predicates().size() == 1;
                                return bl;
                            }
                        }));
                    }
                }).planFor("MATCH n, m WHERE n.prop = 12 AND m:Label RETURN n, m").plan()).should((Matcher)BeLikeMatcher$.MODULE$.beLike((PartialFunction<Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        CartesianProduct cartesianProduct;
                        A1 A1 = x3;
                        Object object = A1 instanceof CartesianProduct && (cartesianProduct = (CartesianProduct)A1).left() instanceof Selection && cartesianProduct.right() instanceof NodeByLabelScan ? BoxedUnit.UNIT : function1.apply(x3);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Object x3) {
                        CartesianProduct cartesianProduct;
                        Object object = x3;
                        boolean bl = object instanceof CartesianProduct && (cartesianProduct = (CartesianProduct)object).left() instanceof Selection && cartesianProduct.right() instanceof NodeByLabelScan;
                        return bl;
                    }
                }));
            }

            public /* synthetic */ CartesianProductPlanningIntegrationTest org$neo4j$cypher$internal$compiler$v2_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should combine three plans so the cost is minimized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticPlan plan = this.$outer.LogicalPlanningEnvironment(new LogicalPlanningTestSupport2.given(this){
                    {
                        super($outer.org$neo4j$cypher$internal$compiler$v2_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer());
                        this.labelCardinality_$eq((Map<String, Cardinality>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)Cardinality$.MODULE$.lift(30.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Object)Cardinality$.MODULE$.lift(20.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)Cardinality$.MODULE$.lift(10.0))}))));
                    }
                }).planFor("MATCH a, b, c WHERE a:A AND b:B AND c:C RETURN a, b, c");
                this.$outer.convertToAnyShouldWrapper(plan.plan()).should(this.$outer.equal(new CartesianProduct((LogicalPlan)new NodeByLabelScan(this.$outer.idName("a"), new LazyLabel("A"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), (LogicalPlan)new CartesianProduct((LogicalPlan)new NodeByLabelScan(this.$outer.idName("c"), new LazyLabel("C"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), (LogicalPlan)new NodeByLabelScan(this.$outer.idName("b"), new LazyLabel("B"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), this.$outer.solved()), this.$outer.solved())), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ CartesianProductPlanningIntegrationTest org$neo4j$cypher$internal$compiler$v2_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should combine two plans so the cost is minimized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CartesianProductPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticPlan plan = this.$outer.LogicalPlanningEnvironment(new LogicalPlanningTestSupport2.given(this){
                    {
                        super($outer.org$neo4j$cypher$internal$compiler$v2_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer());
                        this.labelCardinality_$eq((Map<String, Cardinality>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"A"), (Object)Cardinality$.MODULE$.lift(30.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"B"), (Object)Cardinality$.MODULE$.lift(20.0))}))));
                    }
                }).planFor("MATCH a, b WHERE a:A AND b:B RETURN a, b");
                this.$outer.convertToAnyShouldWrapper(plan.plan()).should(this.$outer.equal(new CartesianProduct((LogicalPlan)new NodeByLabelScan(this.$outer.idName("b"), new LazyLabel("B"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), (LogicalPlan)new NodeByLabelScan(this.$outer.idName("a"), new LazyLabel("A"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), this.$outer.solved())), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ CartesianProductPlanningIntegrationTest org$neo4j$cypher$internal$compiler$v2_3$planner$logical$CartesianProductPlanningIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

