/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3;

import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compiler.v2_3.ClosingIterator;
import org.neo4j.cypher.internal.compiler.v2_3.TaskCloser;
import org.neo4j.cypher.internal.frontend.v2_3.CypherException;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u001f\t\u00192\t\\8tS:<\u0017\n^3sCR|'\u000fV3ti*\u00111\u0001B\u0001\u0005mJz6G\u0003\u0002\u0006\r\u0005A1m\\7qS2,'O\u0003\u0002\b\u0011\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\n\u0015\u000511-\u001f9iKJT!a\u0003\u0007\u0002\u000b9,w\u000e\u000e6\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E9R\"\u0001\n\u000b\u0005M!\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0002\u0016\u0015\t1b!\u0001\u0005ge>tG/\u001a8e\u0013\tA\"C\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"C\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0001!\u0003)!\u0018m]6DY>\u001cXM]\u000b\u0002CA\u0011QDI\u0005\u0003G\t\u0011!\u0002V1tW\u000ecwn]3s\u0011%)\u0003\u00011AA\u0002\u0013\u0005a%\u0001\buCN\\7\t\\8tKJ|F%Z9\u0015\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#\u0001B+oSRDqA\f\u0013\u0002\u0002\u0003\u0007\u0011%A\u0002yIEBa\u0001\r\u0001!B\u0013\t\u0013a\u0003;bg.\u001cEn\\:fe\u0002BqA\r\u0001C\u0002\u0013\u00051'\u0001\nfq\u000e,\u0007\u000f^5p]\u0012+7m\u001c:bi>\u0014X#\u0001\u001b\u0011\t!*tgN\u0005\u0003m%\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005aJT\"\u0001\u000b\n\u0005i\"\"aD\"za\",'/\u0012=dKB$\u0018n\u001c8\t\rq\u0002\u0001\u0015!\u00035\u0003M)\u0007pY3qi&|g\u000eR3d_J\fGo\u001c:!\u0011\u0015q\u0004\u0001\"\u0011@\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002O\u0001")
public class ClosingIteratorTest
extends CypherFunSuite {
    private TaskCloser taskCloser;
    private final Function1<CypherException, CypherException> exceptionDecorator = new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final CypherException apply(CypherException x) {
            return (CypherException)Predef$.MODULE$.identity((Object)x);
        }
    };

    public TaskCloser taskCloser() {
        return this.taskCloser;
    }

    public void taskCloser_$eq(TaskCloser x$1) {
        this.taskCloser = x$1;
    }

    public Function1<CypherException, CypherException> exceptionDecorator() {
        return this.exceptionDecorator;
    }

    public void beforeEach() {
        super.beforeEach();
        this.taskCloser_$eq((TaskCloser)this.mock(ManifestFactory$.MODULE$.classType(TaskCloser.class)));
    }

    public ClosingIteratorTest() {
        this.test("should_cleanup_when_we_reach_the_end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))}))}));
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                Map result = iterator.next();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_cleanup_even_for_empty_iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().empty();
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                boolean result = iterator.hasNext();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple_has_next_should_not_close_more_than_once", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().empty();
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                boolean result = iterator.hasNext();
                iterator.hasNext();
                iterator.hasNext();
                iterator.hasNext();
                iterator.hasNext();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser(), (VerificationMode)Mockito.atLeastOnce())).close(true);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("exception_in_hasNext_should_fail_transaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = (Iterator)this.$outer.mock(ManifestFactory$.MODULE$.classType(Iterator.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)wrapee.hasNext())).thenThrow(new Throwable[]{new RuntimeException()});
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                this.$outer.intercept((Function0)new Serializable(this, iterator){
                    public static final long serialVersionUID = 0L;
                    private final ClosingIterator iterator$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.iterator$1.hasNext();
                    }
                    {
                        this.iterator$1 = iterator$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("exception_in_next_should_fail_transaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = (Iterator)this.$outer.mock(ManifestFactory$.MODULE$.classType(Iterator.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)wrapee.hasNext())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Mockito.when((Object)wrapee.next()).thenThrow(new Throwable[]{new RuntimeException()});
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                this.$outer.intercept((Function0)new Serializable(this, iterator){
                    public static final long serialVersionUID = 0L;
                    private final ClosingIterator iterator$2;

                    public final Map<String, Object> apply() {
                        return this.iterator$2.next();
                    }
                    {
                        this.iterator$2 = iterator$2;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("close_runs_cleanup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)43))}))}));
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                Map result = iterator.next();
                iterator.close();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

