/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v2_3.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_3.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.expandStar;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.projectFreshSortExpressions$;
import org.neo4j.cypher.internal.frontend.v2_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v2_3.Rewritable;
import org.neo4j.cypher.internal.frontend.v2_3.Rewritable$;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticState$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v2_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Identifier;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v2_3.inSequence$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001'\ty\u0002K]8kK\u000e$hI]3tQN{'\u000f^#yaJ,7o]5p]N$Vm\u001d;\u000b\u0005\r!\u0011!\u0003:foJLG/\u001a:t\u0015\t)a!A\u0002bgRT!a\u0002\u0005\u0002\tY\u0014tl\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u0015;\u0005\u0002\"!F\u000e\u000e\u0003YQ!a\u0006\r\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u001dI\"B\u0001\u000e\u000b\u0003!1'o\u001c8uK:$\u0017B\u0001\u000f\u0017\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\u0004\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017I+wO]5uKR+7\u000f\u001e\t\u0003E\u0011j\u0011a\t\u0006\u0003\u000baI!!J\u0012\u00035\u0005\u001bHoQ8ogR\u0014Xo\u0019;j_:$Vm\u001d;TkB\u0004xN\u001d;\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0010\u0001\u0011\u001dY\u0003A1A\u0005\u00021\n\u0011C]3xe&$XM]+oI\u0016\u0014H+Z:u+\u0005i\u0003C\u0001\u0018A\u001d\tycH\u0004\u00021{9\u0011\u0011\u0007\u0010\b\u0003emr!a\r\u001e\u000f\u0005QJdBA\u001b9\u001b\u00051$BA\u001c\u0013\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!A\u0007\u0006\n\u0005\u001dI\u0012BA \u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0011\"\u0003\u0011I+wO]5uKJT!a\u0010\r\t\r\u0011\u0003\u0001\u0015!\u0003.\u0003I\u0011Xm\u001e:ji\u0016\u0014XK\u001c3feR+7\u000f\u001e\u0011\t\u000b\u0019\u0003A\u0011K$\u0002\u001b\u0005\u001c8/\u001a:u%\u0016<(/\u001b;f)\rAej\u0016\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0005+:LG\u000fC\u0003P\u000b\u0002\u0007\u0001+A\u0007pe&<\u0017N\\1m#V,'/\u001f\t\u0003#Rs!!\u0013*\n\u0005MS\u0015A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!a\u0015&\t\u000ba+\u0005\u0019\u0001)\u0002\u001b\u0015D\b/Z2uK\u0012\fV/\u001a:z\u0011\u0015)\u0001\u0001\"\u0003[)\tYf\f\u0005\u0002#9&\u0011Ql\t\u0002\n'R\fG/Z7f]RDQaX-A\u0002A\u000b\u0011\"];fef$V\r\u001f;")
public class ProjectFreshSortExpressionsTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final Function1<Object, Object> rewriterUnderTest;
    private final InputPosition pos;
    private final SemanticChecker semanticChecker;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v2_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Identifier ident(String name) {
        return AstConstructionTestSupport.class.ident((AstConstructionTestSupport)this, (String)name);
    }

    public HasLabels hasLabels(String identifier, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)identifier, (String)label);
    }

    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)identifier, (String)propKey, (int)intValue);
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$RewriteTest$_setter_$semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query2) {
        RewriteTest$class.assertIsNotRewritten(this, query2);
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        Statement original = this.ast(originalQuery);
        Statement expected = this.ast(expectedQuery);
        Statement result = this.endoRewrite(original);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"\n").append((Object)originalQuery).toString());
    }

    private Statement ast(String queryText) {
        Statement parsed = this.parseForRewriting(queryText);
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(queryText, (Option)new Some((Object)this.pos()));
        Statement normalized = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)parsed), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        SemanticCheckResult checkResult = (SemanticCheckResult)normalized.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)normalized), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new expandStar(checkResult.state())})));
    }

    public ProjectFreshSortExpressionsTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.rewriterUnderTest = projectFreshSortExpressions$.MODULE$;
        this.test("don't adjust WITH without ORDER BY or WHERE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing ORDER BY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing ORDER BY that refers to previous identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop + n.x\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop AS prop\n        |WITH prop AS prop, prop + n.x AS `  FRESHID42`\n        |WITH prop AS prop, `  FRESHID42` AS `  FRESHID42` ORDER BY `  FRESHID42`\n        |WITH prop AS prop\n        |RETURN prop AS prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate RETURN containing ORDER BY after WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS p, count(*) AS rng\n        |RETURN p ORDER BY rng\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS p, count(*) AS rng\n        |WITH p AS `  FRESHID36`, rng AS rng\n        |WITH `  FRESHID36` AS `  FRESHID36` ORDER BY rng\n        |RETURN `  FRESHID36` AS p\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing WHERE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop WHERE prop\n        |RETURN prop AS prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("preserve DISTINCT on first WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("carry SKIP and LIMIT with ORDER BY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop SKIP 2 LIMIT 5\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop SKIP 2 LIMIT 5\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("carry SKIP and LIMIT with WHERE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop SKIP 2 LIMIT 5 WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop SKIP 2 LIMIT 5 WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("keep WHERE with ORDER BY", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handle RETURN * ORDERBY property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN * ORDER BY n.prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n, n.prop AS `  FRESHID28`\n        |WITH n AS n, `  FRESHID28` AS `  FRESHID28` ORDER BY `  FRESHID28`\n        |WITH n AS n\n        |RETURN n AS n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not introduce WITH for ORDER BY over preserved identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n      |WITH n AS n, n.prop AS prop\n      |WITH n AS n, prop AS prop ORDER BY prop\n      |RETURN n AS n\n    ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not introduce WITH for WHERE over preserved identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop AS prop\n        |WITH n AS n, prop AS prop WHERE prop\n        |RETURN n AS n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

