/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.pipes;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.ExpandIntoPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.ExpandIntoPipe$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.ExpandIntoPipeTest$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyTypes;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyTypes$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_3.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Aggregating$;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001E\u0011!#\u0012=qC:$\u0017J\u001c;p!&\u0004X\rV3ti*\u00111\u0001B\u0001\u0006a&\u0004Xm\u001d\u0006\u0003\u000b\u0019\tAA\u001e\u001a`g)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005AaM]8oi\u0016tG-\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u001d\t\u0003A1A\u0005\u0004\t\nq!\\8oSR|'/F\u0001$!\tyB%\u0003\u0002&\u0005\tY\u0001+\u001b9f\u001b>t\u0017\u000e^8s\u0011\u00199\u0003\u0001)A\u0005G\u0005AQn\u001c8ji>\u0014\b\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\u0002\u0013M$\u0018M\u001d;O_\u0012,W#A\u0016\u0011\u00051zS\"A\u0017\u000b\u00059b\u0011aB4sCBDGMY\u0005\u0003a5\u0012AAT8eK\"1!\u0007\u0001Q\u0001\n-\n!b\u001d;beRtu\u000eZ3!\u0011\u001d!\u0004A1A\u0005\u0002)\n\u0001\"\u001a8e\u001d>$W-\r\u0005\u0007m\u0001\u0001\u000b\u0011B\u0016\u0002\u0013\u0015tGMT8eKF\u0002\u0003b\u0002\u001d\u0001\u0005\u0004%\tAK\u0001\tK:$gj\u001c3fe!1!\b\u0001Q\u0001\n-\n\u0011\"\u001a8e\u001d>$WM\r\u0011\t\u000fq\u0002!\u0019!C\u0001U\u0005AQM\u001c3O_\u0012,7\u0007\u0003\u0004?\u0001\u0001\u0006IaK\u0001\nK:$gj\u001c3fg\u0001Bq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011)A\u0007sK2\fG/[8og\"L\u0007/M\u000b\u0002\u0005B\u0011AfQ\u0005\u0003\t6\u0012ABU3mCRLwN\\:iSBDaA\u0012\u0001!\u0002\u0013\u0011\u0015A\u0004:fY\u0006$\u0018n\u001c8tQ&\u0004\u0018\u0007\t\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001B\u00035\u0011X\r\\1uS>t7\u000f[5qe!1!\n\u0001Q\u0001\n\t\u000baB]3mCRLwN\\:iSB\u0014\u0004\u0005C\u0004M\u0001\t\u0007I\u0011A!\u0002\u001bI,G.\u0019;j_:\u001c\b.\u001b94\u0011\u0019q\u0005\u0001)A\u0005\u0005\u0006q!/\u001a7bi&|gn\u001d5jaN\u0002\u0003b\u0002)\u0001\u0005\u0004%\t!Q\u0001\u0011g\u0016dgMU3mCRLwN\\:iSBDaA\u0015\u0001!\u0002\u0013\u0011\u0015!E:fY\u001a\u0014V\r\\1uS>t7\u000f[5qA!9A\u000b\u0001b\u0001\n\u0003)\u0016!B9vKJLX#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e#\u0011aA:qS&\u00111\f\u0017\u0002\r#V,'/_\"p]R,\u0007\u0010\u001e\u0005\u0007;\u0002\u0001\u000b\u0011\u0002,\u0002\rE,XM]=!\u0011\u001dy\u0006A1A\u0005\u0002\u0001\f!\"];fef\u001cF/\u0019;f+\u0005\t\u0007CA\u0010c\u0013\t\u0019'A\u0001\u0006Rk\u0016\u0014\u0018p\u0015;bi\u0016Da!\u001a\u0001!\u0002\u0013\t\u0017aC9vKJL8\u000b^1uK\u0002BQa\u001a\u0001\u0005\n!\f1A]8x)\tIW\u000e\u0005\u0002kW6\tA!\u0003\u0002m\t\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006]\u001a\u0004\ra\\\u0001\u0007m\u0006dW/Z:\u0011\u0007A\u001cX/D\u0001r\u0015\u0005\u0011\u0018!B:dC2\f\u0017B\u0001;r\u0005)a$/\u001a9fCR,GM\u0010\t\u0005aZDx0\u0003\u0002xc\n1A+\u001e9mKJ\u0002\"!\u001f?\u000f\u0005AT\u0018BA>r\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m\f\bc\u00019\u0002\u0002%\u0019\u00111A9\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\b\u0001!I!!\u0003\u0002=M,G/\u00169SK2lunY6j]\u001eLe.U;feRL8i\u001c8uKb$H\u0003BA\u0006\u0003#\u00012\u0001]A\u0007\u0013\r\ty!\u001d\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0014\u0005\u0015\u0001\u0019AA\u000b\u0003\u0011\u0011X\r\\:\u0011\u0007A\u001c(\tC\u0004\u0002\u001a\u0001!I!a\u0007\u0002+M,G/\u00169SK2dun\\6va6{7m[5oOR1\u00111BA\u000f\u0003SA\u0001\"a\b\u0002\u0018\u0001\u0007\u0011\u0011E\u0001\nI&\u0014Xm\u0019;j_:\u0004B!a\t\u0002&5\ta#C\u0002\u0002(Y\u0011\u0011cU3nC:$\u0018n\u0019#je\u0016\u001cG/[8o\u0011!\tY#a\u0006A\u0002\u00055\u0012A\u0003:fYN\u0014\u0015PT8eKB1\u00110a\f,\u0003gI1!!\r\u007f\u0005\ri\u0015\r\u001d\t\u0006\u0003k\t)E\u0011\b\u0005\u0003o\t\tE\u0004\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004E\u0001\u0007yI|w\u000e\u001e \n\u0003IL1!a\u0011r\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0012\u0002J\t\u00191+Z9\u000b\u0007\u0005\r\u0013\u000fC\u0004\u0002N\u0001!I!a\u0014\u0002\u001b9,w/T8dW\u0016$gj\u001c3f)\rY\u0013\u0011\u000b\u0005\t\u0003'\nY\u00051\u0001\u0002V\u0005\u0011\u0011\u000e\u001a\t\u0004a\u0006]\u0013bAA-c\n\u0019\u0011J\u001c;\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\u0005)b.Z<N_\u000e\\W\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004Hc\u0002\"\u0002b\u0005\r\u0014Q\r\u0005\t\u0003'\nY\u00061\u0001\u0002V!1\u0011&a\u0017A\u0002-Bq!a\u001a\u0002\\\u0001\u00071&A\u0004f]\u0012tu\u000eZ3\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n\u0005ia.Z<N_\u000e\\W\r\u001a)ja\u0016$b!a\u001c\u0002v\u0005e\u0004cA\u0010\u0002r%\u0019\u00111\u000f\u0002\u0003\tAK\u0007/\u001a\u0005\b\u0003o\nI\u00071\u0001y\u0003\u0011qw\u000eZ3\t\u0011\u0005m\u0014\u0011\u000ea\u0001\u0003{\nAA]8xgB\u0019\u0001o]5\t\u000f\u0005-\u0004\u0001\"\u0003\u0002\u0002R1\u0011qNAB\u0003'C\u0001\"!\"\u0002\u0000\u0001\u0007\u0011qQ\u0001\bgfl'm\u001c7t!\u0019I\u0018q\u0006=\u0002\nB!\u00111RAH\u001b\t\tiIC\u0002\u0002\u0006ZIA!!%\u0002\u000e\nQ1)\u001f9iKJ$\u0016\u0010]3\t\u0011\u0005m\u0014q\u0010a\u0001\u0003{\u0002")
public class ExpandIntoPipeTest
extends CypherFunSuite {
    private final PipeMonitor monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));
    private final Node startNode = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(1);
    private final Node endNode1 = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(2);
    private final Node endNode2 = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(3);
    private final Node endNode3 = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(4);
    private final Relationship relationship1 = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(1, this.startNode(), this.endNode1());
    private final Relationship relationship2 = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(2, this.startNode(), this.endNode2());
    private final Relationship relationship3 = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(3, this.startNode(), this.endNode3());
    private final Relationship selfRelationship = this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(4, this.startNode(), this.startNode());
    private final QueryContext query = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
    private final QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.query(), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());

    public PipeMonitor monitor() {
        return this.monitor;
    }

    public Node startNode() {
        return this.startNode;
    }

    public Node endNode1() {
        return this.endNode1;
    }

    public Node endNode2() {
        return this.endNode2;
    }

    public Node endNode3() {
        return this.endNode3;
    }

    public Relationship relationship1() {
        return this.relationship1;
    }

    public Relationship relationship2() {
        return this.relationship2;
    }

    public Relationship relationship3() {
        return this.relationship3;
    }

    public Relationship selfRelationship() {
        return this.selfRelationship;
    }

    public QueryContext query() {
        return this.query;
    }

    public QueryState queryState() {
        return this.queryState;
    }

    public ExecutionContext org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row(Seq<Tuple2<String, Object>> values) {
        return ExecutionContext$.MODULE$.from(values);
    }

    public void org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext(Seq<Relationship> rels) {
        Map relsByStartNode = rels.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Node apply(Relationship x$3) {
                return x$3.getStartNode();
            }
        });
        Map relsByEndNode = rels.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Node apply(Relationship x$4) {
                return x$4.getEndNode();
            }
        });
        Map relsByNode = ((TraversableOnce)relsByStartNode.keySet().$plus$plus((GenTraversableOnce)relsByEndNode.keySet()).map((Function1)new Serializable(this, relsByStartNode, relsByEndNode){
            public static final long serialVersionUID = 0L;
            private final Map relsByStartNode$1;
            private final Map relsByEndNode$1;

            public final Tuple2<Node, Seq<Relationship>> apply(Node n2) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n2), ((TraversableLike)this.relsByStartNode$1.getOrElse((Object)n2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.empty();
                    }
                })).$plus$plus((GenTraversableOnce)this.relsByEndNode$1.getOrElse((Object)n2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.empty();
                    }
                }), Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.relsByStartNode$1 = relsByStartNode$1;
                this.relsByEndNode$1 = relsByEndNode$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.setUpRelLookupMocking((SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, (Map<Node, Seq<Relationship>>)relsByStartNode);
        this.setUpRelLookupMocking((SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Map<Node, Seq<Relationship>>)relsByEndNode);
        this.setUpRelLookupMocking((SemanticDirection)SemanticDirection.BOTH$.MODULE$, (Map<Node, Seq<Relationship>>)relsByNode);
    }

    private void setUpRelLookupMocking(SemanticDirection direction, Map<Node, Seq<Relationship>> relsByNode) {
        relsByNode.foreach((Function1)new Serializable(this, direction){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;
            private final SemanticDirection direction$1;

            public final OngoingStubbing<Object> apply(Tuple2<Node, Seq<Relationship>> x0$1) {
                Tuple2<Node, Seq<Relationship>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Node node2 = (Node)tuple2._1();
                    Seq rels = (Seq)tuple2._2();
                    Mockito.when((Object)this.$outer.query().getRelationshipsForIds(node2, this.direction$1, (Option)None$.MODULE$)).thenAnswer((Answer)new Answer<Iterator<Relationship>>(this, rels){
                        private final Seq rels$1;

                        public Iterator<Relationship> answer(InvocationOnMock invocation) {
                            return this.rels$1.iterator();
                        }
                        {
                            this.rels$1 = rels$1;
                        }
                    });
                    OngoingStubbing ongoingStubbing = Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.$outer.query().nodeGetDegree(node2.getId(), this.direction$1))).thenReturn((Object)BoxesRunTime.boxToInteger((int)rels.size()));
                    return ongoingStubbing;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.direction$1 = direction$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Node org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(int id) {
        void var2_2;
        Node node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        return var2_2;
    }

    public Relationship org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(int id, Node startNode, Node endNode) {
        Relationship relationship2 = (Relationship)this.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)relationship2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)relationship2.getStartNode()).thenReturn((Object)startNode);
        Mockito.when((Object)relationship2.getEndNode()).thenReturn((Object)endNode);
        Mockito.when((Object)relationship2.getOtherNode(startNode)).thenReturn((Object)endNode);
        Mockito.when((Object)relationship2.getOtherNode(endNode)).thenReturn((Object)startNode);
        return relationship2;
    }

    public Pipe org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe(String node2, Seq<ExecutionContext> rows) {
        return this.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe((Map<String, CypherType>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node2), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTNode())}))), rows);
    }

    /*
     * WARNING - void declaration
     */
    public Pipe org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe(Map<String, CypherType> symbols, Seq<ExecutionContext> rows) {
        void var3_3;
        Pipe pipe = (Pipe)this.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
        Mockito.when((Object)pipe.sources()).thenReturn((Object)Seq$.MODULE$.empty());
        Mockito.when((Object)pipe.symbols()).thenReturn((Object)new SymbolTable(symbols));
        Mockito.when((Object)pipe.createResults((QueryState)Matchers.any())).thenAnswer((Answer)new Answer<Iterator<ExecutionContext>>(this, rows){
            private final Seq rows$1;

            public Iterator<ExecutionContext> answer(InvocationOnMock invocation) {
                return this.rows$1.iterator();
            }
            {
                this.rows$1 = rows$1;
            }
        });
        return var3_3;
    }

    public ExpandIntoPipeTest() {
        this.test("should support expand between two nodes with a relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1()}));
                Pipe x$5 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))}));
                String x$6 = "a";
                String x$7 = "r";
                String x$8 = "b";
                SemanticDirection.OUTGOING$ x$9 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$10 = LazyTypes$.MODULE$.empty();
                Option x$11 = ExpandIntoPipe$.MODULE$.apply$default$7(x$5, x$6, x$7, x$8, (SemanticDirection)x$9, x$10);
                List list = result = new ExpandIntoPipe(x$5, x$6, x$7, x$8, (SemanticDirection)x$9, x$10, x$11, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext single2 = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        ExecutionContext executionContext;
                        ExecutionContext single3 = executionContext = single2;
                        this.$outer.convertToAnyShouldWrapper(single3.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                        return;
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return no relationships for types that have not been defined yet", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.query().getRelationshipsForIds((Node)Matchers.any(), (SemanticDirection)Matchers.any(), (Option)Matchers.eq((Object)new Some((Object)Seq$.MODULE$.empty())))).thenAnswer((Answer)new Answer<Iterator<Relationship>>(this){

                    public Iterator<Nothing$> answer(InvocationOnMock invocationOnMock) {
                        return package$.MODULE$.Iterator().empty();
                    }
                });
                Mockito.when((Object)this.$outer.query().getRelationshipsForIds((Node)Matchers.any(), (SemanticDirection)Matchers.any(), (Option)Matchers.eq((Object)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))))).thenAnswer((Answer)new Answer<Iterator<Relationship>>(this){
                    private final /* synthetic */ $anonfun$2 $outer;

                    public Iterator<Relationship> answer(InvocationOnMock invocationOnMock) {
                        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$anonfun$$$outer().relationship1(), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$anonfun$$$outer().relationship2()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.$outer.query().nodeGetDegree(BoxesRunTime.unboxToLong((Object)Matchers.any()), (SemanticDirection)Matchers.any(), BoxesRunTime.unboxToInt((Object)Matchers.any())))).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
                Pipe x$12 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))}));
                String x$13 = "a";
                String x$14 = "r";
                String x$15 = "b";
                SemanticDirection.OUTGOING$ x$16 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$17 = new LazyTypes((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO", "BAR"})));
                Option x$18 = ExpandIntoPipe$.MODULE$.apply$default$7(x$12, x$13, x$14, x$15, (SemanticDirection)x$16, x$17);
                ExpandIntoPipe pipe = new ExpandIntoPipe(x$12, x$13, x$14, x$15, (SemanticDirection)x$16, x$17, x$18, this.$outer.monitor());
                Mockito.when((Object)this.$outer.query().getOptRelTypeId("FOO")).thenReturn((Object)None$.MODULE$);
                Mockito.when((Object)this.$outer.query().getOptRelTypeId("BAR")).thenReturn((Object)None$.MODULE$);
                List result1 = pipe.createResults(this.$outer.queryState()).toList();
                Mockito.when((Object)this.$outer.query().getOptRelTypeId("FOO")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.query().getOptRelTypeId("BAR")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                List result2 = pipe.createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result1).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(result2).should(this.$outer.not()).be(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }

            public /* synthetic */ ExpandIntoPipeTest org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support expand between two nodes with multiple relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1(), this.$outer.relationship2(), this.$outer.relationship3()}));
                Pipe x$19 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))}));
                String x$20 = "a";
                String x$21 = "r";
                String x$22 = "b";
                SemanticDirection.OUTGOING$ x$23 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$24 = LazyTypes$.MODULE$.empty();
                Option x$25 = ExpandIntoPipe$.MODULE$.apply$default$7(x$19, x$20, x$21, x$22, (SemanticDirection)x$23, x$24);
                List list = result = new ExpandIntoPipe(x$19, x$20, x$21, x$22, (SemanticDirection)x$23, x$24, x$25, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext first = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        ExecutionContext second = (ExecutionContext)colon3.head();
                        List list3 = colon3.tl$1();
                        if (Nil$.MODULE$.equals(list3)) {
                            Tuple2 tuple2;
                            Tuple2 tuple22 = tuple2 = new Tuple2((Object)first, (Object)second);
                            ExecutionContext first2 = (ExecutionContext)tuple22._1();
                            ExecutionContext second2 = (ExecutionContext)tuple22._2();
                            this.$outer.convertToAnyShouldWrapper(first2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                            this.$outer.convertToAnyShouldWrapper(second2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))), (Object)Equality$.MODULE$.default());
                            return;
                        }
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support expand between two nodes with multiple relationships and self loops", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1(), this.$outer.selfRelationship(), this.$outer.relationship3()}));
                Pipe x$26 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.startNode())}))}));
                String x$27 = "a";
                String x$28 = "r";
                String x$29 = "b";
                SemanticDirection.OUTGOING$ x$30 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$31 = LazyTypes$.MODULE$.empty();
                Option x$32 = ExpandIntoPipe$.MODULE$.apply$default$7(x$26, x$27, x$28, x$29, (SemanticDirection)x$30, x$31);
                List list = result = new ExpandIntoPipe(x$26, x$27, x$28, x$29, (SemanticDirection)x$30, x$31, x$32, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext first = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        ExecutionContext second = (ExecutionContext)colon3.head();
                        List list3 = colon3.tl$1();
                        if (Nil$.MODULE$.equals(list3)) {
                            Tuple2 tuple2;
                            Tuple2 tuple22 = tuple2 = new Tuple2((Object)first, (Object)second);
                            ExecutionContext first2 = (ExecutionContext)tuple22._1();
                            ExecutionContext second2 = (ExecutionContext)tuple22._2();
                            this.$outer.convertToAnyShouldWrapper(first2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                            this.$outer.convertToAnyShouldWrapper(second2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.selfRelationship()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.startNode())}))), (Object)Equality$.MODULE$.default());
                            return;
                        }
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given empty input, should return empty output", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Nil$.MODULE$);
                Pipe x$33 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)}))}));
                String x$34 = "a";
                String x$35 = "r";
                String x$36 = "b";
                SemanticDirection.OUTGOING$ x$37 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$38 = LazyTypes$.MODULE$.empty();
                Option x$39 = ExpandIntoPipe$.MODULE$.apply$default$7(x$33, x$34, x$35, x$36, (SemanticDirection)x$37, x$38);
                List result = new ExpandIntoPipe(x$33, x$34, x$35, x$36, (SemanticDirection)x$37, x$38, x$39, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given a null start point, returns an empty iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1()}));
                Pipe x$40 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))}));
                String x$41 = "a";
                String x$42 = "r";
                String x$43 = "b";
                SemanticDirection.OUTGOING$ x$44 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$45 = LazyTypes$.MODULE$.empty();
                Option x$46 = ExpandIntoPipe$.MODULE$.apply$default$7(x$40, x$41, x$42, x$43, (SemanticDirection)x$44, x$45);
                List result = new ExpandIntoPipe(x$40, x$41, x$42, x$43, (SemanticDirection)x$44, x$45, x$46, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given a null end point, returns an empty iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1()}));
                Pipe x$47 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)}))}));
                String x$48 = "a";
                String x$49 = "r";
                String x$50 = "b";
                SemanticDirection.OUTGOING$ x$51 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$52 = LazyTypes$.MODULE$.empty();
                Option x$53 = ExpandIntoPipe$.MODULE$.apply$default$7(x$47, x$48, x$49, x$50, (SemanticDirection)x$51, x$52);
                List result = new ExpandIntoPipe(x$47, x$48, x$49, x$50, (SemanticDirection)x$51, x$52, x$53, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("issue 4692 should respect relationship direction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe source;
                Node node0 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(0);
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(1);
                Relationship rel0 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(0, node0, node1);
                Relationship rel1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(1, node1, node0);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{rel0, rel1}));
                Pipe x$54 = source = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe((Map<String, CypherType>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTRelationship()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTNode())}))), (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node0)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node1)}))}));
                String x$55 = "n";
                String x$56 = "r1";
                String x$57 = "k";
                SemanticDirection.OUTGOING$ x$58 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$59 = LazyTypes$.MODULE$.empty();
                Option x$60 = ExpandIntoPipe$.MODULE$.apply$default$7(x$54, x$55, x$56, x$57, (SemanticDirection)x$58, x$59);
                List results = new ExpandIntoPipe(x$54, x$55, x$56, x$57, (SemanticDirection)x$58, x$59, x$60, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(results).should(this.$outer.contain()).theSameElementsAs((GenTraversable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r1"), (Object)rel1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel1)})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r1"), (Object)rel0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel0)}))})), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should work for bidirectional relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe source;
                Node node0 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(0);
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedNode(1);
                Relationship rel0 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(0, node0, node1);
                Relationship rel1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedRelationship(1, node1, node0);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$setUpRelMockingInQuertyContext((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{rel0, rel1}));
                Pipe x$61 = source = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$newMockedPipe((Map<String, CypherType>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTRelationship()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTNode())}))), (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node0)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$ExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node1)}))}));
                String x$62 = "n";
                String x$63 = "r1";
                String x$64 = "k";
                SemanticDirection.BOTH$ x$65 = SemanticDirection.BOTH$.MODULE$;
                LazyTypes x$66 = LazyTypes$.MODULE$.empty();
                Option x$67 = ExpandIntoPipe$.MODULE$.apply$default$7(x$61, x$62, x$63, x$64, (SemanticDirection)x$65, x$66);
                List results = new ExpandIntoPipe(x$61, x$62, x$63, x$64, (SemanticDirection)x$65, x$66, x$67, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(results).should(this.$outer.contain()).theSameElementsAs((GenTraversable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r1"), (Object)rel0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel1)})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r1"), (Object)rel1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel1)})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r1"), (Object)rel1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel0)})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r1"), (Object)rel0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)rel0)}))})), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
                ((QueryContext)Mockito.verify((Object)this.$outer.query(), (VerificationMode)Mockito.times((int)1))).getRelationshipsForIds((Node)Matchers.any(), (SemanticDirection)Matchers.eq((Object)SemanticDirection.BOTH$.MODULE$), (Option)Matchers.eq((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

