/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.pipes;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeHashJoinPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeHashJoinPipe$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable;
import org.neo4j.cypher.internal.compiler.v2_3.test_helpers.TestableIterator;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.package$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001#\t!bj\u001c3f\u0011\u0006\u001c\bNS8j]BK\u0007/\u001a+fgRT!a\u0001\u0003\u0002\u000bAL\u0007/Z:\u000b\u0005\u00151\u0011\u0001\u0002<3?NR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001435\tAC\u0003\u0002\u0016-\u0005aA/Z:u?\",G\u000e]3sg*\u0011Qa\u0006\u0006\u00031!\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00035Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u0005!9\u0011\u0005\u0001b\u0001\n\u0007\u0011\u0013aB7p]&$xN]\u000b\u0002GA\u0011q\u0004J\u0005\u0003K\t\u00111\u0002U5qK6{g.\u001b;pe\"1q\u0005\u0001Q\u0001\n\r\n\u0001\"\\8oSR|'\u000f\t\u0005\u0006S\u0001!IAK\u0001\u0004e><HCA\u00160!\taS&D\u0001\u0005\u0013\tqCA\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")\u0001\u0007\u000ba\u0001c\u00051a/\u00197vKN\u00042AM\u001b8\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$A\u0003\u001fsKB,\u0017\r^3e}A!!\u0007\u000f\u001eB\u0013\tI4G\u0001\u0004UkBdWM\r\t\u0003wyr!A\r\u001f\n\u0005u\u001a\u0014A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!P\u001a\u0011\u0005I\u0012\u0015BA\"4\u0005\r\te.\u001f\u0005\u0006\u000b\u0002!IAR\u0001\u000e]\u0016<Xj\\2lK\u0012tu\u000eZ3\u0015\u0005\u001dk\u0005C\u0001%L\u001b\u0005I%B\u0001&\r\u0003\u001d9'/\u00199iI\nL!\u0001T%\u0003\t9{G-\u001a\u0005\u0006\u001d\u0012\u0003\raT\u0001\u0003S\u0012\u0004\"A\r)\n\u0005E\u001b$aA%oi\")1\u000b\u0001C\u0005)\u0006ia.Z<N_\u000e\\W\r\u001a)ja\u0016$\"!\u0016-\u0011\u0005}1\u0016BA,\u0003\u0005\u0011\u0001\u0016\u000e]3\t\u000be\u0013\u0006\u0019\u0001.\u0002\u0017MLXNY8m)\u0006\u0014G.\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u0012\tqa]=nE>d7/\u0003\u0002`9\nY1+_7c_2$\u0016M\u00197f\u0001")
public class NodeHashJoinPipeTest
extends CypherFunSuite {
    private final PipeMonitor monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));

    public PipeMonitor monitor() {
        return this.monitor;
    }

    public ExecutionContext org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row(Seq<Tuple2<String, Object>> values) {
        return ExecutionContext$.MODULE$.from(values);
    }

    /*
     * WARNING - void declaration
     */
    public Node org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(int id) {
        void var2_2;
        Node node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)node2.toString()).thenReturn((Object)new StringBuilder().append((Object)"node - ").append((Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString()).toString());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Pipe org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(SymbolTable symbolTable) {
        void var2_2;
        Pipe pipe = (Pipe)this.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
        Mockito.when((Object)pipe.sources()).thenReturn((Object)Seq$.MODULE$.empty());
        Mockito.when((Object)pipe.symbols()).thenReturn((Object)symbolTable);
        return var2_2;
    }

    public NodeHashJoinPipeTest() {
        this.test("should support simple hash join over nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                Node node3 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(3);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2)}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node3)}))})));
                Set x$2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$3 = left;
                Pipe x$4 = right;
                Option x$5 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$2, x$3, x$4);
                Iterator result = new NodeHashJoinPipe(x$2, x$3, x$4, x$5, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$1) {
                        return x$1.apply((Object)"b");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{node2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support joining on two different identifiers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node0 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(0);
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)2))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)3))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)4))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)5))}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)1))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)2))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)3))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)4))}))})));
                Set x$6 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
                Pipe x$7 = left;
                Pipe x$8 = right;
                Option x$9 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$6, x$7, x$8);
                List result = new NodeHashJoinPipe(x$6, x$7, x$8, x$9, this.$outer.monitor()).createResults(queryState).toList();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)1))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)2))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)2))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should work when the inner pipe produces multiple rows with the same join key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))})));
                Set x$10 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$11 = left;
                Pipe x$12 = right;
                Option x$13 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$10, x$11, x$12);
                Iterator result = new NodeHashJoinPipe(x$10, x$11, x$12, x$13, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should work when the outer pipe produces rows with a null key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))})));
                Set x$14 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$15 = left;
                Pipe x$16 = right;
                Option x$17 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$14, x$15, x$16);
                Iterator result = new NodeHashJoinPipe(x$14, x$15, x$16, x$17, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should work when the inner pipe produces rows with a null key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))})));
                Set x$18 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$19 = left;
                Pipe x$20 = right;
                Option x$21 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$18, x$19, x$20);
                Iterator result = new NodeHashJoinPipe(x$18, x$19, x$20, x$21, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch results from RHS if LHS is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().empty());
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Set x$22 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$23 = left;
                Pipe x$24 = right;
                Option x$25 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$22, x$23, x$24);
                Iterator result = new NodeHashJoinPipe(x$22, x$23, x$24, x$25, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                ((Pipe)Mockito.verify((Object)right, (VerificationMode)Mockito.times((int)0))).createResults((QueryState)Matchers.any());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch results from RHS if no probe table was built", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                TestableIterator<A> rhsIterator = new TestableIterator<A>(scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(0))}))})));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().empty());
                Set x$26 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$27 = left;
                Pipe x$28 = right;
                Option x$29 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$26, x$27, x$28);
                Iterator result = new NodeHashJoinPipe(x$26, x$27, x$28, x$29, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)rhsIterator.fetched())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if RHS is empty, terminate building of the probe map early", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                TestableIterator<A> lhsIterator = new TestableIterator<A>(scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node1)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2)}))})));
                Mockito.when((Object)left.createResults(queryState)).thenReturn(lhsIterator);
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().empty());
                Set x$30 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$31 = left;
                Pipe x$32 = right;
                Option x$33 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$30, x$31, x$32);
                Iterator result = new NodeHashJoinPipe(x$30, x$31, x$32, x$33, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)lhsIterator.fetched())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

