/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.pipes;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Not;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.True;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.FakePipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyTypes;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyTypes$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.OptionalExpandIntoPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.OptionalExpandIntoPipe$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_3.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001E\u0011!d\u00149uS>t\u0017\r\\#ya\u0006tG-\u00138u_BK\u0007/\u001a+fgRT!a\u0001\u0003\u0002\u000bAL\u0007/Z:\u000b\u0005\u00151\u0011\u0001\u0002<3?NR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001435\tAC\u0003\u0002\u0016-\u0005aA/Z:u?\",G\u000e]3sg*\u0011Qa\u0006\u0006\u00031!\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00035Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u0005!9\u0011\u0005\u0001b\u0001\n\u0007\u0011\u0013aB7p]&$xN]\u000b\u0002GA\u0011q\u0004J\u0005\u0003K\t\u00111\u0002U5qK6{g.\u001b;pe\"1q\u0005\u0001Q\u0001\n\r\n\u0001\"\\8oSR|'\u000f\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0003%\u0019H/\u0019:u\u001d>$W-F\u0001,!\tas&D\u0001.\u0015\tqC\"A\u0004he\u0006\u0004\b\u000e\u001a2\n\u0005Aj#\u0001\u0002(pI\u0016DaA\r\u0001!\u0002\u0013Y\u0013AC:uCJ$hj\u001c3fA!9A\u0007\u0001b\u0001\n\u0003Q\u0013\u0001C3oI:{G-Z\u0019\t\rY\u0002\u0001\u0015!\u0003,\u0003%)g\u000e\u001a(pI\u0016\f\u0004\u0005C\u00049\u0001\t\u0007I\u0011\u0001\u0016\u0002\u0011\u0015tGMT8eKJBaA\u000f\u0001!\u0002\u0013Y\u0013!C3oI:{G-\u001a\u001a!\u0011\u001da\u0004A1A\u0005\u0002)\n\u0001\"\u001a8e\u001d>$Wm\r\u0005\u0007}\u0001\u0001\u000b\u0011B\u0016\u0002\u0013\u0015tGMT8eKN\u0002\u0003b\u0002!\u0001\u0005\u0004%\t!Q\u0001\u000ee\u0016d\u0017\r^5p]ND\u0017\u000e]\u0019\u0016\u0003\t\u0003\"\u0001L\"\n\u0005\u0011k#\u0001\u0004*fY\u0006$\u0018n\u001c8tQ&\u0004\bB\u0002$\u0001A\u0003%!)\u0001\bsK2\fG/[8og\"L\u0007/\r\u0011\t\u000f!\u0003!\u0019!C\u0001\u0003\u0006i!/\u001a7bi&|gn\u001d5jaJBaA\u0013\u0001!\u0002\u0013\u0011\u0015A\u0004:fY\u0006$\u0018n\u001c8tQ&\u0004(\u0007\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001B\u00035\u0011X\r\\1uS>t7\u000f[5qg!1a\n\u0001Q\u0001\n\t\u000baB]3mCRLwN\\:iSB\u001c\u0004\u0005C\u0004Q\u0001\t\u0007I\u0011A!\u0002!M,GN\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004\bB\u0002*\u0001A\u0003%!)A\ttK24'+\u001a7bi&|gn\u001d5ja\u0002Bq\u0001\u0016\u0001C\u0002\u0013\u0005Q+A\u0003rk\u0016\u0014\u00180F\u0001W!\t9&,D\u0001Y\u0015\tIF!A\u0002ta&L!a\u0017-\u0003\u0019E+XM]=D_:$X\r\u001f;\t\ru\u0003\u0001\u0015!\u0003W\u0003\u0019\tX/\u001a:zA!9q\f\u0001b\u0001\n\u0003\u0001\u0017AC9vKJL8\u000b^1uKV\t\u0011\r\u0005\u0002 E&\u00111M\u0001\u0002\u000b#V,'/_*uCR,\u0007BB3\u0001A\u0003%\u0011-A\u0006rk\u0016\u0014\u0018p\u0015;bi\u0016\u0004\u0003\"B4\u0001\t\u0013A\u0017!E7pG.\u0014V\r\\1uS>t7\u000f[5qgR\u0011\u0011n\u001c\t\u0003U6l\u0011a\u001b\u0006\u0002Y\u0006)1oY1mC&\u0011an\u001b\u0002\u0005+:LG\u000fC\u0003qM\u0002\u0007\u0011/\u0001\u0003sK2\u001c\bc\u00016s\u0005&\u00111o\u001b\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\"B;\u0001\t\u00131\u0018a\u0001:poR\u0011qo\u001f\t\u0003qfl\u0011\u0001B\u0005\u0003u\u0012\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000bq$\b\u0019A?\u0002\rY\fG.^3t!\rQ'O \t\u0007U~\f\u0019!!\u0005\n\u0007\u0005\u00051N\u0001\u0004UkBdWM\r\t\u0005\u0003\u000b\tYAD\u0002k\u0003\u000fI1!!\u0003l\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\b\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011B6\u0011\u0007)\f\u0019\"C\u0002\u0002\u0016-\u00141!\u00118z\u0011\u001d\tI\u0002\u0001C\u0005\u00037\tQB\\3x\u001b>\u001c7.\u001a3O_\u0012,GcA\u0016\u0002\u001e!A\u0011qDA\f\u0001\u0004\t\t#\u0001\u0002jIB\u0019!.a\t\n\u0007\u0005\u00152NA\u0002J]RDq!!\u000b\u0001\t\u0013\tY#A\u000boK^lunY6fIJ+G.\u0019;j_:\u001c\b.\u001b9\u0015\u000f\t\u000bi#a\f\u00022!A\u0011qDA\u0014\u0001\u0004\t\t\u0003\u0003\u0004*\u0003O\u0001\ra\u000b\u0005\b\u0003g\t9\u00031\u0001,\u0003\u001d)g\u000e\u001a(pI\u0016Dq!a\u000e\u0001\t\u0013\tI$A\u0007oK^lunY6fIBK\u0007/\u001a\u000b\u0007\u0003w\t\t%!\u0012\u0011\u0007}\ti$C\u0002\u0002@\t\u0011A\u0001U5qK\"A\u00111IA\u001b\u0001\u0004\t\u0019!\u0001\u0003o_\u0012,\u0007\u0002CA$\u0003k\u0001\r!!\u0013\u0002\tI|wo\u001d\t\u0004UJ<\b")
public class OptionalExpandIntoPipeTest
extends CypherFunSuite {
    private final PipeMonitor monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));
    private final Node startNode = this.newMockedNode(1);
    private final Node endNode1 = this.newMockedNode(2);
    private final Node endNode2 = this.newMockedNode(3);
    private final Node endNode3 = this.newMockedNode(4);
    private final Relationship relationship1 = this.newMockedRelationship(1, this.startNode(), this.endNode1());
    private final Relationship relationship2 = this.newMockedRelationship(2, this.startNode(), this.endNode2());
    private final Relationship relationship3 = this.newMockedRelationship(3, this.startNode(), this.endNode3());
    private final Relationship selfRelationship = this.newMockedRelationship(4, this.startNode(), this.startNode());
    private final QueryContext query = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
    private final QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.query(), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());

    public PipeMonitor monitor() {
        return this.monitor;
    }

    public Node startNode() {
        return this.startNode;
    }

    public Node endNode1() {
        return this.endNode1;
    }

    public Node endNode2() {
        return this.endNode2;
    }

    public Node endNode3() {
        return this.endNode3;
    }

    public Relationship relationship1() {
        return this.relationship1;
    }

    public Relationship relationship2() {
        return this.relationship2;
    }

    public Relationship relationship3() {
        return this.relationship3;
    }

    public Relationship selfRelationship() {
        return this.selfRelationship;
    }

    public QueryContext query() {
        return this.query;
    }

    public QueryState queryState() {
        return this.queryState;
    }

    public void org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships(Seq<Relationship> rels) {
        Mockito.when((Object)this.query().getRelationshipsForIds((Node)Matchers.any(), (SemanticDirection)Matchers.any(), (Option)Matchers.any())).thenAnswer((Answer)new Answer<Iterator<Relationship>>(this, rels){
            private final Seq rels$1;

            public Iterator<Relationship> answer(InvocationOnMock invocation) {
                return this.rels$1.iterator();
            }
            {
                this.rels$1 = rels$1;
            }
        });
    }

    public ExecutionContext org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row(Seq<Tuple2<String, Object>> values) {
        return ExecutionContext$.MODULE$.from(values);
    }

    /*
     * WARNING - void declaration
     */
    private Node newMockedNode(int id) {
        void var2_2;
        Node node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        return var2_2;
    }

    private Relationship newMockedRelationship(int id, Node startNode, Node endNode) {
        Relationship relationship2 = (Relationship)this.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)relationship2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)relationship2.getStartNode()).thenReturn((Object)startNode);
        Mockito.when((Object)relationship2.getEndNode()).thenReturn((Object)endNode);
        Mockito.when((Object)relationship2.getOtherNode(startNode)).thenReturn((Object)endNode);
        Mockito.when((Object)relationship2.getOtherNode(endNode)).thenReturn((Object)startNode);
        return relationship2;
    }

    /*
     * WARNING - void declaration
     */
    public Pipe org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe(String node2, Seq<ExecutionContext> rows) {
        void var3_3;
        Pipe pipe = (Pipe)this.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
        Mockito.when((Object)pipe.sources()).thenReturn((Object)Seq$.MODULE$.empty());
        Mockito.when((Object)pipe.symbols()).thenReturn((Object)new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node2), (Object)org.neo4j.cypher.internal.frontend.v2_3.symbols.package$.MODULE$.CTNode())}))));
        Mockito.when((Object)pipe.createResults((QueryState)Matchers.any())).thenAnswer((Answer)new Answer<Iterator<ExecutionContext>>(this, rows){
            private final Seq rows$1;

            public Iterator<ExecutionContext> answer(InvocationOnMock invocation) {
                return this.rows$1.iterator();
            }
            {
                this.rows$1 = rows$1;
            }
        });
        return var3_3;
    }

    public OptionalExpandIntoPipeTest() {
        this.test("should support expand between two nodes with a relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1()}));
                Pipe x$3 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))}));
                String x$4 = "a";
                String x$5 = "r";
                String x$6 = "b";
                SemanticDirection.OUTGOING$ x$7 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$8 = LazyTypes$.MODULE$.empty();
                True x$9 = new True();
                Option x$10 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$3, x$4, x$5, x$6, (SemanticDirection)x$7, x$8, (Predicate)x$9);
                List list = result = new OptionalExpandIntoPipe(x$3, x$4, x$5, x$6, (SemanticDirection)x$7, x$8, (Predicate)x$9, x$10, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext single2 = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        ExecutionContext executionContext;
                        ExecutionContext single3 = executionContext = single2;
                        this.$outer.convertToAnyShouldWrapper(single3.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                        return;
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support optional expand from a node with no relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Nil$.MODULE$);
                Pipe x$11 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))}));
                String x$12 = "a";
                String x$13 = "r";
                String x$14 = "b";
                SemanticDirection.OUTGOING$ x$15 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$16 = LazyTypes$.MODULE$.empty();
                True x$17 = new True();
                Option x$18 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$11, x$12, x$13, x$14, (SemanticDirection)x$15, x$16, (Predicate)x$17);
                List list = result = new OptionalExpandIntoPipe(x$11, x$12, x$13, x$14, (SemanticDirection)x$15, x$16, (Predicate)x$17, x$18, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext single2 = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        ExecutionContext executionContext;
                        ExecutionContext single3 = executionContext = single2;
                        this.$outer.convertToAnyShouldWrapper(single3.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                        return;
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find null when two nodes have no shared relationships but do have some rels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1()}));
                Pipe x$19 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))}));
                String x$20 = "a";
                String x$21 = "r";
                String x$22 = "b";
                SemanticDirection.OUTGOING$ x$23 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$24 = LazyTypes$.MODULE$.empty();
                True x$25 = new True();
                Option x$26 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$19, x$20, x$21, x$22, (SemanticDirection)x$23, x$24, (Predicate)x$25);
                List list = result = new OptionalExpandIntoPipe(x$19, x$20, x$21, x$22, (SemanticDirection)x$23, x$24, (Predicate)x$25, x$26, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext single2 = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        ExecutionContext executionContext;
                        ExecutionContext single3 = executionContext = single2;
                        this.$outer.convertToAnyShouldWrapper(single3.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))), (Object)Equality$.MODULE$.default());
                        return;
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should filter out relationships not matching the end node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1(), this.$outer.relationship2()}));
                Pipe x$27 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))}));
                String x$28 = "a";
                String x$29 = "r";
                String x$30 = "b";
                SemanticDirection.OUTGOING$ x$31 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$32 = LazyTypes$.MODULE$.empty();
                True x$33 = new True();
                Option x$34 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$27, x$28, x$29, x$30, (SemanticDirection)x$31, x$32, (Predicate)x$33);
                List list = result = new OptionalExpandIntoPipe(x$27, x$28, x$29, x$30, (SemanticDirection)x$31, x$32, (Predicate)x$33, x$34, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext single2 = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        ExecutionContext executionContext;
                        ExecutionContext single3 = executionContext = single2;
                        this.$outer.convertToAnyShouldWrapper(single3.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))), (Object)Equality$.MODULE$.default());
                        return;
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support optional expand from a node with relationships that do not match the predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1()}));
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))}));
                Not falsePredicate = new Not((Predicate)new True());
                Pipe x$35 = left;
                String x$36 = "a";
                String x$37 = "r";
                String x$38 = "b";
                SemanticDirection.OUTGOING$ x$39 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$40 = LazyTypes$.MODULE$.empty();
                Not x$41 = falsePredicate;
                Option x$42 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$35, x$36, x$37, x$38, (SemanticDirection)x$39, x$40, (Predicate)x$41);
                List list = result = new OptionalExpandIntoPipe(x$35, x$36, x$37, x$38, (SemanticDirection)x$39, x$40, (Predicate)x$41, x$42, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext single2 = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        ExecutionContext executionContext;
                        ExecutionContext single3 = executionContext = single2;
                        this.$outer.convertToAnyShouldWrapper(single3.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                        return;
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support expand between two nodes with multiple relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1(), this.$outer.relationship2(), this.$outer.relationship3()}));
                Pipe x$43 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))}));
                String x$44 = "a";
                String x$45 = "r";
                String x$46 = "b";
                SemanticDirection.OUTGOING$ x$47 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$48 = LazyTypes$.MODULE$.empty();
                True x$49 = new True();
                Option x$50 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$43, x$44, x$45, x$46, (SemanticDirection)x$47, x$48, (Predicate)x$49);
                List list = result = new OptionalExpandIntoPipe(x$43, x$44, x$45, x$46, (SemanticDirection)x$47, x$48, (Predicate)x$49, x$50, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext first = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        ExecutionContext second = (ExecutionContext)colon3.head();
                        List list3 = colon3.tl$1();
                        if (Nil$.MODULE$.equals(list3)) {
                            Tuple2 tuple2;
                            Tuple2 tuple22 = tuple2 = new Tuple2((Object)first, (Object)second);
                            ExecutionContext first2 = (ExecutionContext)tuple22._1();
                            ExecutionContext second2 = (ExecutionContext)tuple22._2();
                            this.$outer.convertToAnyShouldWrapper(first2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                            this.$outer.convertToAnyShouldWrapper(second2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode2())}))), (Object)Equality$.MODULE$.default());
                            return;
                        }
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support expand between two nodes with multiple relationships and self loops", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List result;
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.relationship1(), this.$outer.selfRelationship(), this.$outer.relationship3()}));
                Pipe x$51 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())})), this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.startNode())}))}));
                String x$52 = "a";
                String x$53 = "r";
                String x$54 = "b";
                SemanticDirection.OUTGOING$ x$55 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$56 = LazyTypes$.MODULE$.empty();
                True x$57 = new True();
                Option x$58 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$51, x$52, x$53, x$54, (SemanticDirection)x$55, x$56, (Predicate)x$57);
                List list = result = new OptionalExpandIntoPipe(x$51, x$52, x$53, x$54, (SemanticDirection)x$55, x$56, (Predicate)x$57, x$58, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    ExecutionContext first = (ExecutionContext)colon2.head();
                    List list2 = colon2.tl$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        ExecutionContext second = (ExecutionContext)colon3.head();
                        List list3 = colon3.tl$1();
                        if (Nil$.MODULE$.equals(list3)) {
                            Tuple2 tuple2;
                            Tuple2 tuple22 = tuple2 = new Tuple2((Object)first, (Object)second);
                            ExecutionContext first2 = (ExecutionContext)tuple22._1();
                            ExecutionContext second2 = (ExecutionContext)tuple22._2();
                            this.$outer.convertToAnyShouldWrapper(first2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.relationship1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.endNode1())}))), (Object)Equality$.MODULE$.default());
                            this.$outer.convertToAnyShouldWrapper(second2.m()).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.$outer.startNode()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)this.$outer.selfRelationship()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.$outer.startNode())}))), (Object)Equality$.MODULE$.default());
                            return;
                        }
                    }
                }
                throw new MatchError((Object)list);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given empty input, should return empty output", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;
            private static Symbol symbol$1;

            static {
                symbol$1 = Symbol$.MODULE$.apply("empty");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe left;
                this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$mockRelationships((Seq<Relationship>)Nil$.MODULE$);
                Pipe x$59 = left = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$OptionalExpandIntoPipeTest$$newMockedPipe("a", (Seq<ExecutionContext>)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[0]));
                String x$60 = "a";
                String x$61 = "r";
                String x$62 = "b";
                SemanticDirection.OUTGOING$ x$63 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$64 = LazyTypes$.MODULE$.empty();
                True x$65 = new True();
                Option x$66 = OptionalExpandIntoPipe$.MODULE$.apply$default$8(x$59, x$60, x$61, x$62, (SemanticDirection)x$63, x$64, (Predicate)x$65);
                List result = new OptionalExpandIntoPipe(x$59, x$60, x$61, x$62, (SemanticDirection)x$63, x$64, (Predicate)x$65, x$66, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(symbol$1, Predef$.MODULE$.$conforms());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("expand into null should return nulled row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FakePipe input;
                Node node2 = (Node)this.$outer.mock(ManifestFactory$.MODULE$.classType(Node.class));
                FakePipe x$67 = input = new FakePipe((Iterator<Map<String, Object>>)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)}))})), (Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                String x$68 = "a";
                String x$69 = "r";
                String x$70 = "b";
                SemanticDirection.OUTGOING$ x$71 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$72 = LazyTypes$.MODULE$.empty();
                True x$73 = new True();
                Option x$74 = OptionalExpandIntoPipe$.MODULE$.apply$default$8((Pipe)x$67, x$68, x$69, x$70, (SemanticDirection)x$71, x$72, (Predicate)x$73);
                List result = new OptionalExpandIntoPipe((Pipe)x$67, x$68, x$69, x$70, (SemanticDirection)x$71, x$72, (Predicate)x$73, x$74, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("expand null into something should return nulled row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FakePipe input;
                Node node2 = (Node)this.$outer.mock(ManifestFactory$.MODULE$.classType(Node.class));
                FakePipe x$75 = input = new FakePipe((Iterator<Map<String, Object>>)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2)}))})), (Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                String x$76 = "a";
                String x$77 = "r";
                String x$78 = "b";
                SemanticDirection.OUTGOING$ x$79 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$80 = LazyTypes$.MODULE$.empty();
                True x$81 = new True();
                Option x$82 = OptionalExpandIntoPipe$.MODULE$.apply$default$8((Pipe)x$75, x$76, x$77, x$78, (SemanticDirection)x$79, x$80, (Predicate)x$81);
                List result = new OptionalExpandIntoPipe((Pipe)x$75, x$76, x$77, x$78, (SemanticDirection)x$79, x$80, (Predicate)x$81, x$82, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)node2)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("expand null into null should return nulled row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptionalExpandIntoPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FakePipe input;
                FakePipe x$83 = input = new FakePipe((Iterator<Map<String, Object>>)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)}))})), (Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                String x$84 = "a";
                String x$85 = "r";
                String x$86 = "b";
                SemanticDirection.OUTGOING$ x$87 = SemanticDirection.OUTGOING$.MODULE$;
                LazyTypes x$88 = LazyTypes$.MODULE$.empty();
                True x$89 = new True();
                Option x$90 = OptionalExpandIntoPipe$.MODULE$.apply$default$8((Pipe)x$83, x$84, x$85, x$86, (SemanticDirection)x$87, x$88, (Predicate)x$89);
                List result = new OptionalExpandIntoPipe((Pipe)x$83, x$84, x$85, x$86, (SemanticDirection)x$87, x$88, (Predicate)x$89, x$90, this.$outer.monitor()).createResults(this.$outer.queryState()).toList();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

