/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_0.commands.expressions;

import org.neo4j.cypher.internal.compiler.v3_0.commands.expressions.CRS;
import org.neo4j.cypher.internal.compiler.v3_0.commands.expressions.CRS$;
import org.neo4j.cypher.internal.compiler.v3_0.commands.expressions.DistanceCalculator;
import org.neo4j.cypher.internal.compiler.v3_0.commands.expressions.DistanceCalculator$class;
import org.neo4j.cypher.internal.compiler.v3_0.commands.expressions.Geometry;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;

public final class HaversinCalculator$
implements DistanceCalculator {
    public static final HaversinCalculator$ MODULE$;
    private final double EARTH_RADIUS_METERS;

    static {
        new HaversinCalculator$();
    }

    @Override
    public Option<Object> apply(Geometry p1, Geometry p2) {
        return DistanceCalculator$class.apply(this, p1, p2);
    }

    private double EARTH_RADIUS_METERS() {
        return this.EARTH_RADIUS_METERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDefinedAt(Geometry p1, Geometry p2) {
        CRS cRS = p1.crs();
        CRS cRS2 = CRS$.MODULE$.WGS84();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!((Object)cRS).equals(cRS2)) return false;
        CRS cRS3 = p2.crs();
        CRS cRS4 = CRS$.MODULE$.WGS84();
        if (cRS3 == null) {
            if (cRS4 == null) return true;
            return false;
        } else {
            if (!((Object)cRS3).equals(cRS4)) return false;
            return true;
        }
    }

    @Override
    public double calculateDistance(Geometry p1, Geometry p2) {
        Seq c1 = (Seq)p1.coordinates().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return Math.toRadians(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq c2 = (Seq)p2.coordinates().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return Math.toRadians(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom());
        double dx = BoxesRunTime.unboxToDouble((Object)c2.apply(0)) - BoxesRunTime.unboxToDouble((Object)c1.apply(0));
        double dy = BoxesRunTime.unboxToDouble((Object)c2.apply(1)) - BoxesRunTime.unboxToDouble((Object)c1.apply(1));
        double a = Math.pow(Math.sin(dy / (double)2), 2.0) + Math.cos(BoxesRunTime.unboxToDouble((Object)c1.apply(1))) * Math.cos(BoxesRunTime.unboxToDouble((Object)c2.apply(1))) * Math.pow(Math.sin(dx / 2.0), 2.0);
        double greatCircleDistance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return this.EARTH_RADIUS_METERS() * greatCircleDistance;
    }

    private HaversinCalculator$() {
        MODULE$ = this;
        DistanceCalculator$class.$init$(this);
        this.EARTH_RADIUS_METERS = 6378140.0;
    }
}

