/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_2.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.neo4j.cypher.internal.compiler.v3_2.spi.NodeIdWrapper;
import org.neo4j.cypher.internal.compiler.v3_2.spi.RelationshipIdWrapper;
import org.neo4j.cypher.internal.frontend.v3_2.IncomparableValuesException;
import org.neo4j.cypher.internal.frontend.v3_2.UnorderableValueException;
import org.neo4j.graphdb.Path;
import org.neo4j.helpers.MathUtil;

public class CypherOrderability {
    private static Comparator<Object> FALLBACK_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            if (lhs.getClass().isAssignableFrom(rhs.getClass()) && lhs instanceof Comparable && rhs instanceof Comparable) {
                return ((Comparable)lhs).compareTo(rhs);
            }
            throw new IncomparableValuesException(lhs.getClass().getSimpleName(), rhs.getClass().getSimpleName());
        }
    };
    private static Comparator<Object> VOID_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            return 0;
        }
    };
    private static Comparator<Number> NUMBER_COMPARATOR = new Comparator<Number>(){

        @Override
        public int compare(Number lhs, Number rhs) {
            if (lhs instanceof Double && rhs instanceof Float) {
                return ((Double)lhs).compareTo(rhs.doubleValue());
            }
            if (lhs instanceof Float && rhs instanceof Double) {
                return -((Double)rhs).compareTo(lhs.doubleValue());
            }
            if (lhs instanceof Float && rhs instanceof Float) {
                return ((Float)lhs).compareTo((Float)rhs);
            }
            if (lhs instanceof Double && rhs instanceof Double) {
                return ((Double)lhs).compareTo((Double)rhs);
            }
            if (lhs instanceof Double || lhs instanceof Float) {
                return MathUtil.compareDoubleAgainstLong((double)lhs.doubleValue(), (long)rhs.longValue());
            }
            if (rhs instanceof Double || rhs instanceof Float) {
                return -MathUtil.compareDoubleAgainstLong((double)rhs.doubleValue(), (long)lhs.longValue());
            }
            return Long.compare(lhs.longValue(), rhs.longValue());
        }
    };
    private static Comparator<Object> STRING_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            if (lhs instanceof Character && rhs instanceof String) {
                return lhs.toString().compareTo((String)rhs);
            }
            if (lhs instanceof String && rhs instanceof Character) {
                return ((String)lhs).compareTo(rhs.toString());
            }
            return ((Comparable)lhs).compareTo(rhs);
        }
    };
    private static Comparator<Boolean> BOOLEAN_COMPARATOR = new Comparator<Boolean>(){

        @Override
        public int compare(Boolean lhs, Boolean rhs) {
            return lhs.compareTo(rhs);
        }
    };
    private static Comparator<NodeIdWrapper> NODE_COMPARATOR = new Comparator<NodeIdWrapper>(){

        @Override
        public int compare(NodeIdWrapper lhs, NodeIdWrapper rhs) {
            return Long.compare(lhs.id(), rhs.id());
        }
    };
    private static Comparator<RelationshipIdWrapper> RELATIONSHIP_COMPARATOR = new Comparator<RelationshipIdWrapper>(){

        @Override
        public int compare(RelationshipIdWrapper lhs, RelationshipIdWrapper rhs) {
            return Long.compare(lhs.id(), rhs.id());
        }
    };
    private static Comparator<Path> PATH_COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path lhs, Path rhs) {
            Iterator lhsIter = lhs.iterator();
            Iterator rhsIter = lhs.iterator();
            while (lhsIter.hasNext() && rhsIter.hasNext()) {
                int result2 = CypherOrderability.compare(lhsIter.next(), rhsIter.next());
                if (0 == result2) continue;
                return result2;
            }
            return lhsIter.hasNext() ? 1 : (rhsIter.hasNext() ? -1 : 0);
        }
    };
    private static Comparator<Object> LIST_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            Iterator lhsIter = this.toIterator(lhs);
            Iterator rhsIter = this.toIterator(rhs);
            while (lhsIter.hasNext() && rhsIter.hasNext()) {
                int result2 = CypherOrderability.compare(lhsIter.next(), rhsIter.next());
                if (0 == result2) continue;
                return result2;
            }
            return lhsIter.hasNext() ? 1 : (rhsIter.hasNext() ? -1 : 0);
        }

        private Iterator toIterator(Object o) {
            Class<?> clazz = o.getClass();
            if (Iterable.class.isAssignableFrom(clazz)) {
                return ((Iterable)o).iterator();
            }
            if (Object[].class.isAssignableFrom(clazz)) {
                return Arrays.stream((Object[])o).iterator();
            }
            if (clazz.equals(int[].class)) {
                return IntStream.of((int[])o).iterator();
            }
            if (clazz.equals(long[].class)) {
                return LongStream.of((long[])o).iterator();
            }
            if (clazz.equals(float[].class)) {
                return IntStream.range(0, ((float[])o).length).mapToObj(i -> Float.valueOf(((float[])o)[i])).iterator();
            }
            if (clazz.equals(double[].class)) {
                return DoubleStream.of((double[])o).iterator();
            }
            if (clazz.equals(String[].class)) {
                return Arrays.stream((String[])o).iterator();
            }
            if (clazz.equals(boolean[].class)) {
                return IntStream.range(0, ((boolean[])o).length).mapToObj(i -> ((boolean[])o)[i]).iterator();
            }
            if (clazz.equals(Boolean[].class)) {
                return Arrays.stream((Boolean[])o).iterator();
            }
            throw new UnsupportedOperationException(String.format("Can not convert to iterator: %s", clazz.getName()));
        }
    };

    private CypherOrderability() {
        throw new UnsupportedOperationException();
    }

    public static int compare(Object lhs, Object rhs) {
        SuperType rightType;
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return 1;
        }
        if (rhs == null) {
            return -1;
        }
        SuperType leftType = SuperType.ofValue(lhs);
        int typeComparison = SuperType.TYPE_ID_COMPARATOR.compare(leftType, rightType = SuperType.ofValue(rhs));
        if (typeComparison != 0) {
            return typeComparison;
        }
        return leftType.comparator.compare(lhs, rhs);
    }

    static /* synthetic */ Comparator access$000() {
        return FALLBACK_COMPARATOR;
    }

    static /* synthetic */ Comparator access$100() {
        return NODE_COMPARATOR;
    }

    static /* synthetic */ Comparator access$200() {
        return RELATIONSHIP_COMPARATOR;
    }

    static /* synthetic */ Comparator access$300() {
        return LIST_COMPARATOR;
    }

    static /* synthetic */ Comparator access$400() {
        return PATH_COMPARATOR;
    }

    static /* synthetic */ Comparator access$500() {
        return STRING_COMPARATOR;
    }

    static /* synthetic */ Comparator access$600() {
        return BOOLEAN_COMPARATOR;
    }

    static /* synthetic */ Comparator access$700() {
        return NUMBER_COMPARATOR;
    }

    static /* synthetic */ Comparator access$800() {
        return VOID_COMPARATOR;
    }

    public static enum SuperType {
        MAP(0, CypherOrderability.access$000()),
        NODE(1, CypherOrderability.access$100()),
        RELATIONSHIP(2, CypherOrderability.access$200()),
        LIST(3, CypherOrderability.access$300()),
        PATH(4, CypherOrderability.access$400()),
        STRING(5, CypherOrderability.access$500()),
        BOOLEAN(6, CypherOrderability.access$600()),
        NUMBER(7, CypherOrderability.access$700()),
        VOID(8, CypherOrderability.access$800());

        public final int typeId;
        public final Comparator comparator;
        public static Comparator<SuperType> TYPE_ID_COMPARATOR;

        private SuperType(int typeId, Comparator comparator) {
            this.typeId = typeId;
            this.comparator = comparator;
        }

        public boolean isSuperTypeOf(Object value) {
            return this == SuperType.ofValue(value);
        }

        public static SuperType ofValue(Object value) {
            if (value instanceof String || value instanceof Character) {
                return STRING;
            }
            if (value instanceof Number) {
                return NUMBER;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Map) {
                return MAP;
            }
            if (value instanceof List || value.getClass().isArray()) {
                return LIST;
            }
            if (value instanceof NodeIdWrapper) {
                if (((NodeIdWrapper)value).id() == -1L) {
                    return VOID;
                }
                return NODE;
            }
            if (value instanceof RelationshipIdWrapper) {
                if (((RelationshipIdWrapper)value).id() == -1L) {
                    return VOID;
                }
                return RELATIONSHIP;
            }
            if (value instanceof Path) {
                return PATH;
            }
            throw new UnorderableValueException(value.getClass().getSimpleName());
        }

        static {
            TYPE_ID_COMPARATOR = new Comparator<SuperType>(){

                @Override
                public int compare(SuperType left, SuperType right) {
                    return left.typeId - right.typeId;
                }
            };
        }
    }
}

