/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.config;

import java.io.File;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.config.ConfigMemoryTrackingController;
import org.neo4j.cypher.internal.config.CypherConfiguration$;
import org.neo4j.cypher.internal.config.MemoryTrackingController;
import org.neo4j.cypher.internal.config.StatsDivergenceCalculatorConfig;
import org.neo4j.cypher.internal.options.CypherExpressionEngineOption;
import org.neo4j.cypher.internal.options.CypherExpressionEngineOption$;
import org.neo4j.cypher.internal.options.CypherInterpretedPipesFallbackOption;
import org.neo4j.cypher.internal.options.CypherInterpretedPipesFallbackOption$;
import org.neo4j.cypher.internal.options.CypherOperatorEngineOption;
import org.neo4j.cypher.internal.options.CypherOperatorEngineOption$;
import org.neo4j.cypher.internal.options.CypherPlannerOption;
import org.neo4j.cypher.internal.options.CypherPlannerOption$;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.options.CypherRuntimeOption$;
import org.neo4j.cypher.internal.options.CypherVersion;
import org.neo4j.cypher.internal.options.CypherVersion$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mw!B#G\u0011\u0003\tf!B*G\u0011\u0003!\u0006\"B.\u0002\t\u0003a\u0006\"B/\u0002\t\u0003q\u0006bBAg\u0003\u0011\u0005\u0011q\u001a\u0004\u0005'\u001a\u0003\u0001\r\u0003\u0005H\u000b\t\u0015\r\u0011\"\u0001b\u0011!AWA!A!\u0002\u0013\u0011\u0007\"B.\u0006\t\u0013I\u0007bB6\u0006\u0005\u0004%\t\u0001\u001c\u0005\u0007g\u0016\u0001\u000b\u0011B7\t\u000fQ,!\u0019!C\u0001k\"1\u00110\u0002Q\u0001\nYDqA_\u0003C\u0002\u0013\u00051\u0010\u0003\u0004\u0000\u000b\u0001\u0006I\u0001 \u0005\n\u0003\u0003)!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0003\u0006A\u0003%\u0011Q\u0001\u0005\n\u0003\u001b)!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0004\u0006A\u0003%\u0011Q\u0001\u0005\n\u0003#)!\u0019!C\u0001\u0003'A\u0001\"a\u0007\u0006A\u0003%\u0011Q\u0003\u0005\n\u0003;)!\u0019!C\u0001\u0003?A\u0001\"a\n\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003S)!\u0019!C\u0001\u0003\u0007A\u0001\"a\u000b\u0006A\u0003%\u0011Q\u0001\u0005\n\u0003[)!\u0019!C\u0001\u0003_A\u0001\"a\u000e\u0006A\u0003%\u0011\u0011\u0007\u0005\n\u0003s)!\u0019!C\u0001\u0003?A\u0001\"a\u000f\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003{)!\u0019!C\u0001\u0003?A\u0001\"a\u0010\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u0003*!\u0019!C\u0001\u0003?A\u0001\"a\u0011\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u000b*!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0012\u0006A\u0003%\u0011Q\u0001\u0005\n\u0003\u0013*!\u0019!C\u0001\u0003\u0017B\u0001\"a\u0015\u0006A\u0003%\u0011Q\n\u0005\n\u0003+*!\u0019!C\u0001\u0003?A\u0001\"a\u0016\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u00033*!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0017\u0006A\u0003%\u0011Q\u0001\u0005\n\u0003;*!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0018\u0006A\u0003%\u0011Q\u0001\u0005\n\u0003C*!\u0019!C\u0001\u0003?A\u0001\"a\u0019\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003K*!\u0019!C\u0001\u0003OB\u0001\"!\u001f\u0006A\u0003%\u0011\u0011\u000e\u0005\n\u0003w*!\u0019!C\u0001\u0003\u0007A\u0001\"! \u0006A\u0003%\u0011Q\u0001\u0005\n\u0003\u007f*!\u0019!C\u0001\u0003\u0003C\u0001\"!#\u0006A\u0003%\u00111\u0011\u0005\n\u0003\u0017+!\u0019!C\u0001\u0003\u001bC\u0001\"!&\u0006A\u0003%\u0011q\u0012\u0005\n\u0003/+!\u0019!C\u0001\u0003\u0007A\u0001\"!'\u0006A\u0003%\u0011Q\u0001\u0005\n\u00037+!\u0019!C\u0001\u0003;C\u0001\"!*\u0006A\u0003%\u0011q\u0014\u0005\n\u0003O+!\u0019!C\u0001\u0003?A\u0001\"!+\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003W+!\u0019!C\u0001\u0003?A\u0001\"!,\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003_+!\u0019!C\u0001\u0003?A\u0001\"!-\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003g+!\u0019!C\u0001\u0003?A\u0001\"!.\u0006A\u0003%\u0011\u0011\u0005\u0005\n\u0003o+\u0001\u0019!C\u0005\u0003?A\u0011\"!/\u0006\u0001\u0004%I!a/\t\u0011\u0005\u001dW\u0001)Q\u0005\u0003CAq!!3\u0006\t\u0003\ty\"A\nDsBDWM]\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002H\u0011\u000611m\u001c8gS\u001eT!!\u0013&\u0002\u0011%tG/\u001a:oC2T!a\u0013'\u0002\r\rL\b\u000f[3s\u0015\tie*A\u0003oK>$$NC\u0001P\u0003\ry'oZ\u0002\u0001!\t\u0011\u0016!D\u0001G\u0005M\u0019\u0015\u0010\u001d5fe\u000e{gNZ5hkJ\fG/[8o'\t\tQ\u000b\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u000b!B\u001a:p[\u000e{gNZ5h)\ry\u00161\u001a\t\u0003%\u0016\u0019\"!B+\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a'\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t9GM\u0001\u0004D_:4\u0017nZ\u0001\bG>tg-[4!)\ty&\u000eC\u0003H\u0011\u0001\u0007!-A\u0004wKJ\u001c\u0018n\u001c8\u0016\u00035\u0004\"A\\9\u000e\u0003=T!\u0001\u001d%\u0002\u000f=\u0004H/[8og&\u0011!o\u001c\u0002\u000e\u0007f\u0004\b.\u001a:WKJ\u001c\u0018n\u001c8\u0002\u0011Y,'o]5p]\u0002\nq\u0001\u001d7b]:,'/F\u0001w!\tqw/\u0003\u0002y_\n\u00192)\u001f9iKJ\u0004F.\u00198oKJ|\u0005\u000f^5p]\u0006A\u0001\u000f\\1o]\u0016\u0014\b%A\u0004sk:$\u0018.\\3\u0016\u0003q\u0004\"A\\?\n\u0005y|'aE\"za\",'OU;oi&lWm\u00149uS>t\u0017\u0001\u0003:v]RLW.\u001a\u0011\u0002\u001dE,XM]=DC\u000eDWmU5{KV\u0011\u0011Q\u0001\t\u0004-\u0006\u001d\u0011bAA\u0005/\n\u0019\u0011J\u001c;\u0002\u001fE,XM]=DC\u000eDWmU5{K\u0002\na#\u001a=fGV$\u0018n\u001c8QY\u0006t7)Y2iKNK'0Z\u0001\u0018Kb,7-\u001e;j_:\u0004F.\u00198DC\u000eDWmU5{K\u0002\n\u0011d\u001d;biN$\u0015N^3sO\u0016t7-Z\"bY\u000e,H.\u0019;peV\u0011\u0011Q\u0003\t\u0004%\u0006]\u0011bAA\r\r\ny2\u000b^1ug\u0012Kg/\u001a:hK:\u001cWmQ1mGVd\u0017\r^8s\u0007>tg-[4\u00025M$\u0018\r^:ESZ,'oZ3oG\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0011\u0002+U\u001cX-\u0012:s_J\u001cxJ^3s/\u0006\u0014h.\u001b8hgV\u0011\u0011\u0011\u0005\t\u0004-\u0006\r\u0012bAA\u0013/\n9!i\\8mK\u0006t\u0017AF;tK\u0016\u0013(o\u001c:t\u001fZ,'oV1s]&twm\u001d\u0011\u0002\u001f%$\u0007/T1y)\u0006\u0014G.Z*ju\u0016\f\u0001#\u001b3q\u001b\u0006DH+\u00192mKNK'0\u001a\u0011\u0002)%$\u0007/\u0013;fe\u0006$\u0018n\u001c8EkJ\fG/[8o+\t\t\t\u0004E\u0002W\u0003gI1!!\u000eX\u0005\u0011auN\\4\u0002+%$\u0007/\u0013;fe\u0006$\u0018n\u001c8EkJ\fG/[8oA\u0005ASM\u001d:pe&37\u000b[8si\u0016\u001cH\u000fU1uQ\u001a\u000bG\u000e\u001c2bG.,6/\u001a3BiJ+h\u000e^5nK\u0006ISM\u001d:pe&37\u000b[8si\u0016\u001cH\u000fU1uQ\u001a\u000bG\u000e\u001c2bG.,6/\u001a3BiJ+h\u000e^5nK\u0002\n!&\u001a:s_JLem\u00155peR,7\u000f\u001e)bi\"D\u0015m]\"p[6|gNT8eKN\fEOU;oi&lW-A\u0016feJ|'/\u00134TQ>\u0014H/Z:u!\u0006$\b\u000eS1t\u0007>lWn\u001c8O_\u0012,7/\u0011;Sk:$\u0018.\\3!\u0003YaWmZ1ds\u000e\u001bh/U;pi\u0016,5oY1qS:<\u0017a\u00067fO\u0006\u001c\u0017pQ:w#V|G/Z#tG\u0006\u0004\u0018N\\4!\u00035\u00197O\u001e\"vM\u001a,'oU5{K\u0006q1m\u001d<Ck\u001a4WM]*ju\u0016\u0004\u0013AF3yaJ,7o]5p]\u0016sw-\u001b8f\u001fB$\u0018n\u001c8\u0016\u0005\u00055\u0003c\u00018\u0002P%\u0019\u0011\u0011K8\u00039\rK\b\u000f[3s\u000bb\u0004(/Z:tS>tWI\\4j]\u0016|\u0005\u000f^5p]\u00069R\r\u001f9sKN\u001c\u0018n\u001c8F]\u001eLg.Z(qi&|g\u000eI\u0001\u001aY\u0016t\u0017.\u001a8u\u0007J,\u0017\r^3SK2\fG/[8og\"L\u0007/\u0001\u000emK:LWM\u001c;De\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004\b%A\fqSB,G.\u001b8fI\n\u000bGo\u00195TSj,7+\\1mY\u0006A\u0002/\u001b9fY&tW\r\u001a\"bi\u000eD7+\u001b>f'6\fG\u000e\u001c\u0011\u0002+AL\u0007/\u001a7j]\u0016$')\u0019;dQNK'0\u001a\"jO\u00061\u0002/\u001b9fY&tW\r\u001a\"bi\u000eD7+\u001b>f\u0005&<\u0007%\u0001\ne_N\u001b\u0007.\u001a3vY\u0016\u0014HK]1dS:<\u0017a\u00053p'\u000eDW\rZ;mKJ$&/Y2j]\u001e\u0004\u0013\u0001F:dQ\u0016$W\u000f\\3s)J\f7-\u001b8h\r&dW-\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014AA5p\u0015\t\t\u0019(\u0001\u0003kCZ\f\u0017\u0002BA<\u0003[\u0012AAR5mK\u0006)2o\u00195fIVdWM\u001d+sC\u000eLgn\u001a$jY\u0016\u0004\u0013A\u0005:fG>l\u0007/\u001b7bi&|g\u000eT5nSR\f1C]3d_6\u0004\u0018\u000e\\1uS>tG*[7ji\u0002\nab\u001c9fe\u0006$xN]#oO&tW-\u0006\u0002\u0002\u0004B\u0019a.!\"\n\u0007\u0005\u001duN\u0001\u000eDsBDWM](qKJ\fGo\u001c:F]\u001eLg.Z(qi&|g.A\bpa\u0016\u0014\u0018\r^8s\u000b:<\u0017N\\3!\u0003aIg\u000e^3saJ,G/\u001a3QSB,7OR1mY\n\f7m[\u000b\u0003\u0003\u001f\u00032A\\AI\u0013\r\t\u0019j\u001c\u0002%\u0007f\u0004\b.\u001a:J]R,'\u000f\u001d:fi\u0016$\u0007+\u001b9fg\u001a\u000bG\u000e\u001c2bG.|\u0005\u000f^5p]\u0006I\u0012N\u001c;feB\u0014X\r^3e!&\u0004Xm\u001d$bY2\u0014\u0017mY6!\u0003}y\u0007/\u001a:bi>\u0014h)^:j_:|e/\u001a:QSB,G.\u001b8f\u0019&l\u0017\u000e^\u0001!_B,'/\u0019;pe\u001a+8/[8o\u001fZ,'\u000fU5qK2Lg.\u001a'j[&$\b%\u0001\rnK6|'/\u001f+sC\u000e\\\u0017N\\4D_:$(o\u001c7mKJ,\"!a(\u0011\u0007I\u000b\t+C\u0002\u0002$\u001a\u0013\u0001$T3n_JLHK]1dW&twmQ8oiJ|G\u000e\\3s\u0003eiW-\\8ssR\u0013\u0018mY6j]\u001e\u001cuN\u001c;s_2dWM\u001d\u0011\u0002\u001d\u0015t\u0017M\u00197f\u001b>t\u0017\u000e^8sg\u0006yQM\\1cY\u0016luN\\5u_J\u001c\b%A\bvg\u0016T\u0015M^1D\u0007B\u000b'o]3s\u0003A)8/\u001a&bm\u0006\u001c5\tU1sg\u0016\u0014\b%\u0001\u000beSN\fG\u000e\\8x'Bd\u0017\u000e\u001e;j]\u001e$v\u000e]\u0001\u0016I&\u001c\u0018\r\u001c7poN\u0003H.\u001b;uS:<Gk\u001c9!\u0003\u0005*g.\u00192mKBc\u0017M\u001c8j]\u001e\u0014V\r\\1uS>t7\u000f[5q\u0013:$W\r_3t\u0003\t*g.\u00192mKBc\u0017M\u001c8j]\u001e\u0014V\r\\1uS>t7\u000f[5q\u0013:$W\r_3tA\u0005\u0011rl\u001c2gkN\u001c\u0017\r^3MSR,'/\u00197t\u0003YyvN\u00194vg\u000e\fG/\u001a'ji\u0016\u0014\u0018\r\\:`I\u0015\fH\u0003BA_\u0003\u0007\u00042AVA`\u0013\r\t\tm\u0016\u0002\u0005+:LG\u000fC\u0005\u0002F\n\u000b\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010J\u0019\u0002'}{'MZ;tG\u0006$X\rT5uKJ\fGn\u001d\u0011\u0002#=\u0014g-^:dCR,G*\u001b;fe\u0006d7\u000fC\u0003H\u0007\u0001\u0007!-A\rti\u0006$8\u000fR5wKJ<WM\\2f\rJ|WnQ8oM&<G\u0003BA\u000b\u0003#DQa\u0012\u0003A\u0002\t\u0004")
public class CypherConfiguration {
    private final Config config;
    private final CypherVersion version;
    private final CypherPlannerOption planner;
    private final CypherRuntimeOption runtime;
    private final int queryCacheSize;
    private final int executionPlanCacheSize;
    private final StatsDivergenceCalculatorConfig statsDivergenceCalculator;
    private final boolean useErrorsOverWarnings;
    private final int idpMaxTableSize;
    private final long idpIterationDuration;
    private final boolean errorIfShortestPathFallbackUsedAtRuntime;
    private final boolean errorIfShortestPathHasCommonNodesAtRuntime;
    private final boolean legacyCsvQuoteEscaping;
    private final int csvBufferSize;
    private final CypherExpressionEngineOption expressionEngineOption;
    private final boolean lenientCreateRelationship;
    private final int pipelinedBatchSizeSmall;
    private final int pipelinedBatchSizeBig;
    private final boolean doSchedulerTracing;
    private final File schedulerTracingFile;
    private final int recompilationLimit;
    private final CypherOperatorEngineOption operatorEngine;
    private final CypherInterpretedPipesFallbackOption interpretedPipesFallback;
    private final int operatorFusionOverPipelineLimit;
    private final MemoryTrackingController memoryTrackingController;
    private final boolean enableMonitors;
    private final boolean useJavaCCParser;
    private final boolean disallowSplittingTop;
    private final boolean enablePlanningRelationshipIndexes;
    private boolean _obfuscateLiterals;

    public static StatsDivergenceCalculatorConfig statsDivergenceFromConfig(Config config) {
        return CypherConfiguration$.MODULE$.statsDivergenceFromConfig(config);
    }

    public static CypherConfiguration fromConfig(Config config) {
        return CypherConfiguration$.MODULE$.fromConfig(config);
    }

    public Config config() {
        return this.config;
    }

    public CypherVersion version() {
        return this.version;
    }

    public CypherPlannerOption planner() {
        return this.planner;
    }

    public CypherRuntimeOption runtime() {
        return this.runtime;
    }

    public int queryCacheSize() {
        return this.queryCacheSize;
    }

    public int executionPlanCacheSize() {
        return this.executionPlanCacheSize;
    }

    public StatsDivergenceCalculatorConfig statsDivergenceCalculator() {
        return this.statsDivergenceCalculator;
    }

    public boolean useErrorsOverWarnings() {
        return this.useErrorsOverWarnings;
    }

    public int idpMaxTableSize() {
        return this.idpMaxTableSize;
    }

    public long idpIterationDuration() {
        return this.idpIterationDuration;
    }

    public boolean errorIfShortestPathFallbackUsedAtRuntime() {
        return this.errorIfShortestPathFallbackUsedAtRuntime;
    }

    public boolean errorIfShortestPathHasCommonNodesAtRuntime() {
        return this.errorIfShortestPathHasCommonNodesAtRuntime;
    }

    public boolean legacyCsvQuoteEscaping() {
        return this.legacyCsvQuoteEscaping;
    }

    public int csvBufferSize() {
        return this.csvBufferSize;
    }

    public CypherExpressionEngineOption expressionEngineOption() {
        return this.expressionEngineOption;
    }

    public boolean lenientCreateRelationship() {
        return this.lenientCreateRelationship;
    }

    public int pipelinedBatchSizeSmall() {
        return this.pipelinedBatchSizeSmall;
    }

    public int pipelinedBatchSizeBig() {
        return this.pipelinedBatchSizeBig;
    }

    public boolean doSchedulerTracing() {
        return this.doSchedulerTracing;
    }

    public File schedulerTracingFile() {
        return this.schedulerTracingFile;
    }

    public int recompilationLimit() {
        return this.recompilationLimit;
    }

    public CypherOperatorEngineOption operatorEngine() {
        return this.operatorEngine;
    }

    public CypherInterpretedPipesFallbackOption interpretedPipesFallback() {
        return this.interpretedPipesFallback;
    }

    public int operatorFusionOverPipelineLimit() {
        return this.operatorFusionOverPipelineLimit;
    }

    public MemoryTrackingController memoryTrackingController() {
        return this.memoryTrackingController;
    }

    public boolean enableMonitors() {
        return this.enableMonitors;
    }

    public boolean useJavaCCParser() {
        return this.useJavaCCParser;
    }

    public boolean disallowSplittingTop() {
        return this.disallowSplittingTop;
    }

    public boolean enablePlanningRelationshipIndexes() {
        return this.enablePlanningRelationshipIndexes;
    }

    private boolean _obfuscateLiterals() {
        return this._obfuscateLiterals;
    }

    private void _obfuscateLiterals_$eq(boolean x$1) {
        this._obfuscateLiterals = x$1;
    }

    public boolean obfuscateLiterals() {
        return this._obfuscateLiterals();
    }

    public CypherConfiguration(Config config) {
        this.config = config;
        this.version = (CypherVersion)CypherVersion$.MODULE$.fromConfig(config);
        this.planner = (CypherPlannerOption)CypherPlannerOption$.MODULE$.fromConfig(config);
        this.runtime = (CypherRuntimeOption)CypherRuntimeOption$.MODULE$.fromConfig(config);
        this.queryCacheSize = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseSettings.query_cache_size));
        this.executionPlanCacheSize = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.query_execution_plan_cache_size));
        this.statsDivergenceCalculator = CypherConfiguration$.MODULE$.statsDivergenceFromConfig(config);
        this.useErrorsOverWarnings = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_hints_error));
        this.idpMaxTableSize = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_idp_solver_table_threshold));
        this.idpIterationDuration = Predef$.MODULE$.Long2long((Long)config.get(GraphDatabaseInternalSettings.cypher_idp_solver_duration_threshold));
        this.errorIfShortestPathFallbackUsedAtRuntime = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_exhaustive_shortestpath));
        this.errorIfShortestPathHasCommonNodesAtRuntime = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_shortestpath_common_nodes));
        this.legacyCsvQuoteEscaping = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.csv_legacy_quote_escaping));
        this.csvBufferSize = ((Long)config.get(GraphDatabaseSettings.csv_buffer_size)).intValue();
        this.expressionEngineOption = (CypherExpressionEngineOption)CypherExpressionEngineOption$.MODULE$.fromConfig(config);
        this.lenientCreateRelationship = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_lenient_create_relationship));
        this.pipelinedBatchSizeSmall = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_batch_size_small));
        this.pipelinedBatchSizeBig = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_batch_size_big));
        this.doSchedulerTracing = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.enable_pipelined_runtime_trace));
        this.schedulerTracingFile = ((Path)config.get(GraphDatabaseInternalSettings.pipelined_scheduler_trace_filename)).toFile();
        this.recompilationLimit = Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseInternalSettings.cypher_expression_recompilation_limit));
        this.operatorEngine = (CypherOperatorEngineOption)CypherOperatorEngineOption$.MODULE$.fromConfig(config);
        this.interpretedPipesFallback = (CypherInterpretedPipesFallbackOption)CypherInterpretedPipesFallbackOption$.MODULE$.fromConfig(config);
        this.operatorFusionOverPipelineLimit = (Integer)config.get(GraphDatabaseInternalSettings.cypher_pipelined_operator_fusion_over_pipeline_limit);
        this.memoryTrackingController = new ConfigMemoryTrackingController(config);
        this.enableMonitors = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.cypher_enable_runtime_monitors));
        Object object = config.get(GraphDatabaseInternalSettings.cypher_parser);
        GraphDatabaseInternalSettings.CypherParser cypherParser = GraphDatabaseInternalSettings.CypherParser.PARBOILED;
        this.useJavaCCParser = object == null ? cypherParser != null : !object.equals(cypherParser);
        Object object2 = config.get(GraphDatabaseInternalSettings.cypher_splitting_top_behavior);
        GraphDatabaseInternalSettings.SplittingTopBehavior splittingTopBehavior = GraphDatabaseInternalSettings.SplittingTopBehavior.DISALLOW;
        this.disallowSplittingTop = !(object2 != null ? !object2.equals(splittingTopBehavior) : splittingTopBehavior != null);
        this.enablePlanningRelationshipIndexes = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseInternalSettings.cypher_enable_planning_relationship_indexes));
        this._obfuscateLiterals = Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.log_queries_obfuscate_literals));
        config.addListener(GraphDatabaseSettings.log_queries_obfuscate_literals, (x$1, newValue) -> this._obfuscateLiterals_$eq(Predef$.MODULE$.Boolean2boolean(newValue)));
    }
}

