/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory.neo4j;

import java.io.IOException;
import java.nio.CharBuffer;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.neo4j.cypher.internal.ast.factory.neo4j.UnicodeEscapeReader;
import org.neo4j.cypher.internal.cst.factory.neo4j.CypherToken;
import org.neo4j.cypher.internal.cst.factory.neo4j.OffsetTable;
import org.neo4j.cypher.internal.parser.CypherLexer;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.util.VisibleForTesting;

public final class CypherAstLexer
extends CypherLexer {
    private final String inputQuery;
    private final OffsetTable offsetTable;

    private CypherAstLexer(CharStream input, String inputQuery, OffsetTable offsetTable) {
        super(input);
        this.inputQuery = inputQuery;
        this.offsetTable = offsetTable;
    }

    public String inputText(Token start, Token stop) {
        return this.inputQuery.substring(((CypherToken)start).inputOffset(start.getStartIndex()), ((CypherToken)stop).inputOffset(stop.getStopIndex()) + 1);
    }

    public int inputOffset(int parserOffset) {
        if (this.offsetTable == null || parserOffset < this.offsetTable.start()) {
            return parserOffset;
        }
        return this.offsetTable.offsets()[(parserOffset - this.offsetTable.start()) * 3];
    }

    public InputPosition inputPosition(int parserIndex, int parserLine, int parserColumn) {
        if (this.offsetTable == null || parserIndex < this.offsetTable.start()) {
            return InputPosition.apply((int)parserIndex, (int)parserLine, (int)(parserColumn + 1));
        }
        int i = (parserIndex - this.offsetTable.start()) * 3;
        int[] o = this.offsetTable.offsets();
        return InputPosition.apply((int)o[i], (int)o[i + 1], (int)o[i + 2]);
    }

    public void notifyListeners(LexerNoViableAltException e) {
        String text = this._input.getText(Interval.of((int)this._tokenStartCharIndex, (int)this._input.index()));
        String msg = "Unexpected query part: '" + this.getErrorDisplay(text) + "'";
        ANTLRErrorListener listener = this.getErrorListenerDispatch();
        Token dummyToken = this.getTokenFactory().create(this._tokenFactorySourcePair, -1, text, this._channel, this._tokenStartCharIndex, this._input.index(), this._tokenStartLine, this._tokenStartCharPositionInLine);
        listener.syntaxError((Recognizer)this, (Object)dummyToken, this._tokenStartLine, this._tokenStartCharPositionInLine, msg, (RecognitionException)e);
    }

    public static CypherAstLexer fromString(String cypher, boolean fullTokens) throws IOException {
        return CypherAstLexer.fromString(cypher, 4096, fullTokens);
    }

    @VisibleForTesting
    static CypherAstLexer fromString(String cypher, int maxBuffer, boolean fullTokens) throws IOException {
        CodePointBuffer.Builder antlrBuffer = CodePointBuffer.builder((int)cypher.length());
        CharBuffer cb = CharBuffer.allocate(Math.min(maxBuffer, cypher.length()));
        try (UnicodeEscapeReader reader = new UnicodeEscapeReader(cypher);){
            while (reader.read(cb.clear()) != -1) {
                antlrBuffer.append(cb.flip());
            }
            CodePointCharStream charStream = CodePointCharStream.fromBuffer((CodePointBuffer)antlrBuffer.build(), (String)"<unknown>");
            CypherAstLexer lexer = new CypherAstLexer((CharStream)charStream, cypher, reader.offsetTable());
            lexer.setTokenFactory(CypherToken.factory(fullTokens));
            CypherAstLexer cypherAstLexer = lexer;
            return cypherAstLexer;
        }
    }
}

