/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory.neo4j;

import java.io.Reader;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.neo4j.cypher.internal.cst.factory.neo4j.OffsetTable;
import org.neo4j.cypher.internal.parser.javacc.InvalidUnicodeLiteral;
import org.neo4j.cypher.internal.util.InputPosition;

class UnicodeEscapeReader
extends Reader {
    private final String cypher;
    private int srcPos;
    private OffsetTableBuilder offsetTable = null;
    boolean escaped = false;

    UnicodeEscapeReader(String cypher) {
        this.cypher = cypher;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.srcPos >= this.cypher.length()) {
            return -1;
        }
        return this.doRead(cbuf, off, len);
    }

    private int doRead(char[] cbuf, int off, int len) {
        int srcPos;
        boolean isReplacement;
        String src = this.cypher;
        int srcEnd = src.length();
        int destPos = off;
        int destEnd = off + len;
        boolean escaped = this.escaped;
        OffsetTableBuilder offsetTable = this.offsetTable;
        for (srcPos = this.srcPos; srcPos < srcEnd && destPos < destEnd; srcPos += isReplacement ? 6 : 1) {
            boolean isHighSurrogate;
            char c = src.charAt(srcPos);
            boolean bl = isReplacement = !escaped && c == '\\' && this.peek(srcPos + 1) == 'u';
            if (isReplacement) {
                c = this.parseUnicodeReplacement(srcPos);
            }
            if ((isHighSurrogate = Character.isHighSurrogate(c)) && destPos + 1 == destEnd && srcPos + 1 < srcEnd && len > 1) break;
            if (offsetTable != null || isReplacement || isHighSurrogate) {
                offsetTable = this.updateOffsetTable(srcPos, c);
            }
            escaped = !escaped && !isReplacement && c == '\\';
            cbuf[destPos++] = c;
        }
        this.srcPos = srcPos;
        this.escaped = escaped;
        return destPos - off;
    }

    private char peek(int pos) {
        return pos < this.cypher.length() ? this.cypher.charAt(pos) : (char)'\u0000';
    }

    private OffsetTableBuilder updateOffsetTable(int charPos, char destChar) {
        if (this.offsetTable == null) {
            this.offsetTable = new OffsetTableBuilder(this.inputPositionAt(charPos), this.cypher.charAt(charPos), destChar);
        } else {
            this.offsetTable.updateOffsets(charPos, this.cypher.charAt(charPos), destChar);
        }
        return this.offsetTable;
    }

    private InputPosition inputPositionAt(int pos) {
        int line = 1;
        int col = 1;
        for (int i = 0; i < pos && i < this.cypher.length(); ++i) {
            char c = this.cypher.charAt(i);
            if (c == '\n' || c == '\r' && this.peek(i + 1) != '\n') {
                ++line;
                col = 0;
            }
            ++col;
        }
        return InputPosition.apply((int)pos, (int)line, (int)col);
    }

    private char parseUnicodeReplacement(int charPos) {
        String hexString = this.cypher.substring(Math.min(charPos + 2, this.cypher.length()), Math.min(charPos + 6, this.cypher.length()));
        try {
            return (char)Integer.parseInt(hexString, 16);
        }
        catch (Exception e) {
            InputPosition pos = this.inputPositionAt(charPos + 2);
            String m = "Invalid input '%s': expected four hexadecimal digits specifying a unicode character";
            throw new InvalidUnicodeLiteral(m.formatted(hexString), charPos, pos.line(), pos.column());
        }
    }

    public OffsetTable offsetTable() {
        return this.offsetTable != null ? new OffsetTable(this.offsetTable.offsets.toArray(), this.offsetTable.start) : null;
    }

    @Override
    public void close() {
    }

    private static class OffsetTableBuilder {
        IntArrayList offsets = new IntArrayList();
        final int start;
        char lastSrcChar;
        char lastDestChar;

        OffsetTableBuilder(InputPosition start, char srcChar, char destChar) {
            this.offsets.addAll(new int[]{start.offset(), start.line(), start.column()});
            this.start = start.offset();
            this.lastSrcChar = srcChar;
            this.lastDestChar = destChar;
        }

        void updateOffsets(int charPos, char srcChar, char destChar) {
            int line = this.offsets.get(this.offsets.size() - 2);
            int col = this.offsets.getLast() + charPos - this.offsets.get(this.offsets.size() - 3);
            if (this.lastSrcChar == '\n' || this.lastSrcChar == '\r' && srcChar != '\n') {
                ++line;
                col = 1;
            }
            if (!Character.isHighSurrogate(this.lastDestChar) || !Character.isLowSurrogate(destChar)) {
                this.offsets.addAll(new int[]{charPos, line, col});
            }
            this.lastSrcChar = srcChar;
            this.lastDestChar = destChar;
        }
    }
}

