/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cst.factory.neo4j.ast;

import java.io.Serializable;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.Statements;
import org.neo4j.cypher.internal.ast.factory.neo4j.CypherAstLexer;
import org.neo4j.cypher.internal.cst.factory.neo4j.SyntaxErrorListener;
import org.neo4j.cypher.internal.cst.factory.neo4j.ast.CypherAstParser;
import org.neo4j.cypher.internal.cst.factory.neo4j.ast.CypherErrorStrategy;
import org.neo4j.cypher.internal.parser.AstRuleCtx;
import org.neo4j.cypher.internal.parser.javacc.InvalidUnicodeLiteral;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.Status;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.util.control.NonFatal$;

public final class CypherAstParser$ {
    public static final CypherAstParser$ MODULE$ = new CypherAstParser$();

    public final boolean DEBUG() {
        return false;
    }

    public Statement parseStatements(String query, CypherExceptionFactory exceptionFactory, Option<InternalNotificationLogger> notificationLogger) {
        Statements statements;
        try {
            statements = (Statements)this.parse(query, exceptionFactory, notificationLogger, (Function1 & Serializable)x$3 -> x$3.statements()).ast();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Status.HasStatus) {
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw new CypherExecutionException("Failed to parse query `" + query + "`.", (Throwable)exception);
            }
            throw throwable;
        }
        Statements statements2 = statements;
        if (statements2.size() == 1) {
            return (Statement)statements2.statements().head();
        }
        throw exceptionFactory.syntaxException("Expected exactly one statement per query but got: " + statements2.size(), InputPosition$.MODULE$.NONE());
    }

    public <T extends AstRuleCtx> T parse(String query, CypherExceptionFactory exceptionFactory, Option<InternalNotificationLogger> notificationLogger, Function1<CypherAstParser, T> f) {
        T t;
        SyntaxErrorListener listener = new SyntaxErrorListener(exceptionFactory);
        CommonTokenStream tokens = this.preparsedTokens(query, listener, exceptionFactory, false);
        CypherAstParser parser = new CypherAstParser((TokenStream)tokens, true, exceptionFactory, notificationLogger);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            t = this.doParse(parser, listener, f);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                parser.setInputStream((IntStream)this.preparsedTokens(query, listener, exceptionFactory, true));
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                parser.setErrorHandler((ANTLRErrorStrategy)new CypherErrorStrategy());
                parser.addErrorListener((ANTLRErrorListener)listener);
                t = this.doParse(parser, listener, f);
            }
            throw throwable;
        }
        return t;
    }

    private <T extends AstRuleCtx> T doParse(CypherAstParser parser, SyntaxErrorListener listener, Function1<CypherAstParser, T> f) {
        AstRuleCtx result = (AstRuleCtx)f.apply((Object)parser);
        if (parser.syntaxChecker().hasErrors()) {
            throw (Throwable)parser.syntaxChecker().getErrors().reduce((Function2 & Serializable)(x$1, x$2) -> Exceptions.chain((Throwable)x$1, (Throwable)x$2));
        }
        if (listener.syntaxErrors().nonEmpty()) {
            throw (Throwable)listener.syntaxErrors().reduce((Function2 & Serializable)(x$1, x$2) -> Exceptions.chain((Throwable)x$1, (Throwable)x$2));
        }
        return (T)result;
    }

    private CommonTokenStream preparsedTokens(String cypher, SyntaxErrorListener listener, CypherExceptionFactory exceptionFactory, boolean fullTokens) {
        CommonTokenStream commonTokenStream;
        try {
            CypherAstLexer lexer = CypherAstLexer.fromString(cypher, fullTokens);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)listener);
            commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        }
        catch (InvalidUnicodeLiteral e) {
            throw exceptionFactory.syntaxException(e.getMessage(), InputPosition$.MODULE$.apply(e.offset, e.line, e.column));
        }
        return commonTokenStream;
    }

    private CypherAstParser$() {
    }
}

