/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.Clauses;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.CountExpression;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesPatternLengthAccessors;
import org.neo4j.cypherdsl.core.ExposesProperties;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.LabelExpression;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Predicates;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.parser.DatabaseName;
import org.neo4j.cypherdsl.parser.EntityType;
import org.neo4j.cypherdsl.parser.ExpressionAsPatternElementWrapper;
import org.neo4j.cypherdsl.parser.ExpressionCreatedEventType;
import org.neo4j.cypherdsl.parser.InfinityLiteral;
import org.neo4j.cypherdsl.parser.InputPosition;
import org.neo4j.cypherdsl.parser.LabelParsedEventType;
import org.neo4j.cypherdsl.parser.MatchDefinition;
import org.neo4j.cypherdsl.parser.NaNLiteral;
import org.neo4j.cypherdsl.parser.NodeAtom;
import org.neo4j.cypherdsl.parser.Options;
import org.neo4j.cypherdsl.parser.PathAtom;
import org.neo4j.cypherdsl.parser.PathLength;
import org.neo4j.cypherdsl.parser.PatternAtom;
import org.neo4j.cypherdsl.parser.PatternElementAsExpressionWrapper;
import org.neo4j.cypherdsl.parser.PatternElementCreatedEventType;
import org.neo4j.cypherdsl.parser.PatternElementFunctions;
import org.neo4j.cypherdsl.parser.ReturnDefinition;
import org.neo4j.cypherdsl.parser.TypeParsedEventType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ASTFactory;
import org.neo4j.cypherdsl.parser.internal.ast.factory.AccessType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ActionType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.CallInTxsOnErrorBehaviourType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ConstraintType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ConstraintVersion;
import org.neo4j.cypherdsl.parser.internal.ast.factory.CreateIndexTypes;
import org.neo4j.cypherdsl.parser.internal.ast.factory.HintIndexType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ParameterType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ParserCypherTypeName;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ScopeType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ShowCommandFilterTypes;
import org.neo4j.cypherdsl.parser.internal.ast.factory.SimpleEither;

@API(status=API.Status.INTERNAL, since="2021.3.0")
final class CypherDslASTFactory
implements ASTFactory<Statement, Statement, Clause, Return, Expression, List<Expression>, SortItem, PatternElement, NodeAtom, PathAtom, PathLength, Clause, Expression, Expression, Expression, Hint, Expression, LabelExpression, Parameter<?>, Expression, Property, Expression, Clause, Statement, Statement, Statement, Clause, Where, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, InputPosition, EntityType, ASTFactory.NULL, PatternAtom, DatabaseName, ASTFactory.NULL, ASTFactory.NULL> {
    private static CypherDslASTFactory instanceFromDefaultOptions;
    private final Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CypherDslASTFactory getInstance(Options options) {
        if (options != null && !options.areDefault()) {
            return new CypherDslASTFactory(options);
        }
        CypherDslASTFactory instance = instanceFromDefaultOptions;
        if (instance != null) return instance;
        Class<CypherDslASTFactory> clazz = CypherDslASTFactory.class;
        synchronized (CypherDslASTFactory.class) {
            instance = instanceFromDefaultOptions;
            if (instance != null) return instance;
            instanceFromDefaultOptions = new CypherDslASTFactory(Optional.ofNullable(options).orElseGet(Options::defaultOptions));
            return instanceFromDefaultOptions;
        }
    }

    private CypherDslASTFactory(Options options) {
        this.options = options;
    }

    private String[] computeFinalLabelList(LabelParsedEventType event, List<ASTFactory.StringPos<InputPosition>> inputLabels) {
        return inputLabels == null ? new String[]{} : this.options.getLabelFilter().apply(event, inputLabels.stream().map(v -> v.string).toList()).toArray(new String[0]);
    }

    private Optional<String[]> computeFinalLabelList(LabelParsedEventType event, LabelExpression inputLabels) {
        if (inputLabels == null) {
            return Optional.of(new String[0]);
        }
        if (inputLabels.type() == LabelExpression.Type.COLON_CONJUNCTION || inputLabels.type() == LabelExpression.Type.LEAF && inputLabels.value() != null) {
            return Optional.of(this.options.getLabelFilter().apply(event, inputLabels.value()).toArray(new String[0]));
        }
        return Optional.empty();
    }

    private String[] computeFinalTypeList(TypeParsedEventType event, LabelExpression inputTypes) {
        if (inputTypes == null) {
            return new String[0];
        }
        if (inputTypes.negated() || inputTypes.type() == LabelExpression.Type.CONJUNCTION) {
            throw new UnsupportedOperationException("Expressions for relationship types are not supported in Cypher-DSL");
        }
        ArrayList<String> types = new ArrayList<String>();
        this.traverseTypeExpression(types, inputTypes);
        return this.options.getTypeFilter().apply(event, types).toArray(new String[0]);
    }

    void traverseTypeExpression(List<String> types, LabelExpression expression) {
        if (expression.type() == LabelExpression.Type.LEAF || expression.type() == LabelExpression.Type.COLON_DISJUNCTION) {
            types.addAll(expression.value());
        } else {
            this.traverseTypeExpression(types, expression.lhs());
            this.traverseTypeExpression(types, expression.rhs());
        }
    }

    static void isInstanceOf(Class<?> type, Object obj, String message) {
        if (type == null) {
            throw new IllegalArgumentException("Type to check against must not be null");
        }
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private <T extends Expression> T applyCallbackFor(ExpressionCreatedEventType type, T newExpression) {
        return this.applyCallbackFor(type, List.of(newExpression)).get(0);
    }

    private <T extends Expression> List<T> applyCallbackFor(ExpressionCreatedEventType type, List<T> expressions) {
        List callbacks = this.options.getOnNewExpressionCallbacks().getOrDefault((Object)type, List.of());
        if (callbacks.isEmpty()) {
            return expressions;
        }
        Function chainedCallbacks = callbacks.stream().reduce(Function.identity(), Function::andThen);
        return expressions.stream().map(e -> (Expression)chainedCallbacks.apply(e)).toList();
    }

    private static SymbolicName assertSymbolicName(@Nullable Expression v) {
        if (v == null) {
            return null;
        }
        CypherDslASTFactory.isInstanceOf(SymbolicName.class, v, "An invalid type has been generated where a SymbolicName was required. Generated type was " + v.getClass().getName());
        return (SymbolicName)v;
    }

    @Override
    public Statement newSingleQuery(InputPosition p, List<Clause> clauses) {
        return this.newSingleQuery(clauses);
    }

    @Override
    public Statement newSingleQuery(List<Clause> clauses) {
        return Statement.of(clauses);
    }

    @Override
    public Statement newUnion(InputPosition p, Statement lhs, Statement rhs, boolean all) {
        if (all) {
            return Cypher.unionAll((Statement[])new Statement[]{lhs, rhs});
        }
        return Cypher.union((Statement[])new Statement[]{lhs, rhs});
    }

    @Override
    public Clause useClause(InputPosition p, Expression e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Expression> newReturnItems(InputPosition p, boolean returnAll, List<Expression> returnItems) {
        List<Expression> finalReturnItems = returnItems;
        if (returnAll) {
            finalReturnItems = Stream.concat(Stream.of(Cypher.asterisk()), finalReturnItems.stream()).toList();
        }
        if (finalReturnItems.isEmpty()) {
            if (!returnAll) {
                throw new IllegalArgumentException("Cannot return nothing.");
            }
            finalReturnItems = Collections.singletonList(Cypher.asterisk());
        }
        return finalReturnItems;
    }

    @Override
    public Return newReturnClause(InputPosition p, boolean distinct, List<Expression> returnItems, List<SortItem> sortItems, InputPosition orderPos, Expression skip, InputPosition skipPosition, Expression limit, InputPosition limitPosition) {
        return this.options.getReturnClauseFactory().apply(new ReturnDefinition(distinct, returnItems, sortItems, skip, limit));
    }

    @Override
    public Expression newReturnItem(InputPosition p, Expression e, Expression v) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_RETURN_ITEM, e.as(s));
    }

    @Override
    public Expression newReturnItem(InputPosition p, Expression e, int eStartOffset, int eEndOffset) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_RETURN_ITEM, e);
    }

    @Override
    public SortItem orderDesc(InputPosition p, Expression e) {
        return e.descending();
    }

    @Override
    public SortItem orderAsc(InputPosition p, Expression e) {
        return e.ascending();
    }

    @Override
    public Clause withClause(InputPosition p, Return returnClause, Where where) {
        return Clauses.with((Return)returnClause, (Where)where);
    }

    @Override
    public Clause matchClause(InputPosition p, boolean optional, ASTFactory.NULL matchMode, List<PatternElement> patternElements, InputPosition patternPos, List<Hint> hints, Where whereIn) {
        List<UnaryOperator<PatternElement>> patternElementCallbacks = this.options.getOnNewPatternElementCallbacks().getOrDefault((Object)PatternElementCreatedEventType.ON_MATCH, List.of());
        Condition condition = Conditions.noCondition();
        ArrayList<PatternElement> openForTransformation = new ArrayList<PatternElement>();
        for (PatternElement patternElement : patternElements) {
            if (patternElement instanceof NodeAtom) {
                NodeAtom nodeAtom = (NodeAtom)patternElement;
                openForTransformation.add((PatternElement)nodeAtom.value());
                if (nodeAtom.predicate() == null) continue;
                condition = condition.and(nodeAtom.predicate().asCondition());
                continue;
            }
            openForTransformation.add(patternElement);
        }
        List<PatternElement> transformedPatternElements = this.transformIfPossible(patternElementCallbacks, openForTransformation);
        Where where = CypherDslASTFactory.computeFinalWhere(whereIn, condition);
        return (Clause)this.options.getMatchClauseFactory().apply(new MatchDefinition(optional, transformedPatternElements, where, hints));
    }

    private static Where computeFinalWhere(Where whereIn, Condition condition) {
        if (condition == Conditions.noCondition()) {
            return whereIn;
        }
        if (whereIn == null) {
            return Where.from((Expression)condition);
        }
        AtomicReference capturedCondition = new AtomicReference();
        whereIn.accept(segment -> {
            if (segment instanceof Condition) {
                Condition inner = (Condition)segment;
                capturedCondition.compareAndSet(null, inner);
            }
        });
        return Where.from((Expression)((Condition)capturedCondition.get()).and(condition));
    }

    private List<PatternElement> transformIfPossible(List<UnaryOperator<PatternElement>> callbacks, List<PatternElement> patternElements) {
        if (callbacks.isEmpty()) {
            return patternElements;
        }
        Function transformer = Function.identity();
        for (UnaryOperator<PatternElement> callback : callbacks) {
            transformer = transformer.andThen(callback);
        }
        return patternElements.stream().map(transformer).filter(Objects::nonNull).toList();
    }

    @Override
    public Hint usingIndexHint(InputPosition p, Expression v, String labelOrRelType, List<String> properties, boolean seekOnly, HintIndexType indexType) {
        Node node = Cypher.node((String)labelOrRelType, (String[])new String[0]).named(CypherDslASTFactory.assertSymbolicName(v));
        return Hint.useIndexFor((boolean)seekOnly, (Property[])((Property[])properties.stream().map(arg_0 -> ((Node)node).property(arg_0)).toArray(Property[]::new)));
    }

    @Override
    public Hint usingJoin(InputPosition p, List<Expression> joinVariables) {
        return Hint.useJoinOn((SymbolicName[])((SymbolicName[])joinVariables.stream().map(CypherDslASTFactory::assertSymbolicName).toArray(SymbolicName[]::new)));
    }

    @Override
    public Hint usingScan(InputPosition p, Expression v, String label) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        return Hint.useScanFor((Node)Cypher.node((String)label, (String[])new String[0]).named(s));
    }

    @Override
    public Clause createClause(InputPosition p, List<PatternElement> patternElements) {
        List<UnaryOperator<PatternElement>> callbacks = this.options.getOnNewPatternElementCallbacks().getOrDefault((Object)PatternElementCreatedEventType.ON_CREATE, List.of());
        return Clauses.create(this.transformIfPossible(callbacks, patternElements.stream().map(v -> {
            PatternElement patternElement;
            if (v instanceof NodeAtom) {
                NodeAtom n = (NodeAtom)v;
                patternElement = n.value();
            } else {
                patternElement = v;
            }
            return patternElement;
        }).toList()));
    }

    @Override
    public Clause setClause(InputPosition p, List<Expression> setItems) {
        return Clauses.set(setItems);
    }

    @Override
    public Operation setProperty(Property property, Expression value) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_SET_PROPERTY, property.to(value));
    }

    @Override
    public Operation setVariable(Expression v, Expression value) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_SET_VARIABLE, Operations.set((Expression)v, (Expression)value));
    }

    @Override
    public Operation addAndSetVariable(Expression v, Expression value) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_ADD_AND_SET_VARIABLE, Operations.mutate((Expression)v, (Expression)value));
    }

    @Override
    public Operation setLabels(Expression v, List<ASTFactory.StringPos<InputPosition>> values) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        String[] labels = this.computeFinalLabelList(LabelParsedEventType.ON_SET, values);
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_SET_LABELS, Operations.set((Node)Cypher.anyNode((SymbolicName)s), (String[])labels));
    }

    @Override
    public Clause removeClause(InputPosition p, List<Expression> removeItems) {
        return Clauses.remove(removeItems);
    }

    @Override
    public Expression removeProperty(Property property) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_REMOVE_PROPERTY, property);
    }

    @Override
    public Expression removeLabels(Expression v, List<ASTFactory.StringPos<InputPosition>> values) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        String[] labels = this.computeFinalLabelList(LabelParsedEventType.ON_REMOVE, values);
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_REMOVE_LABELS, Operations.remove((Node)Cypher.anyNode((SymbolicName)s), (String[])labels));
    }

    @Override
    public Clause deleteClause(InputPosition p, boolean detach, List<Expression> expressions) {
        return Clauses.delete((boolean)detach, this.applyCallbackFor(ExpressionCreatedEventType.ON_DELETE_ITEM, expressions));
    }

    @Override
    public Clause unwindClause(InputPosition p, Expression e, Expression v) {
        return Clauses.unwind((Expression)e, (SymbolicName)CypherDslASTFactory.assertSymbolicName(v));
    }

    @Override
    public Clause mergeClause(InputPosition p, PatternElement patternElementIn, List<Clause> setClauses, List<ASTFactory.MergeActionType> actionTypes, List<InputPosition> positions) {
        PatternElement patternElement;
        if (patternElementIn instanceof NodeAtom) {
            NodeAtom n = (NodeAtom)patternElementIn;
            patternElement = n.value();
        } else {
            patternElement = patternElementIn;
        }
        PatternElement patternElement2 = patternElement;
        ArrayList<MergeAction> mergeActions = new ArrayList<MergeAction>();
        if (setClauses != null && !setClauses.isEmpty() && actionTypes != null && !actionTypes.isEmpty()) {
            Iterator<Clause> iteratorClauses = setClauses.iterator();
            Iterator<ASTFactory.MergeActionType> iteratorTypes = actionTypes.iterator();
            block4: while (iteratorClauses.hasNext() && iteratorTypes.hasNext()) {
                ASTFactory.MergeActionType type = iteratorTypes.next();
                switch (type) {
                    case OnCreate: {
                        mergeActions.add(MergeAction.of((MergeAction.Type)MergeAction.Type.ON_CREATE, (org.neo4j.cypherdsl.core.Set)((org.neo4j.cypherdsl.core.Set)iteratorClauses.next())));
                        continue block4;
                    }
                    case OnMatch: {
                        mergeActions.add(MergeAction.of((MergeAction.Type)MergeAction.Type.ON_MATCH, (org.neo4j.cypherdsl.core.Set)((org.neo4j.cypherdsl.core.Set)iteratorClauses.next())));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unsupported MergeActionType: " + type);
            }
        }
        List<UnaryOperator<PatternElement>> callbacks = this.options.getOnNewPatternElementCallbacks().getOrDefault((Object)PatternElementCreatedEventType.ON_MERGE, List.of());
        return Clauses.merge(this.transformIfPossible(callbacks, List.of(patternElement2)), mergeActions);
    }

    @Override
    public Clause callClause(InputPosition p, InputPosition namespacePosition, InputPosition procedureNamePosition, InputPosition procedureResultPosition, List<String> namespace, String name, List<Expression> arguments, boolean yieldAll, List<Expression> resultItems, Where where) {
        return Clauses.callClause(namespace, (String)name, arguments, yieldAll && resultItems == null ? List.of(Cypher.asterisk()) : resultItems, (Where)where);
    }

    @Override
    public Expression callResultItem(InputPosition p, String name, Expression alias) {
        SymbolicName finalName = Cypher.name((String)name);
        if (alias != null) {
            return finalName.as(CypherDslASTFactory.assertSymbolicName(alias));
        }
        return finalName;
    }

    @Override
    public PatternElement namedPattern(Expression v, PatternElement patternElement) {
        return Cypher.path((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).definedBy(patternElement);
    }

    @Override
    public PatternElement shortestPathPattern(InputPosition p, PatternElement patternElement) {
        CypherDslASTFactory.isInstanceOf(RelationshipPattern.class, patternElement, "Only relationship patterns are supported for the shortestPath function.");
        return new ExpressionAsPatternElementWrapper((Expression)FunctionInvocation.create((FunctionInvocation.FunctionDefinition)PatternElementFunctions.SHORTEST_PATH, (PatternElement)patternElement));
    }

    @Override
    public PatternElement allShortestPathsPattern(InputPosition p, PatternElement patternElement) {
        CypherDslASTFactory.isInstanceOf(RelationshipPattern.class, patternElement, "Only relationship patterns are supported for the allShortestPaths function.");
        return new ExpressionAsPatternElementWrapper((Expression)FunctionInvocation.create((FunctionInvocation.FunctionDefinition)PatternElementFunctions.ALL_SHORTEST_PATHS, (PatternElement)patternElement));
    }

    @Override
    public PatternElement pathPattern(List<PatternAtom> atoms, ASTFactory.NULL aNull) {
        if (atoms.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PatternElement from an empty list of patterns.");
        }
        List<NodeAtom> nodes = atoms.stream().filter(NodeAtom.class::isInstance).map(NodeAtom.class::cast).toList();
        List<PathAtom> relationships = atoms.stream().filter(PathAtom.class::isInstance).map(PathAtom.class::cast).toList();
        if (nodes.size() == 1 && relationships.isEmpty()) {
            return nodes.get(0);
        }
        if (nodes.size() != relationships.size() + 1) {
            throw new IllegalArgumentException("Something weird has happened. Got " + nodes.size() + " nodes and " + relationships.size() + " path details.");
        }
        ExposesRelationships<?> relationshipPattern = nodes.get(0).value();
        for (int i = 1; i < nodes.size(); ++i) {
            Node node = nodes.get(i).value();
            PathAtom pathAtom = relationships.get(i - 1);
            PathLength length = pathAtom.getLength();
            relationshipPattern = switch (pathAtom.getDirection()) {
                default -> throw new IncompatibleClassChangeError();
                case Relationship.Direction.LTR -> relationshipPattern.relationshipTo(node, pathAtom.getTypes());
                case Relationship.Direction.RTL -> relationshipPattern.relationshipFrom(node, pathAtom.getTypes());
                case Relationship.Direction.UNI -> relationshipPattern.relationshipBetween(node, pathAtom.getTypes());
            };
            relationshipPattern = CypherDslASTFactory.applyOptionalName(relationshipPattern, pathAtom);
            relationshipPattern = CypherDslASTFactory.applyOptionalProperties(relationshipPattern, pathAtom);
            relationshipPattern = CypherDslASTFactory.applyOptionalLength(relationshipPattern, length);
        }
        return (PatternElement)relationshipPattern;
    }

    @Override
    public ASTFactory.NULL anyPathSelector(String count, InputPosition countPosition, InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allPathSelector(InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL anyShortestPathSelector(String count, InputPosition countPosition, InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allShortestPathSelector(InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL shortestGroupsSelector(String count, InputPosition countPosition, InputPosition position) {
        throw new UnsupportedOperationException();
    }

    private static ExposesRelationships<?> applyOptionalLength(ExposesRelationships<?> relationshipPattern, PathLength length) {
        if (length == null) {
            return relationshipPattern;
        }
        if (length.isUnbounded()) {
            return ((ExposesPatternLengthAccessors)relationshipPattern).unbounded();
        }
        return ((ExposesPatternLengthAccessors)relationshipPattern).length(length.getMinimum(), length.getMaximum());
    }

    private static ExposesRelationships<?> applyOptionalProperties(ExposesRelationships<?> relationshipPattern, PathAtom pathAtom) {
        if (pathAtom.getProperties() == null) {
            return relationshipPattern;
        }
        if (relationshipPattern instanceof ExposesProperties) {
            ExposesProperties exposesProperties = (ExposesProperties)relationshipPattern;
            return (ExposesRelationships)exposesProperties.withProperties(pathAtom.getProperties());
        }
        return ((RelationshipChain)relationshipPattern).properties(pathAtom.getProperties());
    }

    private static ExposesRelationships<?> applyOptionalName(ExposesRelationships<?> relationshipPattern, PathAtom pathAtom) {
        if (pathAtom.getName() == null) {
            return relationshipPattern;
        }
        if (relationshipPattern instanceof Relationship) {
            Relationship relationship = (Relationship)relationshipPattern;
            return relationship.named(pathAtom.getName());
        }
        return ((RelationshipChain)relationshipPattern).named(pathAtom.getName());
    }

    @Override
    public NodeAtom nodePattern(InputPosition p, Expression v, LabelExpression labels, Expression properties, Expression predicate) {
        Node node;
        if (labels == null) {
            node = Cypher.anyNode();
        } else {
            Optional<String[]> finalLabels = this.computeFinalLabelList(LabelParsedEventType.ON_NODE_PATTERN, labels);
            node = finalLabels.map(l -> {
                String primaryLabel = l[0];
                List<String> additionalLabels = Arrays.stream(l).skip(1L).toList();
                return Cypher.node((String)primaryLabel, additionalLabels);
            }).orElseGet(() -> Cypher.node((LabelExpression)labels));
        }
        if (v != null) {
            node = node.named(CypherDslASTFactory.assertSymbolicName(v));
        }
        if (properties != null) {
            node = (Node)node.withProperties((MapExpression)properties);
        }
        return new NodeAtom(node, predicate);
    }

    @Override
    public PathAtom relationshipPattern(InputPosition p, boolean left, boolean right, Expression v, LabelExpression relTypes, PathLength pathLength, Expression properties, Expression predicate) {
        return PathAtom.of(CypherDslASTFactory.assertSymbolicName(v), pathLength, left, right, this.computeFinalTypeList(TypeParsedEventType.ON_RELATIONSHIP_PATTERN, relTypes), (MapExpression)properties);
    }

    @Override
    public PathLength pathLength(InputPosition p, InputPosition pMin, InputPosition pMax, String minLength, String maxLength) {
        return PathLength.of(minLength, maxLength);
    }

    @Override
    public ASTFactory.NULL intervalPathQuantifier(InputPosition p, InputPosition posLowerBound, InputPosition posUpperBound, String lowerBound, String upperBound) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL fixedPathQuantifier(InputPosition p, InputPosition valuePos, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL plusPathQuantifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL starPathQuantifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL repeatableElements(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL differentRelationships(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PatternAtom parenthesizedPathPattern(InputPosition p, PatternElement internalPattern, Expression where, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PatternAtom quantifiedRelationship(PathAtom rel, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause loadCsvClause(InputPosition p, boolean headers, Expression source, Expression v, String fieldTerminator) {
        CypherDslASTFactory.isInstanceOf(StringLiteral.class, source, "Only string literals are supported as source for the LOAD CSV clause.");
        return Clauses.loadCSV((boolean)headers, (StringLiteral)((StringLiteral)source), (SymbolicName)CypherDslASTFactory.assertSymbolicName(v), (String)fieldTerminator);
    }

    @Override
    public Clause foreachClause(InputPosition p, Expression v, Expression list, List<Clause> objects) {
        return Clauses.forEach((SymbolicName)CypherDslASTFactory.assertSymbolicName(v), (Expression)list, objects);
    }

    @Override
    public Clause subqueryClause(InputPosition p, Statement subquery, ASTFactory.NULL inTransactions) {
        return Clauses.callClause((Statement)subquery);
    }

    @Override
    public Clause yieldClause(InputPosition p, boolean returnAll, List<Expression> expressions, InputPosition returnItemsPosition, List<SortItem> orderBy, InputPosition orderPos, Expression skip, InputPosition skipPosition, Expression limit, InputPosition limitPosition, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showIndexClause(InputPosition p, ShowCommandFilterTypes indexType, boolean brief, boolean verbose, Where where, boolean hasYield) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showConstraintClause(InputPosition p, ShowCommandFilterTypes constraintType, boolean brief, boolean verbose, Where where, boolean hasYield) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showProcedureClause(InputPosition p, boolean currentUser, String user, Where where, boolean hasYield) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showFunctionClause(InputPosition p, ShowCommandFilterTypes functionType, boolean currentUser, String user, Where where, boolean hasYield) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement useGraph(Statement command, Clause useGraph) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createRole(InputPosition p, boolean replace, SimpleEither<String, Parameter<?>> roleName, SimpleEither<String, Parameter<?>> fromRole, boolean ifNotExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropRole(InputPosition p, SimpleEither<String, Parameter<?>> roleName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement renameRole(InputPosition p, SimpleEither<String, Parameter<?>> fromRoleName, SimpleEither<String, Parameter<?>> toRoleName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showRoles(InputPosition p, boolean withUsers, boolean showAll, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement grantRoles(InputPosition p, List<SimpleEither<String, Parameter<?>>> roles, List<SimpleEither<String, Parameter<?>>> users) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement revokeRoles(InputPosition p, List<SimpleEither<String, Parameter<?>>> roles, List<SimpleEither<String, Parameter<?>>> users) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createUser(InputPosition p, boolean replace, boolean ifNotExists, SimpleEither<String, Parameter<?>> username, Expression password, boolean encrypted, boolean changeRequired, Boolean suspended, DatabaseName homeDatabase) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropUser(InputPosition p, boolean ifExists, SimpleEither<String, Parameter<?>> username) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement renameUser(InputPosition p, SimpleEither<String, Parameter<?>> fromUserName, SimpleEither<String, Parameter<?>> toUserName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement setOwnPassword(InputPosition p, Expression currentPassword, Expression newPassword) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterUser(InputPosition p, boolean ifExists, SimpleEither<String, Parameter<?>> username, Expression password, boolean encrypted, Boolean changeRequired, Boolean suspended, DatabaseName homeDatabase, boolean removeHome) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression passwordExpression(Parameter<?> password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression passwordExpression(InputPosition p, String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showUsers(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showCurrentUser(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showSupportedPrivileges(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showAllPrivileges(InputPosition p, boolean asCommand, boolean asRevoke, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showRolePrivileges(InputPosition p, List<SimpleEither<String, Parameter<?>>> roles, boolean asCommand, boolean asRevoke, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showUserPrivileges(InputPosition p, List<SimpleEither<String, Parameter<?>>> users, boolean asCommand, boolean asRevoke, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createDatabase(InputPosition p, boolean replace, DatabaseName databaseName, boolean ifNotExists, ASTFactory.NULL aNull, SimpleEither<Map<String, Expression>, Parameter<?>> options, Integer topologyPrimaries, Integer topologySecondaries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createCompositeDatabase(InputPosition p, boolean replace, DatabaseName compositeDatabaseName, boolean ifNotExists, SimpleEither<Map<String, Expression>, Parameter<?>> databaseOptions, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropDatabase(InputPosition p, DatabaseName databaseName, boolean ifExists, boolean composite, boolean dumpData, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterDatabase(InputPosition p, DatabaseName databaseName, boolean ifExists, AccessType accessType, Integer topologyPrimaries, Integer topologySecondaries, Map<String, Expression> newOptions, Set<String> optionsToRemove, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showDatabase(InputPosition p, ASTFactory.NULL scope, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement startDatabase(InputPosition p, DatabaseName databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement stopDatabase(InputPosition p, DatabaseName databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL databaseScope(InputPosition p, DatabaseName databaseName, boolean isDefault, boolean isHome) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropAlias(InputPosition p, DatabaseName aliasName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showAliases(InputPosition p, DatabaseName aliasName, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL wait(boolean wait, long seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseName databaseName(InputPosition p, List<String> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException("No database name");
        }
        if (names.size() == 1) {
            return new DatabaseName((Expression)Cypher.literalOf((Object)names.get(0)));
        }
        return new DatabaseName((Expression)Cypher.literalOf(names));
    }

    @Override
    public DatabaseName databaseName(Parameter<?> param) {
        return new DatabaseName((Expression)param);
    }

    @Override
    public Statement createLocalDatabaseAlias(InputPosition p, boolean replace, DatabaseName aliasName, DatabaseName targetName, boolean ifNotExists, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createRemoteDatabaseAlias(InputPosition p, boolean replace, DatabaseName aliasName, DatabaseName targetName, boolean ifNotExists, SimpleEither<String, Parameter<?>> url, SimpleEither<String, Parameter<?>> username, Expression password, SimpleEither<Map<String, Expression>, Parameter<?>> driverSettings, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterLocalDatabaseAlias(InputPosition p, DatabaseName aliasName, DatabaseName targetName, boolean ifExists, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterRemoteDatabaseAlias(InputPosition p, DatabaseName aliasName, DatabaseName targetName, boolean ifExists, SimpleEither<String, Parameter<?>> url, SimpleEither<String, Parameter<?>> username, Expression password, SimpleEither<Map<String, Expression>, Parameter<?>> driverSettings, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression newVariable(InputPosition p, String name) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_VARIABLE, Cypher.name((String)name));
    }

    @Override
    public Parameter<?> newParameter(InputPosition p, Expression v, ParameterType type) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_PARAMETER, (Expression)this.parameterFromSymbolicName(v));
    }

    @Override
    public Parameter<?> newParameter(InputPosition p, String v, ParameterType type) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_PARAMETER, (Expression)this.parameterFromSymbolicName((Expression)Cypher.name((String)v)));
    }

    @Override
    public Parameter<?> newSensitiveStringParameter(InputPosition p, Expression v) {
        throw new UnsupportedOperationException("The Cypher-DSL does not support sensitive parameters.");
    }

    @Override
    public Parameter<?> newSensitiveStringParameter(InputPosition p, String v) {
        throw new UnsupportedOperationException("The Cypher-DSL does not support sensitive parameters.");
    }

    @NotNull
    Parameter<?> parameterFromSymbolicName(Expression v) {
        SymbolicName symbolicName = CypherDslASTFactory.assertSymbolicName(v);
        if (symbolicName == null) {
            return Cypher.anonParameter((Object)Cypher.literalNull());
        }
        String name = symbolicName.getValue();
        return this.options.getParameterValues().containsKey(name) ? Cypher.parameter((String)name, (Object)this.options.getParameterValues().get(name)) : Cypher.parameter((String)name);
    }

    @Override
    public Expression newDouble(InputPosition p, String image) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)Double.parseDouble(image)));
    }

    @Override
    public Expression newDecimalInteger(InputPosition p, String image, boolean negated) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)(Long.parseUnsignedLong(image) * (long)(negated ? -1 : 1))));
    }

    @Override
    public Expression newHexInteger(InputPosition p, String image, boolean negated) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)(Long.parseUnsignedLong(image.replaceFirst("(?i)0x", ""), 16) * (long)(negated ? -1 : 1))));
    }

    @Override
    public Expression newOctalInteger(InputPosition p, String image, boolean negated) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)(Long.parseUnsignedLong(image.replaceFirst("(?i)0o", ""), 8) * (long)(negated ? -1 : 1))));
    }

    @Override
    public Expression newString(InputPosition p, String image) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)image));
    }

    @Override
    public Expression newTrueLiteral(InputPosition p) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalTrue());
    }

    @Override
    public Expression newFalseLiteral(InputPosition p) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalFalse());
    }

    @Override
    public Expression newInfinityLiteral(InputPosition p) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, InfinityLiteral.INSTANCE);
    }

    @Override
    public Expression newNaNLiteral(InputPosition p) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, NaNLiteral.INSTANCE);
    }

    @Override
    public Expression newNullLiteral(InputPosition p) {
        return this.applyCallbackFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalNull());
    }

    @Override
    public Expression listLiteral(InputPosition p, List<Expression> values) {
        return Cypher.listOf((Expression[])values.toArray(new Expression[0]));
    }

    @Override
    public MapExpression mapLiteral(InputPosition p, List<ASTFactory.StringPos<InputPosition>> keys, List<Expression> values) {
        Object[] keysAndValues = new Object[keys.size() * 2];
        int i = 0;
        Iterator<Expression> valueIterator = values.iterator();
        for (ASTFactory.StringPos<InputPosition> key : keys) {
            keysAndValues[i++] = key.string;
            keysAndValues[i++] = valueIterator.next();
        }
        return this.options.isCreateSortedMaps() ? Cypher.sortedMapOf((Object[])keysAndValues) : Cypher.mapOf((Object[])keysAndValues);
    }

    @Override
    public Property property(Expression subject, ASTFactory.StringPos<InputPosition> propertyKeyName) {
        return subject.property(new String[]{propertyKeyName.string});
    }

    @Override
    public Expression or(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.asCondition().or(rhs.asCondition());
    }

    @Override
    public Expression xor(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.asCondition().xor(rhs.asCondition());
    }

    @Override
    public Expression and(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.asCondition().and(rhs.asCondition());
    }

    @Override
    public LabelExpression labelConjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return lhs.and(rhs);
    }

    @Override
    public LabelExpression labelDisjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return lhs.or(rhs);
    }

    @Override
    public LabelExpression labelNegation(InputPosition p, LabelExpression e, boolean containsIs) {
        return e.negate();
    }

    @Override
    public LabelExpression labelWildcard(InputPosition p, boolean containsIs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LabelExpression labelLeaf(InputPosition p, String e, EntityType entityType, boolean containsIs) {
        return new LabelExpression(e);
    }

    @Override
    public LabelExpression labelColonConjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return CypherDslASTFactory.colonJunjction(lhs, rhs, LabelExpression.Type.COLON_CONJUNCTION);
    }

    @Override
    public LabelExpression labelColonDisjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return CypherDslASTFactory.colonJunjction(lhs, rhs, LabelExpression.Type.COLON_DISJUNCTION);
    }

    @NotNull
    private static LabelExpression colonJunjction(LabelExpression lhs, LabelExpression rhs, LabelExpression.Type colonDisjunction) {
        ArrayList value = new ArrayList();
        value.addAll(lhs.value());
        value.addAll(rhs.value());
        return new LabelExpression(colonDisjunction, false, value, null, null);
    }

    @Override
    public Expression labelExpressionPredicate(Expression subject, LabelExpression exp) {
        if (!(subject instanceof SymbolicName)) {
            throw new IllegalArgumentException("Expected an symbolic name to create a label based expression predicate!");
        }
        SymbolicName symbolicName = (SymbolicName)subject;
        ArrayList values = new ArrayList();
        for (LabelExpression current = exp; current != null; current = current.rhs()) {
            values.addAll(current.value());
        }
        return Conditions.hasLabelsOrType((SymbolicName)symbolicName, (String[])((String[])values.toArray(String[]::new)));
    }

    @Override
    public Expression ands(List<Expression> exprs) {
        return (Expression)exprs.stream().reduce(Conditions.noCondition(), (l, r) -> l.asCondition().and(r.asCondition()));
    }

    @Override
    public Expression not(InputPosition p, Expression e) {
        return e.asCondition().not();
    }

    @Override
    public Expression plus(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.add(rhs);
    }

    @Override
    public Expression minus(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.subtract(rhs);
    }

    @Override
    public Expression multiply(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.multiply(rhs);
    }

    @Override
    public Expression divide(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.divide(rhs);
    }

    @Override
    public Expression modulo(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.remainder(rhs);
    }

    @Override
    public Expression pow(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.pow(rhs);
    }

    @Override
    public Expression unaryPlus(Expression e) {
        return Operations.plus((Expression)e);
    }

    @Override
    public Expression unaryPlus(InputPosition inputPosition, Expression expression) {
        return Operations.plus((Expression)expression);
    }

    @Override
    public Expression unaryMinus(InputPosition inputPosition, Expression expression) {
        return Operations.minus((Expression)expression);
    }

    @Override
    public Expression eq(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.eq(rhs);
    }

    @Override
    public Expression neq(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.ne(rhs);
    }

    @Override
    public Expression neq2(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.ne(rhs);
    }

    @Override
    public Expression lte(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.lte(rhs);
    }

    @Override
    public Expression gte(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.gte(rhs);
    }

    @Override
    public Expression lt(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.lt(rhs);
    }

    @Override
    public Expression gt(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.gt(rhs);
    }

    @Override
    public Expression regeq(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.matches(rhs);
    }

    @Override
    public Expression startsWith(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.startsWith(rhs);
    }

    @Override
    public Expression endsWith(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.endsWith(rhs);
    }

    @Override
    public Expression contains(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.contains(rhs);
    }

    @Override
    public Expression in(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.in(rhs);
    }

    @Override
    public Expression isNull(InputPosition p, Expression e) {
        return e.isNull();
    }

    @Override
    public Expression isNotNull(InputPosition p, Expression e) {
        return e.isNotNull();
    }

    @Override
    public Expression isTyped(InputPosition p, Expression e, ParserCypherTypeName typeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression isNotTyped(InputPosition p, Expression e, ParserCypherTypeName typeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression listLookup(Expression list, Expression index) {
        return Cypher.valueAt((Expression)list, (Expression)index);
    }

    @Override
    public Expression listSlice(InputPosition p, Expression list, Expression start, Expression end) {
        return Cypher.subList((Expression)list, (Expression)start, (Expression)end);
    }

    @Override
    public Expression newCountStar(InputPosition p) {
        return Functions.count((Expression)Cypher.asterisk());
    }

    @Override
    public Expression functionInvocation(InputPosition p, InputPosition functionNamePosition, List<String> namespace, String name, boolean distinct, List<Expression> arguments) {
        String[] parts = new String[namespace.size() + 1];
        for (int i = 0; i < namespace.size(); ++i) {
            parts[i] = namespace.get(i);
        }
        parts[parts.length - 1] = name;
        return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String[])parts).withArgs((Expression[])arguments.toArray(Expression[]::new))).asFunction(distinct);
    }

    @Override
    public Expression listComprehension(InputPosition p, Expression v, Expression list, Expression where, Expression projection) {
        ListComprehension.OngoingDefinitionWithList in = Cypher.listWith((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list);
        if (where != null) {
            ListComprehension.OngoingDefinitionWithoutReturn ongoingComprehension = in.where(where.asCondition());
            if (projection != null) {
                return ongoingComprehension.returning(new Expression[]{projection});
            }
            return ongoingComprehension.returning();
        }
        return in.returning(new Expression[]{projection});
    }

    @Override
    public Expression patternComprehension(InputPosition p, InputPosition relationshipPatternPosition, Expression v, PatternElement patternElement, Expression where, Expression projection) {
        PatternComprehension.OngoingDefinitionWithPattern ongoingDefinitionWithPattern;
        if (patternElement instanceof RelationshipPattern) {
            RelationshipPattern relationshipPattern = (RelationshipPattern)patternElement;
            ongoingDefinitionWithPattern = v != null ? Cypher.listBasedOn((NamedPath)Cypher.path((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).definedBy((PatternElement)relationshipPattern)) : Cypher.listBasedOn((RelationshipPattern)relationshipPattern);
        } else if (patternElement instanceof NamedPath) {
            NamedPath namedPath = (NamedPath)patternElement;
            ongoingDefinitionWithPattern = Cypher.listBasedOn((NamedPath)namedPath);
        } else {
            throw new IllegalArgumentException("Cannot build a pattern comprehension around " + patternElement.getClass().getSimpleName());
        }
        if (where != null) {
            ongoingDefinitionWithPattern = ongoingDefinitionWithPattern.where(where.asCondition());
        }
        return ongoingDefinitionWithPattern.returning(new Expression[]{projection});
    }

    @Override
    public Expression reduceExpression(InputPosition p, Expression acc, Expression accExpr, Expression v, Expression list, Expression innerExpr) {
        SymbolicName variable = CypherDslASTFactory.assertSymbolicName(v);
        if (variable == null) {
            throw new IllegalArgumentException("A variable to be reduced must be present.");
        }
        return Functions.reduce((SymbolicName)variable).in(list).map(innerExpr).accumulateOn((Expression)CypherDslASTFactory.assertSymbolicName(acc)).withInitialValueOf(accExpr);
    }

    @Override
    public Expression allExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "all(...) requires a WHERE predicate");
        return Predicates.all((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression anyExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "any(...) requires a WHERE predicate");
        return Predicates.any((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression noneExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "none(...) requires a WHERE predicate");
        return Predicates.none((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression singleExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "single(...) requires a WHERE predicate");
        return Predicates.single((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression patternExpression(InputPosition p, PatternElement patternElement) {
        if (patternElement instanceof ExpressionAsPatternElementWrapper) {
            ExpressionAsPatternElementWrapper wrapper = (ExpressionAsPatternElementWrapper)patternElement;
            return wrapper.getExpression();
        }
        if (patternElement instanceof RelationshipPattern) {
            RelationshipPattern relationshipPattern = (RelationshipPattern)patternElement;
            return new PatternElementAsExpressionWrapper(relationshipPattern);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression existsExpression(InputPosition p, ASTFactory.NULL matchMode, List<PatternElement> patternElements, Statement q, Where where) {
        ElementsAndWhere elementsAndWhere = this.extractElementsAndWhere(patternElements, q, where);
        StatementBuilder.OngoingReadingWithoutWhere match = Cypher.match(elementsAndWhere.elements());
        if (elementsAndWhere.where() == null) {
            return match.asCondition();
        }
        AtomicReference capturedCondition = new AtomicReference();
        elementsAndWhere.where.accept(segment -> {
            if (segment instanceof Condition) {
                Condition condition = (Condition)segment;
                capturedCondition.compareAndSet(null, condition);
            }
        });
        return ((StatementBuilder.OngoingReadingWithWhere)match.where((Condition)capturedCondition.get())).asCondition();
    }

    private ElementsAndWhere extractElementsAndWhere(List<PatternElement> patternElements, Statement q, Where where) {
        Where where0 = where;
        List<PatternElement> patternElements0 = patternElements;
        if (patternElements0 == null && q != null) {
            final AtomicReference capturedWhere = new AtomicReference();
            final AtomicBoolean inMatch = new AtomicBoolean();
            final AtomicReference inPattern = new AtomicReference();
            final ArrayList<PatternElement> capturedElements = new ArrayList<PatternElement>();
            q.accept(new Visitor(){

                public void enter(Visitable segment) {
                    PatternElement patternElement;
                    inMatch.compareAndSet(false, segment instanceof Match);
                    if (!inMatch.get() || capturedWhere.get() != null) {
                        return;
                    }
                    if (segment instanceof Where) {
                        Where innerWhere = (Where)segment;
                        capturedWhere.compareAndSet(null, innerWhere);
                    } else if (segment instanceof PatternElement && inPattern.compareAndSet(null, patternElement = (PatternElement)segment)) {
                        capturedElements.add(patternElement);
                    }
                }

                public void leave(Visitable segment) {
                    inMatch.compareAndSet(true, !(segment instanceof Match));
                    if (segment instanceof PatternElement) {
                        PatternElement patternElement = (PatternElement)segment;
                        inPattern.compareAndSet(patternElement, null);
                    }
                }
            });
            patternElements0 = capturedElements;
            where0 = (Where)capturedWhere.get();
        }
        return new ElementsAndWhere(patternElements0, where0);
    }

    @Override
    public Expression countExpression(InputPosition p, ASTFactory.NULL matchMode, List<PatternElement> patternElements, Statement q, Where where) {
        ElementsAndWhere elementsAndWhere = this.extractElementsAndWhere(patternElements, q, where);
        Expression condition = null;
        if (elementsAndWhere.where() != null) {
            AtomicReference capturedCondition = new AtomicReference();
            elementsAndWhere.where.accept(segment -> {
                if (segment instanceof Condition) {
                    Condition nestedCondition = (Condition)segment;
                    capturedCondition.compareAndSet(null, nestedCondition);
                }
            });
            condition = (Expression)capturedCondition.get();
        }
        List<PatternElement> elements = elementsAndWhere.elements();
        CountExpression count = Expressions.count((PatternElement)elements.get(0), (PatternElement[])((PatternElement[])elements.subList(1, elements.size()).toArray(PatternElement[]::new)));
        if (condition == null) {
            return count;
        }
        return count.where(condition.asCondition());
    }

    @Override
    public Expression collectExpression(InputPosition inputPosition, Statement statement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression mapProjection(InputPosition p, Expression v, List<Expression> items) {
        return MapProjection.create((SymbolicName)CypherDslASTFactory.assertSymbolicName(v), (Object[])items.toArray(new Object[0]));
    }

    @Override
    public Expression mapProjectionLiteralEntry(ASTFactory.StringPos<InputPosition> property, Expression value) {
        return KeyValueMapEntry.create((String)property.string, (Expression)value);
    }

    @Override
    public Expression mapProjectionProperty(ASTFactory.StringPos<InputPosition> property) {
        return PropertyLookup.forName((String)property.string);
    }

    @Override
    public Expression mapProjectionVariable(Expression v) {
        return v;
    }

    @Override
    public Expression mapProjectionAll(InputPosition p) {
        return Cypher.asterisk();
    }

    @Override
    public Expression caseExpression(InputPosition p, Expression e, List<Expression> whens, List<Expression> thens, Expression elze) {
        if (whens != null && thens != null && whens.size() != thens.size()) {
            throw new IllegalArgumentException("Cannot combine lists of whens with a different sized list of thens.");
        }
        Case aCase = Cypher.caseExpression((Expression)e);
        if (whens != null && thens != null) {
            Iterator<Expression> iteratorWhens = whens.iterator();
            Iterator<Expression> iteratorThens = thens.iterator();
            while (iteratorWhens.hasNext() && iteratorThens.hasNext()) {
                aCase = aCase.when(iteratorWhens.next()).then(iteratorThens.next());
            }
            if (elze != null) {
                return ((Case.CaseEnding)aCase).elseDefault(elze);
            }
            return aCase;
        }
        return aCase;
    }

    @Override
    public InputPosition inputPosition(int offset, int line, int column) {
        return new InputPosition(offset, line, column);
    }

    @Override
    public EntityType nodeType() {
        return EntityType.NODE;
    }

    @Override
    public EntityType relationshipType() {
        return EntityType.RELATIONSHIP;
    }

    @Override
    public EntityType nodeOrRelationshipType() {
        return EntityType.LOLWHAT;
    }

    @Override
    public Where whereClause(InputPosition p, Expression optionalWhere) {
        return Where.from((Expression)optionalWhere);
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsParams(InputPosition p, ASTFactory.NULL batchParams, ASTFactory.NULL errorParams, ASTFactory.NULL reportParams) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsBatchParameters(InputPosition p, Expression batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsErrorParameters(InputPosition p, CallInTxsOnErrorBehaviourType onErrorBehaviour) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsReportParameters(InputPosition p, Expression v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showTransactionsClause(InputPosition p, SimpleEither<List<String>, Expression> ids, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause terminateTransactionsClause(InputPosition p, SimpleEither<List<String>, Expression> ids, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause turnYieldToWith(Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showSettingsClause(InputPosition inputPosition, SimpleEither<List<String>, Expression> simpleEither, Where where, boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createConstraint(InputPosition p, ConstraintType constraintType, boolean replace, boolean ifNotExists, String constraintName, Expression expression, ASTFactory.StringPos<InputPosition> label, List<Property> properties, ParserCypherTypeName propertyType, SimpleEither<Map<String, Expression>, Parameter<?>> constraintOptions, boolean containsOn, ConstraintVersion constraintVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropConstraint(InputPosition p, String name, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropConstraint(InputPosition p, ConstraintType constraintType, Expression expression, ASTFactory.StringPos<InputPosition> label, List<Property> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createIndexWithOldSyntax(InputPosition p, ASTFactory.StringPos<InputPosition> label, List<ASTFactory.StringPos<InputPosition>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createLookupIndex(InputPosition p, boolean replace, boolean ifNotExists, boolean isNode, String indexName, Expression expression, ASTFactory.StringPos<InputPosition> functionName, Expression functionParameter, SimpleEither<Map<String, Expression>, Parameter<?>> indexOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createIndex(InputPosition p, boolean replace, boolean ifNotExists, boolean isNode, String indexName, Expression expression, ASTFactory.StringPos<InputPosition> label, List<Property> properties, SimpleEither<Map<String, Expression>, Parameter<?>> indexOptions, CreateIndexTypes indexType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createFulltextIndex(InputPosition p, boolean replace, boolean ifNotExists, boolean isNode, String indexName, Expression expression, List<ASTFactory.StringPos<InputPosition>> labels, List<Property> properties, SimpleEither<Map<String, Expression>, Parameter<?>> indexOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropIndex(InputPosition p, String name, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropIndex(InputPosition p, ASTFactory.StringPos<InputPosition> label, List<ASTFactory.StringPos<InputPosition>> propertyNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement grantPrivilege(InputPosition p, List<SimpleEither<String, Parameter<?>>> roles, ASTFactory.NULL privilege) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement denyPrivilege(InputPosition p, List<SimpleEither<String, Parameter<?>>> roles, ASTFactory.NULL privilege) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement revokePrivilege(InputPosition p, List<SimpleEither<String, Parameter<?>>> roles, ASTFactory.NULL privilege, boolean revokeGrant, boolean revokeDeny) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL databasePrivilege(InputPosition p, ASTFactory.NULL aNull, List<ASTFactory.NULL> scope, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL dbmsPrivilege(InputPosition p, ASTFactory.NULL aNull, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL graphPrivilege(InputPosition p, ASTFactory.NULL aNull, List<ASTFactory.NULL> scope, ASTFactory.NULL aNull2, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL privilegeAction(ActionType action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL propertiesResource(InputPosition p, List<String> property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allPropertiesResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL labelsResource(InputPosition p, List<String> label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allLabelsResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL databaseResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL noResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL labelQualifier(InputPosition p, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL relationshipQualifier(InputPosition p, String relationshipType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL elementQualifier(InputPosition p, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allElementsQualifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allLabelsQualifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allRelationshipsQualifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> allQualifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> allDatabasesQualifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> userQualifier(List<SimpleEither<String, Parameter<?>>> users) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> allUsersQualifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> functionQualifier(InputPosition p, List<String> functions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> procedureQualifier(InputPosition p, List<String> procedures) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> settingQualifier(InputPosition inputPosition, List<String> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> graphScopes(InputPosition p, List<DatabaseName> graphNames, ScopeType scopeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> databaseScopes(InputPosition p, List<DatabaseName> databaseNames, ScopeType scopeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement enableServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName, SimpleEither<Map<String, Expression>, Parameter<?>> serverOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName, SimpleEither<Map<String, Expression>, Parameter<?>> serverOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement renameServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName, SimpleEither<String, Parameter<?>> newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showServers(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement deallocateServers(InputPosition p, boolean dryRun, List<SimpleEither<String, Parameter<?>>> serverNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement reallocateDatabases(InputPosition p, boolean dryRun) {
        throw new UnsupportedOperationException();
    }

    record ElementsAndWhere(List<PatternElement> elements, Where where) {
    }
}

