/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.parser;

import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.parser.PathLength;
import org.neo4j.cypherdsl.parser.PatternAtom;

final class PathAtom
implements PatternAtom {
    private final SymbolicName name;
    private final PathLength length;
    private final Relationship.Direction direction;
    private final String[] types;
    private final MapExpression properties;

    static PathAtom of(SymbolicName name, PathLength length, boolean left, boolean right, String[] relTypes, MapExpression properties) {
        if (left && right) {
            throw new IllegalArgumentException("Only left-to-right, right-to-left or unidirectional path elements are supported.");
        }
        Relationship.Direction direction = left ? Relationship.Direction.RTL : (right ? Relationship.Direction.LTR : Relationship.Direction.UNI);
        return new PathAtom(name, length, direction, relTypes, properties);
    }

    private PathAtom(SymbolicName name, PathLength length, Relationship.Direction direction, String[] types, MapExpression properties) {
        this.name = name;
        this.length = length;
        this.direction = direction;
        this.types = types;
        this.properties = properties;
    }

    public PathLength getLength() {
        return this.length;
    }

    public Relationship.Direction getDirection() {
        return this.direction;
    }

    public String[] getTypes() {
        return this.types;
    }

    public MapExpression getProperties() {
        return this.properties;
    }

    public SymbolicName getName() {
        return this.name;
    }
}

