/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.support.TypedSubtree;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class FunctionInvocation
implements Expression {
    private final String functionName;
    private final TypedSubtree<?, ?> arguments;

    FunctionInvocation(String functionName, Expression ... arguments) {
        this.functionName = functionName;
        this.arguments = new ExpressionList(arguments);
    }

    FunctionInvocation(String functionName, Pattern pattern) {
        this.functionName = functionName;
        this.arguments = pattern;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.arguments.accept(visitor);
        visitor.leave(this);
    }

    public String toString() {
        return "FunctionInvocation{functionName='" + this.functionName + '\'' + '}';
    }
}

