/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.support.TypedSubtree;
import org.neo4j.cypherdsl.core.support.Visitable;

@API(status=API.Status.INTERNAL, since="1.0")
public final class MapExpression<S extends MapExpression<S>>
extends TypedSubtree<Expression, S>
implements Expression {
    static MapExpression<?> create(Object ... input) {
        Assert.isTrue(input.length % 2 == 0, "Need an even number of input parameters");
        ArrayList<Expression> newContent = new ArrayList<Expression>(input.length / 2);
        HashSet<String> knownKeys = new HashSet<String>();
        for (int i = 0; i < input.length; i += 2) {
            Assert.isInstanceOf(String.class, input[i], "Key needs to be of type String.");
            Assert.isInstanceOf(Expression.class, input[i + 1], "Value needs to be of type Expression.");
            Assert.isTrue(!knownKeys.contains(input[i]), "Duplicate key '" + input[i] + "'");
            KeyValueMapEntry entry = new KeyValueMapEntry((String)input[i], (Expression)input[i + 1]);
            newContent.add(entry);
            knownKeys.add(entry.getKey());
        }
        return new MapExpression((List<Expression>)newContent);
    }

    static MapExpression<?> withEntries(List<Expression> entries) {
        return new MapExpression(entries);
    }

    private MapExpression(List<Expression> children) {
        super(children);
    }

    MapExpression<?> addEntries(List<Expression> entries) {
        ArrayList<Expression> newContent = new ArrayList<Expression>(this.children.size() + entries.size());
        newContent.addAll(this.children);
        newContent.addAll(entries);
        return new MapExpression<S>((List<Expression>)newContent);
    }

    @Override
    protected Visitable prepareVisit(Expression child) {
        return Expressions.nameOrExpression(child);
    }
}

