/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class MapProjection
implements Expression {
    private SymbolicName name;
    private MapExpression<?> map;

    static MapProjection create(SymbolicName name, Object ... content) {
        return new MapProjection(name, MapExpression.withEntries(MapProjection.createNewContent(content)));
    }

    MapProjection(SymbolicName name, MapExpression<?> map) {
        this.name = name;
        this.map = map;
    }

    public MapProjection and(Object ... content) {
        return new MapProjection(this.name, this.map.addEntries(MapProjection.createNewContent(content)));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.name.accept(visitor);
        this.map.accept(visitor);
        visitor.leave(this);
    }

    private static List<Expression> createNewContent(Object ... content) {
        ArrayList<Expression> newContent = new ArrayList<Expression>(content.length);
        HashSet<String> knownKeys = new HashSet<String>();
        String lastKey = null;
        Expression lastExpression = null;
        int i = 0;
        while (i < content.length) {
            Expression entry;
            Object next = i + 1 >= content.length ? null : Expressions.nameOrExpression(content[i + 1]);
            Object current = Expressions.nameOrExpression(content[i]);
            if (current instanceof String) {
                if (next instanceof Expression) {
                    lastKey = (String)current;
                    lastExpression = (Expression)next;
                    i += 2;
                } else {
                    lastKey = null;
                    lastExpression = new PropertyLookup((String)current);
                    ++i;
                }
            } else if (current instanceof Expression) {
                lastKey = null;
                lastExpression = (Expression)current;
                ++i;
            }
            if (lastExpression instanceof Asterisk) {
                lastExpression = new PropertyLookup("*");
            }
            if (lastKey != null) {
                Assert.isTrue(!knownKeys.contains(lastKey), "Duplicate key '" + lastKey + "'");
                entry = new KeyValueMapEntry(lastKey, lastExpression);
                knownKeys.add(lastKey);
            } else if (lastExpression instanceof SymbolicName || lastExpression instanceof PropertyLookup) {
                entry = lastExpression;
            } else if (lastExpression instanceof Property) {
                entry = ((Property)lastExpression).getName();
            } else if (lastExpression instanceof AliasedExpression) {
                AliasedExpression aliasedExpression = (AliasedExpression)lastExpression;
                entry = new KeyValueMapEntry(aliasedExpression.getAlias(), aliasedExpression.getDelegate());
            } else {
                throw new IllegalArgumentException(lastExpression + " of type " + lastExpression.getClass() + " cannot be used with an implicit name as map entry.");
            }
            newContent.add(entry);
            lastKey = null;
            lastExpression = null;
        }
        return newContent;
    }
}

