/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Property
implements Expression {
    private final Expression container;
    private final PropertyLookup name;

    static Property create(Named parentContainer, String name) {
        Assert.isTrue(parentContainer.getSymbolicName().isPresent(), "A property derived from a node or a relationship needs a parent with a symbolic name.");
        Assert.hasText(name, "The properties name is required.");
        return new Property(parentContainer.getRequiredSymbolicName(), new PropertyLookup(name));
    }

    static Property create(Expression container, String name) {
        Assert.notNull(container, "The property container is required.");
        Assert.hasText(name, "The properties name is required.");
        return new Property(container, new PropertyLookup(name));
    }

    Property(Expression container, PropertyLookup name) {
        this.container = container;
        this.name = name;
    }

    public PropertyLookup getName() {
        return this.name;
    }

    public Operation to(Expression expression) {
        return Operations.set(this, expression);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.container.accept(visitor);
        this.name.accept(visitor);
        visitor.leave(this);
    }
}

