/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.UnionPart;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class UnionQuery
implements Statement.RegularQuery {
    private final boolean all;
    private final Statement.SingleQuery firstQuery;
    private final List<UnionPart> additionalQueries;

    static UnionQuery create(boolean unionAll, List<Statement.SingleQuery> queries) {
        Assert.isTrue(queries != null && queries.size() >= 2, "At least two queries are needed.");
        List<UnionPart> unionParts = queries.stream().skip(1L).map(q -> new UnionPart(unionAll, (Statement.SingleQuery)q)).collect(Collectors.toList());
        return new UnionQuery(unionAll, queries.get(0), unionParts);
    }

    private UnionQuery(boolean all, Statement.SingleQuery firstQuery, List<UnionPart> additionalQueries) {
        this.all = all;
        this.firstQuery = firstQuery;
        this.additionalQueries = additionalQueries;
    }

    UnionQuery addAdditionalQueries(List<Statement.SingleQuery> newAdditionalQueries) {
        ArrayList<Statement.SingleQuery> queries = new ArrayList<Statement.SingleQuery>();
        queries.add(this.firstQuery);
        queries.addAll(this.additionalQueries.stream().map(UnionPart::getQuery).collect(Collectors.toList()));
        queries.addAll(newAdditionalQueries);
        return UnionQuery.create(this.isAll(), queries);
    }

    boolean isAll() {
        return this.all;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.firstQuery.accept(visitor);
        this.additionalQueries.forEach(q -> q.accept(visitor));
        visitor.leave(this);
    }
}

