/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.cypherdsl.core.renderer.RenderingVisitor;

enum CypherRenderer implements Renderer
{
    INSTANCE;

    private final int STATEMENT_CACHE_SIZE = 128;
    private final LinkedHashMap<Integer, String> renderedStatementCache = new LRUCache<Integer, String>(128);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(Statement statement) {
        String renderedContent;
        int key = Objects.hashCode(statement);
        try {
            this.read.lock();
            renderedContent = this.renderedStatementCache.get(key);
        }
        finally {
            this.read.unlock();
        }
        if (renderedContent == null) {
            try {
                this.write.lock();
                RenderingVisitor renderingVisitor = new RenderingVisitor();
                statement.accept(renderingVisitor);
                renderedContent = renderingVisitor.getRenderedContent().trim();
                this.renderedStatementCache.put(key, renderedContent);
            }
            finally {
                this.write.unlock();
            }
        }
        return renderedContent;
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private int cacheSize;

        LRUCache(int cacheSize) {
            super(cacheSize / 4, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.cacheSize;
        }
    }
}

