/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.Distinct;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NestedExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipDetail;
import org.neo4j.cypherdsl.core.RelationshipLength;
import org.neo4j.cypherdsl.core.RelationshipTypes;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.UnionPart;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.support.ReflectiveVisitor;
import org.neo4j.cypherdsl.core.support.TypedSubtree;
import org.neo4j.cypherdsl.core.support.Visitable;

class RenderingVisitor
extends ReflectiveVisitor {
    private static final Pattern LABEL_AND_TYPE_QUOTATION = Pattern.compile("`");
    private final StringBuilder builder = new StringBuilder();
    private String separator = null;
    private final java.util.Set<Integer> separatorOnLevel = new HashSet<Integer>();
    private final java.util.Set<Named> visitedNamed = new HashSet<Named>();
    private int currentLevel = 0;
    private boolean skipNodeContent = false;

    RenderingVisitor() {
    }

    private void enableSeparator(int level, boolean on) {
        if (on) {
            this.separatorOnLevel.add(level);
        } else {
            this.separatorOnLevel.remove(level);
        }
        this.separator = null;
    }

    private boolean needsSeparator() {
        return this.separatorOnLevel.contains(this.currentLevel);
    }

    @Override
    protected boolean preEnter(Visitable visitable) {
        if (this.skipNodeContent) {
            return false;
        }
        int nextLevel = ++this.currentLevel + 1;
        if (visitable instanceof TypedSubtree) {
            this.enableSeparator(nextLevel, true);
        }
        if (this.needsSeparator() && this.separator != null) {
            this.builder.append(this.separator);
            this.separator = null;
        }
        return !this.skipNodeContent;
    }

    @Override
    protected void postLeave(Visitable visitable) {
        if (this.needsSeparator()) {
            this.separator = ", ";
        }
        if (visitable instanceof TypedSubtree) {
            this.enableSeparator(this.currentLevel + 1, false);
        }
        --this.currentLevel;
    }

    void enter(Match match) {
        if (match.isOptional()) {
            this.builder.append("OPTIONAL ");
        }
        this.builder.append("MATCH ");
    }

    void leave(Match match) {
        this.builder.append(" ");
    }

    void enter(Where where) {
        this.builder.append(" WHERE ");
    }

    void enter(Create create) {
        this.builder.append("CREATE ");
    }

    void leave(Create create) {
        this.builder.append(" ");
    }

    void enter(Merge merge) {
        this.builder.append("MERGE ");
    }

    void leave(Merge merge) {
        this.builder.append(" ");
    }

    void enter(Distinct distinct) {
        this.builder.append("DISTINCT ");
    }

    void enter(Return returning) {
        this.builder.append("RETURN ");
    }

    void enter(With with) {
        this.builder.append("WITH ");
    }

    void leave(With with) {
        this.builder.append(" ");
    }

    void enter(Delete delete) {
        if (delete.isDetach()) {
            this.builder.append("DETACH ");
        }
        this.builder.append("DELETE ");
    }

    void leave(Delete match) {
        this.builder.append(" ");
    }

    void leave(AliasedExpression aliased) {
        this.builder.append(" AS ").append(aliased.getAlias());
    }

    void enter(NestedExpression nested) {
        this.builder.append("(");
    }

    void leave(NestedExpression nested) {
        this.builder.append(")");
    }

    void enter(Order order) {
        this.builder.append(" ORDER BY ");
    }

    void enter(Skip skip) {
        this.builder.append(" SKIP ");
    }

    void enter(Limit limit) {
        this.builder.append(" LIMIT ");
    }

    void enter(SortItem.Direction direction) {
        this.builder.append(" ").append(direction.getSymbol());
    }

    void enter(PropertyLookup propertyLookup) {
        this.builder.append(".").append(propertyLookup.getPropertyKeyName());
    }

    void enter(FunctionInvocation functionInvocation) {
        this.builder.append(functionInvocation.getFunctionName()).append("(");
    }

    void leave(FunctionInvocation functionInvocation) {
        this.builder.append(")");
    }

    void enter(Operation operation) {
        if (operation.needsGrouping()) {
            this.builder.append("(");
        }
    }

    void enter(Operator operator) {
        Operator.Type type = operator.getType();
        if (type == Operator.Type.LABEL) {
            return;
        }
        if (type != Operator.Type.PREFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
        this.builder.append(operator.getRepresentation());
        if (type != Operator.Type.POSTFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
    }

    void leave(Operation operation) {
        if (operation.needsGrouping()) {
            this.builder.append(")");
        }
    }

    void enter(CompoundCondition compoundCondition) {
        this.builder.append("(");
    }

    void leave(CompoundCondition compoundCondition) {
        this.builder.append(")");
    }

    void enter(Literal<?> expression) {
        this.builder.append(expression.asString());
    }

    void enter(Node node) {
        this.builder.append("(");
        node.getSymbolicName().map(SymbolicName::getValue).ifPresent(symbolicName -> {
            this.skipNodeContent = this.visitedNamed.contains(node);
            this.visitedNamed.add(node);
            if (this.skipNodeContent) {
                this.builder.append((String)symbolicName);
            }
        });
    }

    void leave(Node node) {
        this.builder.append(")");
        this.skipNodeContent = false;
    }

    void enter(NodeLabel nodeLabel) {
        RenderingVisitor.escapeName(nodeLabel.getValue()).ifPresent(label -> this.builder.append(":").append((String)label));
    }

    void enter(Properties properties) {
        this.builder.append(" ");
    }

    void enter(SymbolicName symbolicName) {
        this.builder.append(symbolicName.getValue());
    }

    void enter(RelationshipDetail details) {
        Relationship.Direction direction = details.getDirection();
        this.builder.append(direction.getSymbolLeft());
        if (details.hasContent()) {
            this.builder.append("[");
        }
    }

    void enter(RelationshipTypes types) {
        this.builder.append(types.getValues().stream().map(RenderingVisitor::escapeName).map(Optional::get).collect(Collectors.joining("|", ":", "")));
    }

    void enter(RelationshipLength length) {
        Integer minimum = length.getMinimum();
        Integer maximum = length.getMaximum();
        if (length.isUnbounded()) {
            this.builder.append("*");
            return;
        }
        if (minimum == null && maximum == null) {
            return;
        }
        this.builder.append("*");
        if (minimum != null) {
            this.builder.append(minimum);
        }
        this.builder.append("..");
        if (maximum != null) {
            this.builder.append(maximum);
        }
    }

    void leave(RelationshipDetail details) {
        Relationship.Direction direction = details.getDirection();
        if (details.hasContent()) {
            this.builder.append("]");
        }
        this.builder.append(direction.getSymbolRight());
    }

    void enter(Parameter parameter) {
        this.builder.append("$").append(parameter.getName());
    }

    void enter(MapExpression map) {
        this.builder.append("{");
    }

    void enter(KeyValueMapEntry map) {
        this.builder.append(map.getKey()).append(": ");
    }

    void leave(MapExpression map) {
        this.builder.append("}");
    }

    void enter(ListExpression list) {
        this.builder.append("[");
    }

    void leave(ListExpression list) {
        this.builder.append("]");
    }

    void enter(Unwind unwind) {
        this.builder.append("UNWIND ");
    }

    void leave(Unwind unwind) {
        this.builder.append(" AS ").append(unwind.getVariable()).append(" ");
    }

    void enter(UnionPart unionPart) {
        this.builder.append(" UNION ");
        if (unionPart.isAll()) {
            this.builder.append("ALL ");
        }
    }

    void enter(Set set) {
        this.builder.append("SET ");
    }

    void leave(Set set) {
        this.builder.append(" ");
    }

    void enter(Remove remove) {
        this.builder.append("REMOVE ");
    }

    void leave(Remove remove) {
        this.builder.append(" ");
    }

    void enter(PatternComprehension patternComprehension) {
        this.builder.append("[");
    }

    void leave(PatternComprehension patternComprehension) {
        this.builder.append("]");
    }

    void enter(ListComprehension listComprehension) {
        this.builder.append("[");
    }

    void leave(ListComprehension listComprehension) {
        this.builder.append("]");
    }

    void enter(Case genericCase) {
        this.builder.append("CASE");
    }

    void enter(Case.SimpleCase simpleCase) {
        this.builder.append("CASE ");
    }

    void enter(Case.CaseWhenThen caseWhenExpression) {
        this.builder.append(" WHEN ");
    }

    void leave(Case.CaseWhenThen caseWhenExpression) {
        this.builder.append(" THEN ");
    }

    void enter(Case.CaseElse caseElseExpression) {
        this.builder.append(" ELSE ");
    }

    void leave(Case caseExpression) {
        this.builder.append(" END");
    }

    public String getRenderedContent() {
        return this.builder.toString();
    }

    static Optional<String> escapeName(CharSequence unescapedName) {
        if (unescapedName == null) {
            return Optional.empty();
        }
        Matcher matcher = LABEL_AND_TYPE_QUOTATION.matcher(unescapedName);
        return Optional.of(String.format(Locale.ENGLISH, "`%s`", matcher.replaceAll("``")));
    }
}

