/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Parameter<T>
implements Expression {
    static final Object NO_VALUE = new Object();
    private final String name;
    private final T value;

    static Parameter<Object> create(String name) {
        return Parameter.create(name, NO_VALUE);
    }

    static <T> Parameter<T> create(String name, Object value) {
        Assertions.hasText(name, "The name of the parameter is required!");
        if (name.startsWith("$")) {
            return Parameter.create(name.substring(1), value);
        }
        return new Parameter<Object>(name, value);
    }

    private Parameter(String name, T value) {
        this.name = name;
        this.value = value;
    }

    @API(status=API.Status.INTERNAL)
    public String getName() {
        return this.name;
    }

    @API(status=API.Status.EXPERIMENTAL, since="2021.0.0")
    public Parameter withValue(Object newValue) {
        return Parameter.create(this.name, newValue);
    }

    T getValue() {
        return this.value;
    }

    boolean hasValue() {
        return this.value != NO_VALUE;
    }
}

