/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractStatement;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="1.0")
final class SinglePartQuery
extends AbstractStatement
implements Statement.SingleQuery {
    private final List<Visitable> precedingClauses;
    private final Return aReturn;

    static SinglePartQuery create(List<Visitable> precedingClauses, Return aReturn) {
        if (precedingClauses.isEmpty() || precedingClauses.get(precedingClauses.size() - 1) instanceof Match) {
            Assertions.notNull(aReturn, "A return clause is required.");
        }
        return new SinglePartQuery(precedingClauses, aReturn);
    }

    private SinglePartQuery(List<Visitable> precedingClauses, Return aReturn) {
        this.precedingClauses = new ArrayList<Visitable>(precedingClauses);
        this.aReturn = aReturn;
    }

    @Override
    public void accept(Visitor visitor) {
        this.precedingClauses.forEach(c -> c.accept(visitor));
        Visitable.visitIfNotNull(this.aReturn, visitor);
    }

    boolean doesReturnElements() {
        return this.aReturn != null;
    }
}

