/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.LiteralBase;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL)
final class RawLiteral
implements Expression {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("(?<!\\\\)\\$E");
    private final List<Expression> content;

    static RawLiteral create(String format, Object ... mixedArgs) {
        Assertions.hasText(format, "Cannot create a raw literal without a format.");
        ArrayList<Expression> content = new ArrayList<Expression>();
        Matcher m = EXPRESSION_PATTERN.matcher(format);
        int i = 0;
        int cnt = 0;
        while (m.find()) {
            if (cnt >= mixedArgs.length) {
                throw new IllegalArgumentException("Too few arguments for the raw literal format `" + format + "`.");
            }
            content.add(new RawElement(format.substring(i, m.start())));
            content.add(RawLiteral.getMixedArg(mixedArgs[cnt++]));
            i = m.end();
        }
        if (cnt < mixedArgs.length) {
            throw new IllegalArgumentException("Too many arguments for the raw literal format `" + format + "`.");
        }
        content.add(new RawElement(format.substring(i)));
        return new RawLiteral(Collections.unmodifiableList(content));
    }

    RawLiteral(List<Expression> content) {
        this.content = content;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.content.forEach(expression -> expression.accept(visitor));
        visitor.leave(this);
    }

    private static String unescapeEscapedPlaceholders(String content) {
        return content.replaceAll("\\\\\\$E", "\\$E");
    }

    private static Expression getMixedArg(Object argument) {
        if (argument instanceof Expression) {
            return (Expression)argument;
        }
        return Cypher.literalOf(argument);
    }

    static class RawElement
    extends LiteralBase<String> {
        RawElement(String content) {
            super(RawLiteral.unescapeEscapedPlaceholders(content));
        }

        @Override
        public String asString() {
            return (String)super.getContent();
        }
    }
}

