/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractPropertyContainer;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.InternalRelationshipImpl;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeBase;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="2021.1.0")
public abstract class RelationshipBase<S extends NodeBase<?>, E extends NodeBase<?>, SELF extends RelationshipBase<S, E, SELF>>
extends AbstractPropertyContainer
implements Relationship {
    final Node left;
    final Node right;
    final Relationship.Details details;

    protected RelationshipBase(S start, String type, E end) {
        this(null, (Node)start, Relationship.Direction.LTR, (Node)end, type);
    }

    protected RelationshipBase(SymbolicName symbolicName, Node start, String type, Properties properties, Node end) {
        this(symbolicName, start, Relationship.Direction.LTR, properties, end, type);
    }

    protected RelationshipBase(SymbolicName symbolicName, String type, Node start, Properties properties, Node end) {
        this(symbolicName, start, Relationship.Direction.LTR, properties, end, type);
    }

    public final SELF named(String newSymbolicName) {
        Assertions.hasText(newSymbolicName, "Symbolic name is required.");
        return (SELF)this.named(SymbolicName.of(newSymbolicName));
    }

    public abstract SELF named(SymbolicName var1);

    @Override
    public final SELF withProperties(Object ... keysAndValues) {
        MapExpression newProperties = null;
        if (keysAndValues != null && keysAndValues.length != 0) {
            newProperties = MapExpression.create(keysAndValues);
        }
        return (SELF)this.withProperties(newProperties);
    }

    @Override
    public final SELF withProperties(Map<String, Object> newProperties) {
        return (SELF)this.withProperties(MapExpression.create(newProperties));
    }

    @Override
    public abstract SELF withProperties(MapExpression var1);

    @Override
    public final Node getLeft() {
        return this.left;
    }

    @Override
    public final Node getRight() {
        return this.right;
    }

    @Override
    public final Relationship.Details getDetails() {
        return this.details;
    }

    @Override
    public final Relationship unbounded() {
        return new InternalRelationshipImpl(this.left, this.details.unbounded(), this.right);
    }

    @Override
    public final Relationship min(Integer minimum) {
        return new InternalRelationshipImpl(this.left, this.details.min(minimum), this.right);
    }

    @Override
    public final Relationship max(Integer maximum) {
        return new InternalRelationshipImpl(this.left, this.details.max(maximum), this.right);
    }

    @Override
    public final Relationship length(Integer minimum, Integer maximum) {
        return new InternalRelationshipImpl(this.left, this.details.min(minimum).max(maximum), this.right);
    }

    @Override
    public final Relationship inverse() {
        return new InternalRelationshipImpl(this.right, this.details.inverse(), this.left);
    }

    @Override
    public final Optional<SymbolicName> getSymbolicName() {
        return this.details.getSymbolicName();
    }

    @Override
    public final SymbolicName getRequiredSymbolicName() {
        return this.details.getRequiredSymbolicName();
    }

    @Override
    public final RelationshipChain relationshipTo(Node other, String ... types) {
        return RelationshipChain.create(this).add((Relationship)this.right.relationshipTo(other, types));
    }

    @Override
    public final RelationshipChain relationshipFrom(Node other, String ... types) {
        return RelationshipChain.create(this).add((Relationship)this.right.relationshipFrom(other, types));
    }

    @Override
    public final RelationshipChain relationshipBetween(Node other, String ... types) {
        return RelationshipChain.create(this).add((Relationship)this.right.relationshipBetween(other, types));
    }

    @Override
    public final Condition asCondition() {
        return new RelationshipPatternCondition(this);
    }

    RelationshipBase(SymbolicName symbolicName, Node left, Relationship.Direction direction, Node right, String ... types) {
        this(symbolicName, left, direction, null, right, types);
    }

    RelationshipBase(SymbolicName symbolicName, Node left, Relationship.Direction direction, Properties properties, Node right, String ... types) {
        this(left, Relationship.Details.create(direction, symbolicName, types).with(properties), right);
    }

    RelationshipBase(Node left, Relationship.Details details, Node right) {
        Assertions.notNull(left, "Left node is required.");
        Assertions.notNull(details, "Details are required.");
        Assertions.notNull(right, "Right node is required.");
        this.left = left;
        this.right = right;
        this.details = details;
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.enter(this);
        this.left.accept(visitor);
        this.details.accept(visitor);
        this.right.accept(visitor);
        visitor.leave(this);
    }
}

