/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.ast.ProvidesAffixes;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="1.0")
final class CompoundCondition
implements Condition,
ProvidesAffixes {
    private static final CompoundCondition EMPTY_CONDITION = new CompoundCondition(null);
    static final EnumSet<Operator> VALID_OPERATORS = EnumSet.of(Operator.AND, Operator.OR, Operator.XOR);
    private final Operator operator;
    private final List<Condition> conditions;

    static CompoundCondition create(Condition left, Operator operator, Condition right) {
        Assertions.isTrue(VALID_OPERATORS.contains(operator), "Operator " + operator + " is not a valid operator for a compound condition.");
        Assertions.notNull(left, "Left hand side condition is required.");
        Assertions.notNull(operator, "Operator is required.");
        Assertions.notNull(right, "Right hand side condition is required.");
        return new CompoundCondition(operator).add(operator, left).add(operator, right);
    }

    static CompoundCondition empty() {
        return EMPTY_CONDITION;
    }

    private CompoundCondition(Operator operator) {
        this.operator = operator;
        this.conditions = new ArrayList<Condition>();
    }

    @Override
    public Condition and(Condition condition) {
        return this.add(Operator.AND, condition);
    }

    @Override
    public Condition or(Condition condition) {
        return this.add(Operator.OR, condition);
    }

    @Override
    public Condition xor(Condition condition) {
        return this.add(Operator.XOR, condition);
    }

    private CompoundCondition add(Operator chainingOperator, Condition condition) {
        if (this == EMPTY_CONDITION) {
            return new CompoundCondition(chainingOperator).add(chainingOperator, condition);
        }
        if (condition instanceof CompoundCondition && !((CompoundCondition)condition).hasConditions()) {
            return this;
        }
        if (condition instanceof CompoundCondition) {
            CompoundCondition target;
            CompoundCondition compoundCondition = (CompoundCondition)condition;
            if (this.operator == chainingOperator && chainingOperator == compoundCondition.operator) {
                target = this;
            } else {
                CompoundCondition inner = new CompoundCondition(chainingOperator);
                if (this.hasConditions()) {
                    inner.conditions.add(this);
                }
                target = inner;
            }
            if (compoundCondition.canBeFlattenedWith(chainingOperator)) {
                target.conditions.addAll(compoundCondition.conditions);
            } else {
                target.conditions.add(compoundCondition);
            }
            return target;
        }
        if (this.operator == chainingOperator) {
            this.conditions.add(condition);
            return this;
        }
        return CompoundCondition.create(this, chainingOperator, condition);
    }

    boolean hasConditions() {
        return this != EMPTY_CONDITION && !this.conditions.isEmpty();
    }

    private boolean canBeFlattenedWith(Operator operatorBefore) {
        if (this.operator != operatorBefore) {
            return false;
        }
        for (Condition c : this.conditions) {
            if (!(c instanceof CompoundCondition) || ((CompoundCondition)c).operator == operatorBefore) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(Visitor visitor) {
        boolean hasManyConditions;
        if (this.conditions.isEmpty()) {
            return;
        }
        boolean bl = hasManyConditions = this.conditions.size() > 1;
        if (hasManyConditions) {
            visitor.enter(this);
        }
        CompoundCondition.acceptVisitorWithOperatorForChildCondition(visitor, null, this.conditions.get(0));
        if (hasManyConditions) {
            for (Condition condition : this.conditions.subList(1, this.conditions.size())) {
                CompoundCondition.acceptVisitorWithOperatorForChildCondition(visitor, this.operator, condition);
            }
            visitor.leave(this);
        }
    }

    private static void acceptVisitorWithOperatorForChildCondition(Visitor visitor, Operator operator, Condition condition) {
        Visitable.visitIfNotNull(operator, visitor);
        condition.accept(visitor);
    }

    @Override
    public Optional<String> getPrefix() {
        return Optional.of("(");
    }

    @Override
    public Optional<String> getSuffix() {
        return Optional.of(")");
    }
}

