/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class RelationshipChain
implements RelationshipPattern {
    private final LinkedList<Relationship> relationships;

    static RelationshipChain create(Relationship firstElement) {
        return new RelationshipChain(firstElement);
    }

    private RelationshipChain(Relationship firstElement) {
        this.relationships = new LinkedList();
        this.relationships.add(firstElement);
    }

    private RelationshipChain(List<Relationship> firstElements, Relationship lastElement) {
        this.relationships = new LinkedList<Relationship>(firstElements);
        this.relationships.add(lastElement);
    }

    private RelationshipChain(List<Relationship> elements) {
        this.relationships = new LinkedList<Relationship>(elements);
    }

    RelationshipChain add(Relationship element) {
        Assertions.notNull(element, "Elements of a relationship chain must not be null.");
        return new RelationshipChain(this.relationships, element);
    }

    RelationshipChain replaceLast(Relationship element) {
        Assertions.notNull(element, "Elements of a relationship chain must not be null.");
        RelationshipChain newChain = new RelationshipChain(this.relationships);
        newChain.relationships.removeLast();
        newChain.relationships.add(element);
        return newChain;
    }

    @Override
    public RelationshipChain relationshipTo(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipTo(other, types));
    }

    @Override
    public RelationshipChain relationshipFrom(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipFrom(other, types));
    }

    @Override
    public RelationshipChain relationshipBetween(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipBetween(other, types));
    }

    public RelationshipChain named(String newSymbolicName) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.named(newSymbolicName));
    }

    public RelationshipChain named(SymbolicName newSymbolicName) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.named(newSymbolicName));
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain unbounded() {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.unbounded());
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain min(Integer minimum) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.min(minimum));
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain max(Integer maximum) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.max(maximum));
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain length(Integer minimum, Integer maximum) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.length(minimum, maximum));
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain properties(MapExpression newProperties) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.withProperties(newProperties));
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain properties(Object ... keysAndValues) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.withProperties(keysAndValues));
    }

    @Override
    public Condition asCondition() {
        return new RelationshipPatternCondition(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Node lastNode = null;
        for (Relationship relationship : this.relationships) {
            relationship.getLeft().accept(visitor);
            relationship.getDetails().accept(visitor);
            lastNode = relationship.getRight();
        }
        Visitable.visitIfNotNull(lastNode, visitor);
        visitor.leave(this);
    }
}

