/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Operations {
    private static final Set<Class<? extends Expression>> VALID_MUTATORS = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(MapExpression.class, Parameter.class)));

    public static Operation minus(Expression e) {
        return Operation.create(Operator.UNARY_MINUS, e);
    }

    public static Expression plus(Expression e) {
        return Operation.create(Operator.UNARY_PLUS, e);
    }

    static Operation concat(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.CONCAT, op2);
    }

    static Operation add(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.ADDITION, op2);
    }

    static Operation subtract(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.SUBTRACTION, op2);
    }

    static Operation multiply(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.MULTIPLICATION, op2);
    }

    static Operation divide(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.DIVISION, op2);
    }

    static Operation remainder(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.MODULO_DIVISION, op2);
    }

    static Operation pow(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.EXPONENTIATION, op2);
    }

    static Operation set(Expression target, Expression value) {
        return Operation.create(target, Operator.SET, value);
    }

    static Operation mutate(Expression target, MapExpression value) {
        return Operation.create(target, Operator.MUTATE, value);
    }

    static Operation mutate(Expression target, Expression value) {
        Assertions.notNull(value, "New properties value must not be null");
        Assertions.isTrue(Property.class.isAssignableFrom(value.getClass()) || VALID_MUTATORS.contains(value.getClass()), "A property container can only be mutated by a map, or a parameter or property pointing to a map.");
        return Operation.create(target, Operator.MUTATE, value);
    }

    static Operation set(Node target, String ... label) {
        return Operation.create(target, Operator.SET_LABEL, label);
    }

    static Operation remove(Node target, String ... label) {
        return Operation.create(target, Operator.REMOVE_LABEL, label);
    }

    private Operations() {
    }
}

