/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;
import org.neo4j.cypherdsl.core.utils.CheckReturnValue;

@API(status=API.Status.EXPERIMENTAL, since="1.0.1")
public final class ListComprehension
implements Expression {
    private final SymbolicName variable;
    private final Expression listExpression;
    private final Where where;
    private final Expression listDefinition;

    static OngoingDefinitionWithVariable with(SymbolicName variable) {
        Assertions.notNull(variable, "A variable is required");
        return new Builder(variable);
    }

    private ListComprehension(SymbolicName variable, Expression listExpression, Where where, Expression listDefinition) {
        this.variable = variable;
        this.listExpression = listExpression;
        this.where = where;
        this.listDefinition = listDefinition;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.variable.accept(visitor);
        Operator.IN.accept(visitor);
        this.listExpression.accept(visitor);
        Visitable.visitIfNotNull(this.where, visitor);
        if (this.listDefinition != null) {
            Operator.PIPE.accept(visitor);
            this.listDefinition.accept(visitor);
        }
        visitor.leave(this);
    }

    private static class Builder
    implements OngoingDefinitionWithVariable,
    OngoingDefinitionWithList {
        private final SymbolicName variable;
        private Expression listExpression;
        private Where where;

        private Builder(SymbolicName variable) {
            this.variable = variable;
        }

        @Override
        @NotNull
        public OngoingDefinitionWithList in(Expression list) {
            this.listExpression = list;
            return this;
        }

        @Override
        @NotNull
        public OngoingDefinitionWithoutReturn where(Condition condition) {
            this.where = new Where(condition);
            return this;
        }

        @Override
        @NotNull
        public ListComprehension returning() {
            return new ListComprehension(this.variable, this.listExpression, this.where, null);
        }

        @Override
        @NotNull
        public ListComprehension returning(Expression ... expressions) {
            return new ListComprehension(this.variable, this.listExpression, this.where, ListExpression.listOrSingleExpression(expressions));
        }
    }

    public static interface OngoingDefinitionWithoutReturn {
        @NotNull
        @Contract(pure=true)
        default public ListComprehension returning(Named ... variables) {
            return this.returning(Expressions.createSymbolicNames(variables));
        }

        @NotNull
        @Contract(pure=true)
        public ListComprehension returning(Expression ... var1);

        @NotNull
        @Contract(pure=true)
        public ListComprehension returning();
    }

    public static interface OngoingDefinitionWithList
    extends OngoingDefinitionWithoutReturn {
        @NotNull
        @CheckReturnValue
        public OngoingDefinitionWithoutReturn where(Condition var1);
    }

    public static interface OngoingDefinitionWithVariable {
        @NotNull
        @CheckReturnValue
        public OngoingDefinitionWithList in(Expression var1);
    }
}

