/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Arguments;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Foreach;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ProcedureCallImpl;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.internal.LoadCSV;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.YieldItems;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="2021.3.0")
public final class Clauses {
    @NotNull
    public static Clause match(boolean optional, List<PatternElement> patternElements, @Nullable Expression optionalWhere, @Nullable List<Hint> optionalHints) {
        return new Match(optional, new Pattern(patternElements), optionalWhere == null ? null : new Where(optionalWhere.asCondition()), optionalHints);
    }

    @NotNull
    public static Clause delete(boolean detach, List<Expression> expressions) {
        return new Delete(new ExpressionList(expressions), detach);
    }

    @NotNull
    public static Return returning(boolean distinct, List<Expression> expressions, @Nullable List<SortItem> optionalSortItems, @Nullable Expression optionalSkip, @Nullable Expression optionalLimit) {
        DefaultStatementBuilder.OrderBuilder orderBuilder = new DefaultStatementBuilder.OrderBuilder();
        orderBuilder.orderBy(optionalSortItems);
        orderBuilder.skip(optionalSkip);
        orderBuilder.limit(optionalLimit);
        return Return.create(false, distinct, expressions, orderBuilder);
    }

    @NotNull
    public static Clause create(List<PatternElement> patternElements) {
        return new Create(new Pattern(patternElements));
    }

    @NotNull
    public static Clause merge(List<PatternElement> patternElements, @Nullable List<MergeAction> mergeActions) {
        return new Merge(new Pattern(patternElements), mergeActions == null ? Collections.emptyList() : mergeActions);
    }

    public static Clause with(Return returnClause, @Nullable Expression optionalWhere) {
        return new With(returnClause, optionalWhere == null ? null : new Where(optionalWhere.asCondition()));
    }

    public static Clause remove(List<Expression> expressions) {
        return new Remove(new ExpressionList(expressions));
    }

    public static Clause set(List<Expression> expressions) {
        return new Set(new ExpressionList(expressions));
    }

    public static Clause unwind(Expression expression, SymbolicName name) {
        return new Unwind(expression, name.getValue());
    }

    public static Clause loadCSV(boolean withHeaders, StringLiteral uri, SymbolicName alias, @Nullable String fieldTerminator) {
        return new LoadCSV(URI.create(((CharSequence)uri.getContent()).toString()), withHeaders, alias.getValue()).withFieldTerminator(fieldTerminator);
    }

    public static Clause callClause(List<String> namespace, String name, @Nullable List<Expression> arguments, @Nullable List<Expression> resultItems, @Nullable Expression optionalWhere) {
        return ProcedureCallImpl.create(ProcedureName.from(namespace, name), new Arguments(arguments == null ? new Expression[]{} : arguments.toArray(new Expression[0])), resultItems == null ? null : YieldItems.yieldAllOf(resultItems.toArray(new Expression[0])), optionalWhere == null ? null : new Where(optionalWhere.asCondition()));
    }

    public static Clause callClause(Statement statement) {
        return Subquery.call(statement, true, new IdentifiableElement[0]);
    }

    public static Clause forEach(SymbolicName v, Expression list, List<Clause> updatingClauses) {
        Assertions.isTrue(updatingClauses.stream().allMatch(UpdatingClause.class::isInstance), "Only updating clauses SET, REMOVE, CREATE, MERGE, DELETE, and FOREACH are allowed as clauses applied inside FOREACH.");
        return new Foreach(v, list, updatingClauses.stream().map(UpdatingClause.class::cast).collect(Collectors.toList()));
    }

    private Clauses() {
    }
}

