/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Optional;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class SortItem
implements Visitable {
    private final Expression expression;
    private final Direction direction;

    static SortItem create(Expression expression, Direction direction) {
        Assertions.notNull(expression, "Expression to sort must not be null.");
        return new SortItem(expression, Optional.ofNullable(direction).orElse(Direction.UNDEFINED));
    }

    private SortItem(Expression expression, Direction direction) {
        this.expression = expression;
        this.direction = direction;
    }

    @NotNull
    @Contract(pure=true)
    public SortItem ascending() {
        return new SortItem(this.expression, Direction.ASC);
    }

    @NotNull
    @Contract(pure=true)
    public SortItem descending() {
        return new SortItem(this.expression, Direction.DESC);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Expressions.nameOrExpression(this.expression).accept(visitor);
        if (this.direction != Direction.UNDEFINED) {
            this.direction.accept(visitor);
        }
        visitor.leave(this);
    }

    @API(status=API.Status.STABLE)
    public static enum Direction implements Visitable
    {
        UNDEFINED(""),
        ASC("ASC"),
        DESC("DESC");

        private final String symbol;

        private Direction(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

