/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.SymbolicName;

@API(status=API.Status.INTERNAL, since="1.0")
final class Expressions {
    static <T extends Expression> Expression nameOrExpression(T expression) {
        if (expression instanceof Named) {
            return ((Named)((Object)expression)).getSymbolicName().map(Expression.class::cast).orElse(expression);
        }
        return expression;
    }

    static Expression[] createSymbolicNames(String[] variables) {
        return (Expression[])Arrays.stream(variables).map(SymbolicName::of).toArray(Expression[]::new);
    }

    static Expression[] createSymbolicNames(Named[] variables) {
        return (Expression[])Arrays.stream(variables).map(Named::getRequiredSymbolicName).toArray(Expression[]::new);
    }

    static Expression[] createSymbolicNames(IdentifiableElement[] variables) {
        return (Expression[])Arrays.stream(variables).map(IdentifiableElement::asExpression).toArray(Expression[]::new);
    }

    static String format(Expression expression) {
        if (expression instanceof Named) {
            return ((Named)((Object)expression)).getRequiredSymbolicName().getValue();
        }
        if (expression instanceof AliasedExpression) {
            return ((AliasedExpression)expression).getAlias();
        }
        if (expression instanceof SymbolicName) {
            return ((SymbolicName)expression).getValue();
        }
        if (expression instanceof Property) {
            StringBuilder ref = new StringBuilder();
            expression.accept(segment -> {
                if (segment instanceof SymbolicName) {
                    if (ref.length() > 0) {
                        ref.append(".");
                    }
                    ref.append(((SymbolicName)segment).getValue());
                }
            });
            return ref.toString();
        }
        throw new IllegalArgumentException("Cannot format expression " + expression.toString());
    }

    private Expressions() {
    }
}

