/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Neo4jVersion;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SubqueryExpression;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.STABLE, since="2023.0.0")
@Neo4jVersion(minimum="5.0")
public final class CountExpression
implements SubqueryExpression,
ExposesWhere<Expression> {
    private final With optionalWith;
    private final Visitable patternOrUnion;
    private final Where optionalWhere;

    CountExpression(@Nullable With optionalWith, Visitable patternOrUnion, @Nullable Where optionalWhere) {
        if (patternOrUnion instanceof Statement.UnionQuery && optionalWhere != null) {
            throw new IllegalArgumentException("Cannot use a UNION with a WHERE clause inside a COUNT {} expression");
        }
        this.optionalWith = optionalWith;
        if (optionalWith != null && patternOrUnion instanceof Pattern) {
            Pattern pattern = (Pattern)patternOrUnion;
            this.patternOrUnion = new Match(false, pattern, optionalWhere, null);
            this.optionalWhere = null;
        } else {
            this.patternOrUnion = patternOrUnion;
            this.optionalWhere = optionalWhere;
        }
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public CountExpression where(Condition condition) {
        Visitable visitable;
        Visitable visitable2 = this.patternOrUnion;
        if (visitable2 instanceof Match) {
            Match match = (Match)visitable2;
            visitable = match.pattern;
        } else {
            visitable = this.patternOrUnion;
        }
        Visitable exisitingPatternOrUnion = visitable;
        return new CountExpression(this.optionalWith, exisitingPatternOrUnion, new Where(condition));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        if (this.optionalWith != null) {
            this.optionalWith.accept(visitor);
        }
        this.patternOrUnion.accept(visitor);
        if (this.optionalWhere != null) {
            this.optionalWhere.accept(visitor);
        }
        visitor.leave(this);
    }
}

