/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractStatement;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.Use;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@API(status=API.Status.INTERNAL, since="2020.1.2")
class DecoratedQuery
extends AbstractStatement
implements Statement.UseStatement {
    private final Visitable decoration;
    private final Statement target;

    static DecoratedQuery explain(Statement target) {
        return DecoratedQuery.decorate(target, Decoration.EXPLAIN);
    }

    static DecoratedQuery profile(Statement target) {
        return DecoratedQuery.decorate(target, Decoration.PROFILE);
    }

    private static DecoratedQuery decorate(Statement target, Decoration decoration) {
        if (target instanceof DecoratedQuery) {
            DecoratedQuery decoratedQuery = (DecoratedQuery)target;
            if (!(decoratedQuery.decoration instanceof Use)) {
                throw new IllegalArgumentException("Cannot explain an already explained or profiled query.");
            }
        }
        if (target instanceof ResultStatement && Decoration.PROFILE.equals(decoration)) {
            return new DecoratedQueryWithResult(target);
        }
        return new DecoratedQuery(target, decoration);
    }

    static DecoratedQuery decorate(Statement target, Use use) {
        if (target instanceof DecoratedQuery) {
            Object message;
            DecoratedQuery decoratedQuery = (DecoratedQuery)target;
            Visitable visitable = decoratedQuery.decoration;
            if (visitable instanceof Decoration) {
                Decoration decoration = (Decoration)visitable;
                message = decoration.name() + (decoration.name().endsWith("E") ? "'" : "'e") + "d statements are not supported inside USE clauses";
            } else {
                message = "Nested USE clauses are not supported";
            }
            throw new IllegalArgumentException((String)message);
        }
        return new DecoratedQuery(target, use);
    }

    private DecoratedQuery(Statement target, Visitable decoration) {
        this.decoration = decoration;
        this.target = target;
    }

    @Override
    public void accept(Visitor visitor) {
        this.decoration.accept(visitor);
        this.target.accept(visitor);
    }

    @Override
    public boolean doesReturnOrYield() {
        if (this.decoration instanceof Use) {
            return this.target.doesReturnOrYield();
        }
        return super.doesReturnOrYield();
    }

    private static enum Decoration implements Visitable
    {
        EXPLAIN,
        PROFILE;

    }

    static final class DecoratedQueryWithResult
    extends DecoratedQuery
    implements ResultStatement {
        private DecoratedQueryWithResult(Statement target) {
            super(target, Decoration.PROFILE);
        }
    }
}

