/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.CountExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.With;

@API(status=API.Status.STABLE, since="1.0")
public final class Expressions {
    @NotNull
    public static CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
        return new CountExpression(null, Pattern.of(requiredPattern, patternElement), null);
    }

    @NotNull
    public static CountExpression count(Statement.UnionQuery union) {
        return new CountExpression(null, union, null);
    }

    public static SubqueryExpressionBuilder with(String ... identifiableElements) {
        return Expressions.with((IdentifiableElement[])Arrays.stream(identifiableElements).map(SymbolicName::of).toArray(SymbolicName[]::new));
    }

    public static SubqueryExpressionBuilder with(IdentifiableElement ... identifiableElements) {
        ExpressionList returnItems = new ExpressionList(Arrays.stream(identifiableElements).map(IdentifiableElement::asExpression).toList());
        final With with = new With(false, returnItems, null, null, null, null);
        return new SubqueryExpressionBuilder(){

            @Override
            @NotNull
            public CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
                return new CountExpression(with, Pattern.of(requiredPattern, patternElement), null);
            }

            @Override
            @NotNull
            public CountExpression count(Statement.UnionQuery union) {
                return new CountExpression(with, union, null);
            }
        };
    }

    static <T extends Expression> Expression nameOrExpression(T expression) {
        if (expression instanceof Named) {
            return ((Named)((Object)expression)).getSymbolicName().map(Expression.class::cast).orElse(expression);
        }
        return expression;
    }

    static SymbolicName[] createSymbolicNames(String[] variables) {
        return (SymbolicName[])Arrays.stream(variables).map(SymbolicName::of).toArray(SymbolicName[]::new);
    }

    static SymbolicName[] createSymbolicNames(Named[] variables) {
        return (SymbolicName[])Arrays.stream(variables).map(Named::getRequiredSymbolicName).toArray(SymbolicName[]::new);
    }

    static String format(Expression expression) {
        if (expression instanceof Named) {
            return ((Named)((Object)expression)).getRequiredSymbolicName().getValue();
        }
        if (expression instanceof AliasedExpression) {
            return ((AliasedExpression)expression).getAlias();
        }
        if (expression instanceof SymbolicName) {
            return ((SymbolicName)expression).getValue();
        }
        if (expression instanceof Property) {
            StringBuilder ref = new StringBuilder();
            expression.accept(segment -> {
                if (segment instanceof SymbolicName) {
                    if (ref.length() > 0) {
                        ref.append(".");
                    }
                    ref.append(((SymbolicName)segment).getValue());
                }
            });
            return ref.toString();
        }
        throw new IllegalArgumentException("Cannot format expression " + expression.toString());
    }

    private Expressions() {
    }

    public static interface SubqueryExpressionBuilder {
        @NotNull
        public CountExpression count(PatternElement var1, PatternElement ... var2);

        @NotNull
        public CountExpression count(Statement.UnionQuery var1);
    }
}

