/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Aliased;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.CountExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Foreach;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.YieldItems;

@API(status=API.Status.INTERNAL, since="2021.3.2")
public final class ScopingStrategy {
    private final Deque<Set<IdentifiableElement>> dequeOfVisitedNamed = new ArrayDeque<Set<IdentifiableElement>>(new HashSet());
    private final Deque<Set<IdentifiableElement>> implicitScope = new ArrayDeque<Set<IdentifiableElement>>(new HashSet());
    private Set<IdentifiableElement> afterStatement = Collections.emptySet();
    private Visitable previous;
    private boolean inOrder = false;
    private boolean inProperty = false;

    public static ScopingStrategy create() {
        return new ScopingStrategy();
    }

    private ScopingStrategy() {
        this.dequeOfVisitedNamed.push(new HashSet());
    }

    public void doEnter(Visitable visitable) {
        if (visitable instanceof Order) {
            this.inOrder = true;
        }
        if (visitable instanceof Property) {
            this.inProperty = true;
        }
        if (ScopingStrategy.hasLocalScope(visitable)) {
            this.dequeOfVisitedNamed.push(new HashSet(this.dequeOfVisitedNamed.isEmpty() ? Collections.emptySet() : (Collection)this.dequeOfVisitedNamed.peek()));
        }
        if (visitable instanceof CountExpression) {
            this.implicitScope.push(new HashSet(this.dequeOfVisitedNamed.isEmpty() ? Collections.emptySet() : (Collection)this.dequeOfVisitedNamed.peek()));
        }
    }

    public boolean hasVisitedBefore(Named namedItem) {
        if (!this.hasScope()) {
            return false;
        }
        Set<IdentifiableElement> scope = this.dequeOfVisitedNamed.peek();
        return this.hasVisitedInScope(scope, namedItem);
    }

    public void doLeave(Visitable visitable) {
        if (!this.hasScope()) {
            return;
        }
        if (visitable instanceof IdentifiableElement) {
            IdentifiableElement identifiableElement = (IdentifiableElement)((Object)visitable);
            if (!(this.inOrder || this.inProperty && !(visitable instanceof Property))) {
                this.dequeOfVisitedNamed.peek().add(identifiableElement);
            }
        }
        if (visitable instanceof Statement) {
            this.leaveStatement(visitable);
        } else if (ScopingStrategy.hasLocalScope(visitable)) {
            this.dequeOfVisitedNamed.pop();
        } else {
            this.clearPreviouslyVisitedNamed(visitable);
        }
        if (visitable instanceof Order) {
            this.inOrder = false;
        }
        if (visitable instanceof Property) {
            this.inProperty = false;
        }
        if (visitable instanceof CountExpression) {
            this.implicitScope.pop();
        }
        this.previous = visitable;
    }

    private void leaveStatement(Visitable visitable) {
        Set<IdentifiableElement> lastScope = this.dequeOfVisitedNamed.peek();
        this.afterStatement = !(this.previous instanceof Return) && !(this.previous instanceof YieldItems) ? lastScope.stream().filter(i -> !(i instanceof Property)).collect(Collectors.toSet()) : new HashSet<IdentifiableElement>(lastScope);
        if (visitable instanceof ProcedureCall) {
            return;
        }
        lastScope.retainAll(Optional.ofNullable(this.implicitScope.peek()).orElseGet(Set::of));
    }

    private boolean hasScope() {
        return !this.dequeOfVisitedNamed.isEmpty();
    }

    private boolean hasVisitedInScope(Collection<IdentifiableElement> visited, Named needle) {
        Predicate<IdentifiableElement> hasAName = Named.class::isInstance;
        hasAName = hasAName.or(AliasedExpression.class::isInstance);
        return visited.contains(needle) || needle.getSymbolicName().isPresent() && visited.stream().filter(hasAName).anyMatch(i -> {
            if (i instanceof Named) {
                Named named = (Named)i;
                return named.getSymbolicName().equals(needle.getSymbolicName());
            }
            if (i instanceof Aliased) {
                Aliased aliased = (Aliased)((Object)i);
                return aliased.getAlias().equals(needle.getRequiredSymbolicName().getValue());
            }
            return false;
        });
    }

    private static boolean hasLocalScope(Visitable visitable) {
        return visitable instanceof PatternComprehension || visitable instanceof Subquery || visitable instanceof Foreach;
    }

    private void clearPreviouslyVisitedNamed(Visitable visitable) {
        if (visitable instanceof With) {
            With with = (With)visitable;
            this.clearPreviouslyVisitedAfterWith(with);
        } else if (visitable instanceof Return || visitable instanceof YieldItems) {
            this.clearPreviouslyVisitedAfterReturnish(visitable);
        }
    }

    private void clearPreviouslyVisitedAfterWith(With with) {
        HashSet retain = new HashSet();
        Set<IdentifiableElement> visitedNamed = this.dequeOfVisitedNamed.peek();
        with.accept(segment -> {
            if (segment instanceof SymbolicName) {
                SymbolicName symbolicName = (SymbolicName)segment;
                visitedNamed.stream().filter(element -> {
                    if (element instanceof Named) {
                        Named named = (Named)element;
                        return named.getRequiredSymbolicName().equals(segment);
                    }
                    if (element instanceof Aliased) {
                        Aliased aliased = (Aliased)((Object)element);
                        return aliased.getAlias().equals(symbolicName.getValue());
                    }
                    return false;
                }).forEach(retain::add);
            }
        });
        retain.addAll(Optional.ofNullable(this.implicitScope.peek()).orElseGet(Set::of));
        if (visitedNamed != null) {
            visitedNamed.retainAll(retain);
        }
    }

    private void clearPreviouslyVisitedAfterReturnish(Visitable returnish) {
        final HashSet retain = new HashSet();
        Set<IdentifiableElement> visitedNamed = this.dequeOfVisitedNamed.peek();
        returnish.accept(new Visitor(){
            boolean in = false;
            int level = 0;

            @Override
            public void enter(Visitable segment) {
                if (!this.in && segment instanceof TypedSubtree) {
                    this.in = true;
                    return;
                }
                if (this.in) {
                    ++this.level;
                }
                if (this.level == 1 && segment instanceof IdentifiableElement) {
                    IdentifiableElement identifiableElement = (IdentifiableElement)((Object)segment);
                    retain.add(identifiableElement);
                }
            }

            @Override
            public void leave(Visitable segment) {
                if (this.in) {
                    --this.level;
                    if (segment instanceof TypedSubtree) {
                        this.in = false;
                    }
                }
            }
        });
        retain.addAll(Optional.ofNullable(this.implicitScope.peek()).orElseGet(Set::of));
        if (visitedNamed != null) {
            visitedNamed.retainAll(retain);
        }
    }

    public Collection<Expression> getIdentifiables() {
        if (!this.hasScope()) {
            return Collections.emptySet();
        }
        Predicate<IdentifiableElement> allNamedElementsHaveResolvedNames = e -> {
            Named named;
            return !(e instanceof Named) || (named = (Named)e).getSymbolicName().isPresent();
        };
        Set<IdentifiableElement> items = Optional.ofNullable(this.dequeOfVisitedNamed.peek()).filter(scope -> !scope.isEmpty()).orElse(this.afterStatement);
        return items.stream().filter(allNamedElementsHaveResolvedNames).map(IdentifiableElement::asExpression).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }
}

