/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.cypherdsl.core.ConflictingParametersException;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.ConstantParameterHolder;
import org.neo4j.cypherdsl.core.internal.ReflectiveVisitor;

@RegisterForReflection
final class ParameterCollectingVisitor
extends ReflectiveVisitor {
    private final StatementContext statementContext;
    private final boolean renderConstantsAsParameters;
    private final Set<String> names = new TreeSet<String>();
    private final Map<String, Object> values = new TreeMap<String, Object>();
    private final Map<String, Set<Object>> erroneousParameters = new TreeMap<String, Set<Object>>();

    ParameterCollectingVisitor(StatementContext statementContext, boolean renderConstantsAsParameters) {
        this.statementContext = statementContext;
        this.renderConstantsAsParameters = renderConstantsAsParameters;
    }

    @Override
    protected boolean preEnter(Visitable visitable) {
        return true;
    }

    @Override
    protected void postLeave(Visitable visitable) {
    }

    void enter(Parameter<?> parameter) {
        Object oldValue;
        String parameterName = this.statementContext.getParameterName(parameter);
        Object newValue = parameter.getValue();
        if (newValue instanceof ConstantParameterHolder) {
            ConstantParameterHolder constantParameterHolder = (ConstantParameterHolder)newValue;
            if (!this.renderConstantsAsParameters) {
                return;
            }
            newValue = constantParameterHolder.getValue();
        }
        boolean knownParameterName = !this.names.add(parameterName);
        Object object = oldValue = knownParameterName && this.values.containsKey(parameterName) ? this.values.get(parameterName) : Parameter.NO_VALUE;
        if (parameter.hasValue()) {
            this.values.put(parameterName, newValue);
        }
        if (knownParameterName && !Objects.equals(oldValue, newValue)) {
            Set conflictingObjects = this.erroneousParameters.computeIfAbsent(parameterName, s -> {
                HashSet<Object> list = new HashSet<Object>();
                list.add(oldValue);
                return list;
            });
            conflictingObjects.add(newValue);
        }
    }

    ParameterInformation getResult() {
        if (!this.erroneousParameters.isEmpty()) {
            throw new ConflictingParametersException(this.erroneousParameters);
        }
        return new ParameterInformation(this.names, this.values);
    }

    static class ParameterInformation {
        final Set<String> names;
        final Map<String, Object> values;

        ParameterInformation(Set<String> names, Map<String, Object> values) {
            this.names = Collections.unmodifiableSet(names);
            this.values = Collections.unmodifiableMap(values);
        }
    }
}

