/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.function.BiConsumer;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SubqueryExpression;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.Use;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.ProvidesAffixes;
import org.neo4j.cypherdsl.core.internal.ConstantParameterHolder;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;

@RegisterForReflection
class PrettyPrintingVisitor
extends DefaultVisitor {
    private final BiConsumer<StringBuilder, Integer> indentionProvider;
    private int indentationLevel;
    private boolean passedFirstReadingOrUpdatingClause;

    PrettyPrintingVisitor(StatementContext statementContext, Configuration configuration) {
        this(statementContext, false, configuration);
    }

    PrettyPrintingVisitor(StatementContext statementContext, boolean renderConstantsAsParameters, Configuration configuration) {
        super(statementContext, renderConstantsAsParameters, configuration);
        Configuration.IndentStyle indentStyle = configuration.getIndentStyle();
        int indentSize = configuration.getIndentSize();
        this.indentionProvider = indentStyle == Configuration.IndentStyle.TAB ? (builder, width) -> builder.append("\t".repeat(Math.max(0, width))) : (builder, width) -> builder.append(" ".repeat(Math.max(0, width * indentSize)));
    }

    private void indent(int width) {
        this.indentionProvider.accept(this.builder, width);
    }

    @Override
    void enter(Where where) {
        if (this.currentVisitedElements.stream().noneMatch(Return.class::isInstance)) {
            this.builder.append("\n");
            this.indent(this.indentationLevel);
            this.builder.append("WHERE ");
        } else {
            super.enter(where);
        }
    }

    @Override
    void enter(Return returning) {
        this.trimNewline();
        this.indent(this.indentationLevel);
        super.enter(returning);
    }

    @Override
    void enter(Unwind unwind) {
        this.trimNewline();
        this.indent(this.indentationLevel);
        super.enter(unwind);
    }

    @Override
    void enter(With with) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(with);
    }

    @Override
    void enter(Set set) {
        if (this.currentVisitedElements.stream().noneMatch(MergeAction.class::isInstance)) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(set);
    }

    @Override
    void enter(Match match) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(match);
    }

    @Override
    void enter(Create create) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(create);
    }

    @Override
    void enter(PropertyLookup propertyLookup) {
        if (this.currentVisitedElements.stream().skip(1L).limit(1L).anyMatch(MapExpression.class::isInstance)) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(propertyLookup);
    }

    @Override
    void enter(KeyValueMapEntry map) {
        if (this.indentationLevel > 0) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(map);
    }

    @Override
    void enter(Condition condition) {
        if (condition instanceof ProvidesAffixes) {
            ++this.indentationLevel;
        }
        super.enter(condition);
    }

    @Override
    void leave(Condition condition) {
        if (condition instanceof ProvidesAffixes) {
            --this.indentationLevel;
        }
        super.leave(condition);
    }

    @Override
    void enter(Operator operator) {
        Operator.Type type = operator.getType();
        if (type == Operator.Type.LABEL) {
            return;
        }
        if (type != Operator.Type.PREFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
        if (operator == Operator.OR || operator == Operator.AND || operator == Operator.XOR) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.builder.append(operator.getRepresentation());
        if (type != Operator.Type.POSTFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
    }

    @Override
    void enter(MapExpression map) {
        ++this.indentationLevel;
        int cnt = 0;
        for (int i = this.builder.length() - 1; i >= 0 && Character.isWhitespace(this.builder.charAt(i)); --i) {
            ++cnt;
        }
        this.builder.setLength(this.builder.length() - cnt);
        this.builder.append(" ");
        super.enter(map);
    }

    @Override
    void leave(MapExpression map) {
        --this.indentationLevel;
        this.trimNewline();
        this.indent(this.indentationLevel);
        super.leave(map);
    }

    @Override
    void enter(MergeAction onCreateOrMatchEvent) {
        this.trimNewline();
        this.indent(1);
        super.enter(onCreateOrMatchEvent);
    }

    @Override
    void enter(Merge merge) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(merge);
    }

    @Override
    void enter(SubqueryExpression subquery) {
        super.enter(subquery);
        ++this.indentationLevel;
    }

    @Override
    void leave(SubqueryExpression subquery) {
        --this.indentationLevel;
        this.trimNewline();
        this.indent(this.indentationLevel);
        this.builder.append("}");
    }

    @Override
    void enter(Subquery subquery) {
        this.passedFirstReadingOrUpdatingClause = true;
        this.trimNewline();
        this.indent(this.indentationLevel);
        ++this.indentationLevel;
        super.enter(subquery);
    }

    @Override
    void enter(Use use) {
        this.trimNewline();
        this.indent(this.indentationLevel);
        super.enter(use);
    }

    @Override
    void leave(Subquery subquery) {
        --this.indentationLevel;
        this.trimNewline();
        this.indent(this.indentationLevel);
        super.leave(subquery);
    }

    private void trimNewline() {
        for (int i = this.builder.length() - 1; i >= 0 && this.builder.charAt(i) == ' '; --i) {
            this.builder.deleteCharAt(i);
        }
        this.builder.append("\n");
    }

    @Override
    void enter(Parameter<?> parameter) {
        Object value = parameter.getValue();
        if (value instanceof ConstantParameterHolder) {
            ConstantParameterHolder constantParameterHolder = (ConstantParameterHolder)value;
            this.builder.append(constantParameterHolder.asString());
        } else {
            this.renderParameter(parameter);
        }
    }
}

