/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.BooleanFunctionCondition;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.ExistentialSubquery;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.ListPredicate;
import org.neo4j.cypherdsl.core.OngoingListBasedPredicateFunction;
import org.neo4j.cypherdsl.core.OngoingListBasedPredicateFunctionWithList;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.utils.Assertions;

final class Predicates {
    @NotNull
    @Contract(pure=true)
    static Condition exists(Property property) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, property));
    }

    @NotNull
    @Contract(pure=true)
    static Condition exists(RelationshipPattern pattern) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, pattern));
    }

    static Condition exists(Statement statement, IdentifiableElement ... imports) {
        return ExistentialSubquery.exists(statement, imports);
    }

    static Condition exists(PatternElement pattern) {
        return ExistentialSubquery.exists(List.of(pattern), null);
    }

    static Condition exists(List<PatternElement> pattern) {
        return ExistentialSubquery.exists(pattern, null);
    }

    static Condition exists(List<PatternElement> pattern, @Nullable Where where) {
        return ExistentialSubquery.exists(pattern, where);
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction all(String variable) {
        return Predicates.all(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction all(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.ALL, variable);
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction any(String variable) {
        return Predicates.any(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction any(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.ANY, variable);
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction none(String variable) {
        return Predicates.none(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction none(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.NONE, variable);
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction single(String variable) {
        return Predicates.single(SymbolicName.of(variable));
    }

    @NotNull
    @Contract(pure=true)
    static OngoingListBasedPredicateFunction single(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.SINGLE, variable);
    }

    static Condition isEmpty(Expression e) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.IS_EMPTY, e));
    }

    private Predicates() {
    }

    private static class Builder
    implements OngoingListBasedPredicateFunction,
    OngoingListBasedPredicateFunctionWithList {
        private final BuiltInFunctions.Predicates predicate;
        private final SymbolicName name;
        private Expression listExpression;

        Builder(BuiltInFunctions.Predicates predicate, SymbolicName name) {
            Assertions.notNull(predicate, "The predicate is required");
            Assertions.notNull(name, "The name is required");
            this.predicate = predicate;
            this.name = name;
        }

        @Override
        @NotNull
        public OngoingListBasedPredicateFunctionWithList in(Expression list) {
            Assertions.notNull(list, "The list expression is required");
            this.listExpression = list;
            return this;
        }

        @Override
        @NotNull
        public Condition where(Condition condition) {
            Assertions.notNull(condition, "The condition is required");
            return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)this.predicate, new ListPredicate(this.name, this.listExpression, new Where(condition))));
        }
    }
}

