/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractStatement;
import org.neo4j.cypherdsl.core.MultiPartElement;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.SinglePartQuery;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.INTERNAL, since="1.0")
class MultiPartQuery
extends AbstractStatement
implements Statement.SingleQuery {
    private final List<MultiPartElement> parts;
    private final SinglePartQuery remainder;

    private MultiPartQuery(List<MultiPartElement> parts, SinglePartQuery remainder) {
        this.parts = new ArrayList<MultiPartElement>(parts);
        this.remainder = remainder;
    }

    static MultiPartQuery create(List<MultiPartElement> parts, SinglePartQuery remainder) {
        if (remainder instanceof ResultStatement) {
            return new MultiPartQueryWithResult(parts, remainder);
        }
        return new MultiPartQuery(parts, remainder);
    }

    List<MultiPartElement> getParts() {
        return this.parts;
    }

    Statement stripFirst() {
        return new MultiPartQuery(this.parts.size() > 1 ? this.parts.subList(1, this.parts.size()) : List.of(), this.remainder);
    }

    @Override
    public void accept(Visitor visitor) {
        this.parts.forEach(p -> p.accept(visitor));
        this.remainder.accept(visitor);
    }

    static final class MultiPartQueryWithResult
    extends MultiPartQuery
    implements ResultStatement {
        private MultiPartQueryWithResult(List<MultiPartElement> parts, SinglePartQuery remainder) {
            super(parts, remainder);
        }
    }
}

