/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.ClausesBasedStatement;
import org.neo4j.cypherdsl.core.DecoratedQuery;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.StatementCatalog;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.UnionQueryImpl;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.LoadCSV;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.UsingPeriodicCommit;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public interface Statement
extends Visitable {
    public static StatementBuilder builder() {
        return new DefaultStatementBuilder(new Visitable[0]);
    }

    public static Statement of(List<Clause> clauses) {
        Assertions.notNull(clauses, "Clauses must not be null.");
        return new ClausesBasedStatement(clauses, null);
    }

    @API(status=API.Status.STABLE, since="2021.3.0")
    public static Statement usingPeriodic(Integer batchSize, List<Clause> clauses) {
        Assertions.notNull(clauses, "Clauses must not be null.");
        Assertions.isTrue(!clauses.isEmpty(), "Clauses must not be empty.");
        Assertions.isInstanceOf(LoadCSV.class, clauses.get(0), "First clause must be a LOAD CSV clause.");
        return new ClausesBasedStatement(clauses, new UsingPeriodicCommit(batchSize));
    }

    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String ... namespaceAndProcedure) {
        return new DefaultStatementBuilder.StandaloneCallBuilder(ProcedureName.from(namespaceAndProcedure));
    }

    public StatementCatalog getCatalog();

    public String getCypher();

    @API(status=API.Status.INTERNAL, since="2021.0.0")
    public StatementContext getContext();

    public boolean isRenderConstantsAsParameters();

    public void setRenderConstantsAsParameters(boolean var1);

    default public boolean doesReturnOrYield() {
        return this instanceof ResultStatement || this instanceof UnionQueryImpl;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UseStatement
    extends Statement {
        default public Statement explain() {
            return DecoratedQuery.explain(this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UnionQuery
    extends RegularQuery {
    }

    public static interface SingleQuery
    extends RegularQuery {
    }

    public static interface RegularQuery
    extends Statement {
    }
}

