/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Parameter;

@API(status=API.Status.STABLE, since="2021.0.0")
public final class ConflictingParametersException
extends RuntimeException {
    private static final long serialVersionUID = -45456411835790492L;
    private final transient Map<String, Set<Object>> erroneousParameters;

    ConflictingParametersException(Map<String, Set<Object>> erroneousParameters) {
        super(ConflictingParametersException.createMessage(erroneousParameters));
        this.erroneousParameters = new HashMap<String, Set<Object>>(erroneousParameters.size());
        erroneousParameters.forEach((k, v) -> this.erroneousParameters.put((String)k, new HashSet(v)));
    }

    private static String createMessage(Map<String, Set<Object>> errors) {
        String prefix;
        StringBuilder sb = new StringBuilder();
        if (errors.size() > 1) {
            sb.append("There are conflicting parameter values:");
            prefix = "\n\t";
        } else {
            prefix = "";
        }
        errors.forEach((param, values) -> {
            sb.append(prefix);
            sb.append("Parameter '").append((String)param).append("' is defined multiple times with different bound values: ");
            sb.append(values.stream().map(o -> o != Parameter.NO_VALUE ? Objects.toString(o) : "(UNDEFINED VALUE)").collect(Collectors.joining(" != ")));
        });
        return sb.toString();
    }

    public Map<String, Set<Object>> getErroneousParameters() {
        return Collections.unmodifiableMap(this.erroneousParameters);
    }
}

