/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.renderer.Dialect;

@API(status=API.Status.STABLE, since="2021.0.1")
public final class Configuration {
    private static final Configuration DEFAULT_CONFIG = Configuration.newConfig().build();
    private static final Configuration PRETTY_PRINTING = Configuration.newConfig().withPrettyPrint(true).alwaysEscapeNames(false).build();
    private final boolean prettyPrint;
    private final IndentStyle indentStyle;
    private final int indentSize;
    private final boolean alwaysEscapeNames;
    private final Set<GeneratedNames> generatedNames;
    private final Dialect dialect;
    private final boolean enforceSchema;
    private final Map<String, List<RelationshipDefinition>> relationshipDefinitions;
    private final boolean disableDynamicLabels;

    private Configuration(Builder builder) {
        this.prettyPrint = builder.prettyPrint;
        this.alwaysEscapeNames = builder.alwaysEscapeNames;
        this.indentStyle = builder.indentStyle;
        this.indentSize = builder.indentSize;
        this.dialect = builder.dialect != null ? builder.dialect : Dialect.NEO4J_5_DEFAULT_CYPHER;
        this.generatedNames = builder.generatedNames;
        this.enforceSchema = builder.enforceSchema;
        this.disableDynamicLabels = builder.disableDynamicLabels;
        HashMap mutableRelationshipDefinitions = new HashMap();
        builder.relationshipDefinitions.forEach((k, v) -> mutableRelationshipDefinitions.put(k, List.copyOf(v)));
        this.relationshipDefinitions = Map.copyOf(mutableRelationshipDefinitions);
    }

    public static RelationshipDefinition relationshipDefinition(String definition) {
        return RelationshipDefinition.of(definition);
    }

    public static Configuration defaultConfig() {
        return DEFAULT_CONFIG;
    }

    public static Configuration prettyPrinting() {
        return PRETTY_PRINTING;
    }

    public static Builder newConfig() {
        return Builder.newConfig();
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public IndentStyle getIndentStyle() {
        return this.indentStyle;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public boolean isAlwaysEscapeNames() {
        return this.alwaysEscapeNames;
    }

    public Set<GeneratedNames> getGeneratedNames() {
        return this.generatedNames;
    }

    public boolean isUseGeneratedNames() {
        return !this.generatedNames.isEmpty();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    @API(status=API.Status.EXPERIMENTAL, since="2023.7.0")
    public boolean isEnforceSchema() {
        return this.enforceSchema;
    }

    @API(status=API.Status.EXPERIMENTAL, since="2023.7.0")
    public Map<String, List<RelationshipDefinition>> getRelationshipDefinitions() {
        return this.relationshipDefinitions;
    }

    public boolean isDisableDynamicLabels() {
        return this.disableDynamicLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.prettyPrint == that.prettyPrint && this.indentSize == that.indentSize && this.indentStyle == that.indentStyle && this.alwaysEscapeNames == that.alwaysEscapeNames && this.dialect == that.dialect && this.generatedNames.equals(that.generatedNames) && this.enforceSchema == that.enforceSchema && this.relationshipDefinitions.equals(that.relationshipDefinitions) && this.disableDynamicLabels == that.disableDynamicLabels;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prettyPrint, this.indentStyle, this.indentSize, this.alwaysEscapeNames, this.dialect, this.generatedNames, this.enforceSchema, this.relationshipDefinitions, this.disableDynamicLabels});
    }

    public String toString() {
        return "Configuration{prettyPrint=" + this.prettyPrint + ", indentStyle=" + String.valueOf((Object)this.indentStyle) + ", indentSize=" + this.indentSize + "}";
    }

    public static final class Builder {
        private boolean prettyPrint = false;
        private IndentStyle indentStyle = IndentStyle.SPACE;
        private int indentSize = 2;
        private boolean alwaysEscapeNames = true;
        private Dialect dialect = Dialect.NEO4J_5_DEFAULT_CYPHER;
        private Set<GeneratedNames> generatedNames = EnumSet.noneOf(GeneratedNames.class);
        private boolean enforceSchema = false;
        private boolean disableDynamicLabels = false;
        private Map<String, List<RelationshipDefinition>> relationshipDefinitions = new HashMap<String, List<RelationshipDefinition>>();

        private Builder() {
        }

        static Builder newConfig() {
            return new Builder();
        }

        public Builder withPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            if (this.prettyPrint) {
                return this.alwaysEscapeNames(false);
            }
            return this;
        }

        public Builder withIndentStyle(IndentStyle indentStyle) {
            if (indentStyle == null) {
                throw new IllegalArgumentException("Indent style is required.");
            }
            this.indentStyle = indentStyle;
            return this;
        }

        public Builder withIndentSize(int indentSize) {
            this.indentSize = indentSize;
            return this;
        }

        public Builder alwaysEscapeNames(boolean alwaysEscapeNames) {
            this.alwaysEscapeNames = alwaysEscapeNames;
            return this;
        }

        public Builder withGeneratedNames(boolean useGeneratedNames) {
            this.generatedNames = useGeneratedNames ? EnumSet.allOf(GeneratedNames.class) : EnumSet.noneOf(GeneratedNames.class);
            return this;
        }

        public Builder withGeneratedNames(Set<GeneratedNames> useGeneratedNames) {
            this.generatedNames = Objects.requireNonNullElseGet(useGeneratedNames, () -> EnumSet.noneOf(GeneratedNames.class));
            return this;
        }

        public Builder withDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="2023.7.0")
        public Builder withRelationshipDefinition(RelationshipDefinition relationshipDefinition) {
            if (relationshipDefinition == null) {
                return this;
            }
            List relationships = this.relationshipDefinitions.computeIfAbsent(relationshipDefinition.type, k -> new ArrayList());
            relationships.add(relationshipDefinition);
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="2023.7.0")
        public Builder withEnforceSchema(boolean enforceSchema) {
            this.enforceSchema = enforceSchema;
            return this;
        }

        public Builder disableDynamicLabels(boolean disableDynamicLabels) {
            this.disableDynamicLabels = disableDynamicLabels;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }

    public static enum IndentStyle {
        TAB,
        SPACE;

    }

    public record RelationshipDefinition(String sourceLabel, String type, String targetLabel) {
        public RelationshipDefinition {
            sourceLabel = sourceLabel.trim();
            type = type.trim();
            targetLabel = targetLabel.trim();
        }

        private static RelationshipDefinition of(String definition) {
            String[] tuple = Objects.requireNonNull(definition).replace("(", "").replace(")", "").split(",");
            if (tuple.length != 3) {
                throw new IllegalArgumentException("Invalid relationship definition " + definition);
            }
            return new RelationshipDefinition(tuple[0], tuple[1], tuple[2]);
        }

        boolean selfReferential() {
            return this.sourceLabel.equals(this.targetLabel);
        }
    }

    public static enum GeneratedNames {
        ENTITY_NAMES,
        PARAMETER_NAMES,
        ALL_ALIASES,
        INTERNAL_ALIASES_ONLY,
        REUSE_ALIASES;

    }
}

