/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.cypherdsl.core.ReturnBody;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.EnterResult;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.ast.VisitorWithResult;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;
import org.neo4j.cypherdsl.core.renderer.Dialect;
import org.neo4j.cypherdsl.core.renderer.GeneralizedRenderer;
import org.neo4j.cypherdsl.core.renderer.Renderer;

@RegisterForReflection(allDeclaredConstructors=true)
final class Neo4j523SubqueryVisitor
extends VisitorWithResult {
    private static final GeneralizedRenderer RETURN_BODY_RENDERER = Renderer.getRenderer(Configuration.newConfig().withDialect(Dialect.NEO4J_5_23).build(), GeneralizedRenderer.class);
    private final DefaultVisitor delegate;
    private With importing;

    Neo4j523SubqueryVisitor(DefaultVisitor delegate) {
        this.delegate = delegate;
    }

    @Override
    public EnterResult enterWithResult(Visitable segment) {
        if (segment instanceof Subquery) {
            Subquery subquery = (Subquery)segment;
            this.importing = subquery.importingWith();
            this.delegate.enter(subquery);
            this.delegate.builder.replace(this.delegate.builder.length() - 1, this.delegate.builder.length(), "(");
            if (this.importing != null) {
                this.importing.accept(innerSegment -> {
                    if (innerSegment instanceof ReturnBody) {
                        ReturnBody returnBody = (ReturnBody)innerSegment;
                        returnBody.accept(this.delegate);
                    }
                });
            } else if (this.delegate.hasIdentifiables()) {
                this.delegate.builder.append("*");
            }
            this.delegate.builder.append(") {");
        } else if (segment instanceof With) {
            With possibleImporting = (With)segment;
            if (!Objects.equals(this.importing, possibleImporting)) {
                this.delegate.enter(possibleImporting);
            } else {
                possibleImporting.accept(new Visitor(){
                    private final Deque<Boolean> entered = new ArrayDeque<Boolean>();

                    @Override
                    public void enter(Visitable segment) {
                        this.entered.push(Neo4j523SubqueryVisitor.this.delegate.preEnter(segment));
                    }

                    @Override
                    public void leave(Visitable segment) {
                        if (this.entered.pop().booleanValue()) {
                            TypedSubtree t;
                            Neo4j523SubqueryVisitor.this.delegate.postLeave(segment);
                            int currentLength = Neo4j523SubqueryVisitor.this.delegate.builder.length();
                            if (segment instanceof TypedSubtree && Neo4j523SubqueryVisitor.this.delegate.builder.subSequence(currentLength - (t = (TypedSubtree)segment).separator().length(), currentLength).equals(t.separator())) {
                                Neo4j523SubqueryVisitor.this.delegate.builder.setLength(currentLength - t.separator().length());
                            }
                        }
                    }
                });
                return EnterResult.SKIP_CHILDREN;
            }
        }
        return EnterResult.CONTINUE;
    }

    @Override
    public void leave(Visitable segment) {
        if (segment instanceof Subquery) {
            Subquery subquery = (Subquery)segment;
            this.delegate.leave(subquery);
        } else if (segment instanceof With) {
            With possibleImporting = (With)segment;
            if (Objects.equals(this.importing, possibleImporting)) {
                this.importing = null;
            } else {
                this.delegate.leave(possibleImporting);
            }
        }
    }
}

