/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_3.phases;

import org.neo4j.cypher.internal.frontend.v3_3.Foldable$;
import org.neo4j.cypher.internal.frontend.v3_3.Foldable$FoldableAny$;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_3.ast.FunctionInvocation;
import org.neo4j.cypher.internal.frontend.v3_3.ast.FunctionName;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Range;
import org.neo4j.cypher.internal.frontend.v3_3.ast.RelationshipPattern;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_3.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_3.ast.rewriters.replaceAliasedFunctionInvocations$;
import org.neo4j.cypher.internal.frontend.v3_3.notification.DeprecatedFunctionNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.DeprecatedRelTypeSeparatorNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.DeprecatedVarLengthBindingNotification;
import org.neo4j.cypher.internal.frontend.v3_3.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_3.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.v3_3.phases.BaseState;
import org.neo4j.cypher.internal.frontend.v3_3.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Condition;
import org.neo4j.cypher.internal.frontend.v3_3.phases.InternalNotificationLogger;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Phase$class;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Transformer;
import org.neo4j.cypher.internal.frontend.v3_3.phases.Transformer$class;
import org.neo4j.cypher.internal.frontend.v3_3.phases.VisitorPhase;
import org.neo4j.cypher.internal.frontend.v3_3.phases.VisitorPhase$class;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.runtime.ObjectRef;

public final class SyntaxDeprecationWarnings$
implements VisitorPhase<BaseContext, BaseState> {
    public static final SyntaxDeprecationWarnings$ MODULE$;

    static {
        new SyntaxDeprecationWarnings$();
    }

    @Override
    public Object process(Object from2, BaseContext context) {
        return VisitorPhase$class.process(this, from2, context);
    }

    @Override
    public Set<Condition> postConditions() {
        return VisitorPhase$class.postConditions(this);
    }

    @Override
    public Object transform(Object from2, BaseContext context) {
        return Phase$class.transform(this, from2, context);
    }

    @Override
    public String name() {
        return Phase$class.name(this);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer$class.andThen(this, other);
    }

    @Override
    public Transformer<BaseContext, BaseState, BaseState> adds(Condition condition) {
        return Transformer$class.adds(this, condition);
    }

    @Override
    public void visit(BaseState state, BaseContext context) {
        Set<InternalNotification> warnings = this.findDeprecations(state.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1)new Serializable(internalNotificationLogger){
            public static final long serialVersionUID = 0L;
            private final InternalNotificationLogger eta$0$1$1;

            public final void apply(InternalNotification notification) {
                this.eta$0$1$1.log(notification);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    private Set<InternalNotification> findDeprecations(Statement statement2) {
        return Foldable$FoldableAny$.MODULE$.treeFold$extension(Foldable$.MODULE$.FoldableAny(statement2), Predef$.MODULE$.Set().empty(), new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var9_13;
                FunctionInvocation functionInvocation;
                FunctionName functionName;
                boolean bl = false;
                ObjectRef objectRef = ObjectRef.create(null);
                A1 A1 = x1;
                if (A1 instanceof FunctionInvocation && (functionName = (functionInvocation = (FunctionInvocation)A1).functionName()) != null) {
                    String name2 = functionName.name();
                    if (replaceAliasedFunctionInvocations$.MODULE$.aliases().get((Object)name2).nonEmpty()) {
                        Serializable serializable = new Serializable(this, name2, functionInvocation){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;
                            private final FunctionInvocation x2$1;

                            public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> seq) {
                                return new Tuple2((Object)seq.$plus((Object)new DeprecatedFunctionNotification(this.x2$1.position(), this.name$1, (String)replaceAliasedFunctionInvocations$.MODULE$.aliases().apply((Object)this.name$1))), (Object)None$.MODULE$);
                            }
                            {
                                this.name$1 = name$1;
                                this.x2$1 = x2$1;
                            }
                        };
                        return var9_13;
                    }
                }
                if (A1 instanceof RelationshipPattern) {
                    bl = true;
                    objectRef.elem = (RelationshipPattern)A1;
                    Option<Variable> option = ((RelationshipPattern)objectRef.elem).variable();
                    Option<Option<Range>> option2 = ((RelationshipPattern)objectRef.elem).length();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Variable variable2 = (Variable)some.x();
                        if (option2 instanceof Some) {
                            Serializable serializable = new Serializable(this, variable2, objectRef){
                                public static final long serialVersionUID = 0L;
                                private final Variable variable$1;
                                private final ObjectRef x7$1;

                                public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> seq) {
                                    return new Tuple2((Object)seq.$plus((Object)new DeprecatedVarLengthBindingNotification(((RelationshipPattern)this.x7$1.elem).position(), this.variable$1.name())), (Object)None$.MODULE$);
                                }
                                {
                                    this.variable$1 = variable$1;
                                    this.x7$1 = x7$1;
                                }
                            };
                            return var9_13;
                        }
                    }
                }
                if (bl) {
                    Option<Variable> variable3 = ((RelationshipPattern)objectRef.elem).variable();
                    Option<Option<Range>> length2 = ((RelationshipPattern)objectRef.elem).length();
                    Option<Expression> properties = ((RelationshipPattern)objectRef.elem).properties();
                    boolean bl2 = ((RelationshipPattern)objectRef.elem).legacyTypeSeparator();
                    if (bl2 && (variable3.isDefined() || length2.isDefined() || properties.isDefined())) {
                        Serializable serializable = new Serializable(this, objectRef){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef x7$1;

                            public final Tuple2<Set<InternalNotification>, None$> apply(Set<InternalNotification> seq) {
                                return new Tuple2((Object)seq.$plus((Object)new DeprecatedRelTypeSeparatorNotification(((RelationshipPattern)this.x7$1.elem).position())), (Object)None$.MODULE$);
                            }
                            {
                                this.x7$1 = x7$1;
                            }
                        };
                        return var9_13;
                    }
                }
                Object object = function1.apply(x1);
                return var9_13;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                FunctionInvocation functionInvocation;
                FunctionName functionName;
                boolean bl = false;
                RelationshipPattern relationshipPattern = null;
                Object object = x1;
                if (object instanceof FunctionInvocation && (functionName = (functionInvocation = (FunctionInvocation)object).functionName()) != null) {
                    String name2 = functionName.name();
                    if (replaceAliasedFunctionInvocations$.MODULE$.aliases().get((Object)name2).nonEmpty()) {
                        return true;
                    }
                }
                if (object instanceof RelationshipPattern) {
                    bl = true;
                    relationshipPattern = (RelationshipPattern)object;
                    Option<Variable> option = relationshipPattern.variable();
                    Option<Option<Range>> option2 = relationshipPattern.length();
                    if (option instanceof Some && option2 instanceof Some) {
                        return true;
                    }
                }
                if (!bl) return false;
                Option<Variable> variable2 = relationshipPattern.variable();
                Option<Option<Range>> length2 = relationshipPattern.length();
                Option<Expression> properties = relationshipPattern.properties();
                boolean bl2 = relationshipPattern.legacyTypeSeparator();
                if (true != bl2) return false;
                if (variable2.isDefined()) return true;
                if (length2.isDefined()) return true;
                if (!properties.isDefined()) return false;
                return true;
            }
        });
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    @Override
    public String description() {
        return "find deprecated Cypher constructs and generate warnings for them";
    }

    private SyntaxDeprecationWarnings$() {
        MODULE$ = this;
        Transformer$class.$init$(this);
        Phase$class.$init$(this);
        VisitorPhase$class.$init$(this);
    }
}

