/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorBreakTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorContinueTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorFailTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorRetryThenBreakTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorRetryThenContinueTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorRetryThenFailTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionPipeWrapper;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionRetryLogic;
import org.neo4j.exceptions.InternalException;
import org.neo4j.logging.InternalLog;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public final class TransactionPipeWrapper$ {
    public static final TransactionPipeWrapper$ MODULE$ = new TransactionPipeWrapper$();

    public TransactionPipeWrapper apply(SubqueryCall.InTransactionsOnErrorBehaviour error, int outerId, Pipe inner, boolean concurrentAccess, Option<TransactionRetryLogic> retryLogic) {
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour2;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour3;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour4;
        Tuple2 tuple2 = new Tuple2((Object)error, retryLogic);
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour4 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1())) {
            return new OnErrorContinueTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour3 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1())) {
            return new OnErrorBreakTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorFail$.MODULE$.equals(inTransactionsOnErrorBehaviour2 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1()) && concurrentAccess) {
            return new OnErrorBreakTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null && SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorFail$.MODULE$.equals(inTransactionsOnErrorBehaviour = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1())) {
            return new OnErrorFailTxPipe(outerId, inner, concurrentAccess);
        }
        if (tuple2 != null) {
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour5 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1();
            Option option = (Option)tuple2._2();
            if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour5) && option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic retryLogic2 = (TransactionRetryLogic)some.value();
                return new OnErrorRetryThenContinueTxPipe(outerId, inner, concurrentAccess, retryLogic2);
            }
        }
        if (tuple2 != null) {
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour6 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1();
            Option option = (Option)tuple2._2();
            if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour6) && option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic retryLogic3 = (TransactionRetryLogic)some.value();
                return new OnErrorRetryThenBreakTxPipe(outerId, inner, concurrentAccess, retryLogic3);
            }
        }
        if (tuple2 != null) {
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour7 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1();
            Option option = (Option)tuple2._2();
            if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenFail$.MODULE$.equals(inTransactionsOnErrorBehaviour7) && option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic retryLogic4 = (TransactionRetryLogic)some.value();
                if (concurrentAccess) {
                    return new OnErrorRetryThenBreakTxPipe(outerId, inner, concurrentAccess, retryLogic4);
                }
            }
        }
        if (tuple2 != null) {
            SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour8 = (SubqueryCall.InTransactionsOnErrorBehaviour)tuple2._1();
            Option option = (Option)tuple2._2();
            if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorRetryThenFail$.MODULE$.equals(inTransactionsOnErrorBehaviour8) && option instanceof Some) {
                Some some = (Some)option;
                TransactionRetryLogic retryLogic5 = (TransactionRetryLogic)some.value();
                return new OnErrorRetryThenFailTxPipe(outerId, inner, concurrentAccess, retryLogic5);
            }
        }
        throw new UnsupportedOperationException("Unsupported error behaviour " + error + " with retry logic " + retryLogic);
    }

    public long evaluateBatchSize(Expression batchSize, QueryState state) {
        return PipeHelper$.MODULE$.evaluateStaticLongOrThrow(batchSize, 1L, state, "OF ... ROWS", " Must be a positive integer.");
    }

    public long evaluateConcurrency(Option<Expression> concurrency, QueryState state) {
        int effectiveConcurrency;
        block4: {
            long l;
            Option<Expression> option = concurrency;
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression c = (Expression)some.value();
                l = PipeHelper$.MODULE$.evaluateStaticLongOrThrow(c, Long.MIN_VALUE, state, "IN ... CONCURRENT TRANSACTIONS", "");
            } else if (None$.MODULE$.equals(option)) {
                l = 0L;
            } else {
                throw new MatchError(option);
            }
            long concurrencyLong = l;
            int numberOfProcessors = Runtime.getRuntime().availableProcessors();
            int maxConcurrency = numberOfProcessors * 20;
            effectiveConcurrency = Math.clamp(concurrencyLong, Integer.MIN_VALUE, maxConcurrency);
            if (effectiveConcurrency > 0) break block4;
            effectiveConcurrency = Math.max(numberOfProcessors + effectiveConcurrency, 1);
        }
        return effectiveConcurrency;
    }

    public void assertTransactionStateIsEmpty(QueryState state) {
        if (state.query().transactionalContext().dataRead().transactionStateHasChanges()) {
            throw new InternalException("Expected transaction state to be empty when calling transactional subquery.");
        }
    }

    public void org$neo4j$cypher$internal$runtime$interpreted$pipes$TransactionPipeWrapper$$logError(QueryState state, String innerTxId, Throwable t) {
        String outerTxId = state.query().transactionalContext().userTransactionId();
        InternalLog log = state.query().logProvider().getLog(this.getClass());
        log.info("Recover error in inner transaction " + innerTxId + " (outer transaction " + outerTxId + ")", t);
    }

    public long evaluateRetryTimeoutNanos(Option<Expression> retryTimeout, QueryState state, long defaultTimeoutInNanos) {
        Option<Expression> option = retryTimeout;
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression t = (Expression)some.value();
            return PipeHelper$.MODULE$.evaluateStaticSecondsToNanosOrThrow(t, 0L, state, "FOR ... SECONDS", "");
        }
        if (None$.MODULE$.equals(option)) {
            return defaultTimeoutInNanos;
        }
        throw new MatchError(option);
    }

    private TransactionPipeWrapper$() {
    }
}

