/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import org.neo4j.cypher.internal.runtime.CypherRow$;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class NumericHelper$ {
    public static final NumericHelper$ MODULE$ = new NumericHelper$();

    public Option<Object> asLongEntityId(AnyValue a) {
        AnyValue anyValue = a;
        if (anyValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)anyValue;
            return new Some((Object)BoxesRunTime.boxToLong((long)integralValue.longValue()));
        }
        if (anyValue instanceof FloatingPointValue) {
            FloatingPointValue floatingPointValue = (FloatingPointValue)anyValue;
            if (NumberValues.numbersEqual((double)floatingPointValue.doubleValue(), (long)floatingPointValue.longValue())) {
                return new Some((Object)BoxesRunTime.boxToLong((long)floatingPointValue.longValue()));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public long asLongEntityIdPrimitive(AnyValue a) {
        FloatingPointValue floatingPointValue;
        AnyValue anyValue = a;
        if (anyValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)anyValue;
            return integralValue.longValue();
        }
        if (anyValue instanceof FloatingPointValue && NumberValues.numbersEqual((double)(floatingPointValue = (FloatingPointValue)anyValue).doubleValue(), (long)floatingPointValue.longValue())) {
            return floatingPointValue.longValue();
        }
        return -1L;
    }

    public DoubleValue asDouble(AnyValue a) {
        return Values.doubleValue((double)this.asNumber(a).doubleValue());
    }

    public int asPrimitiveInt(AnyValue a) {
        return (int)this.asNumber(a).longValue();
    }

    public LongValue asLong(AnyValue a) {
        return Values.longValue((long)this.asPrimitiveLong(a));
    }

    public long asPrimitiveLong(AnyValue a) {
        return this.asNumber(a).longValue();
    }

    public NumberValue asNumber(AnyValue a) {
        AnyValue anyValue = a;
        if (anyValue == null) {
            throw CypherTypeException.expectedNumericGotNull((String)this.toString());
        }
        if (anyValue == Values.NO_VALUE) {
            throw CypherTypeException.expectedNumericGotNull((String)this.toString());
        }
        if (anyValue instanceof NumberValue) {
            NumberValue numberValue = (NumberValue)anyValue;
            return numberValue;
        }
        if (anyValue instanceof Value) {
            Value value = (Value)anyValue;
            throw CypherTypeException.expectedNumericGot((String)this.toString(), (String)String.valueOf(value), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
        }
        throw CypherTypeException.expectedNumericGot((String)this.toString(), (String)String.valueOf(anyValue), (String)String.valueOf(anyValue), (String)CypherTypeValueMapper.valueType((AnyValue)anyValue));
    }

    public NumberValue evaluateStaticallyKnownNumber(Expression exp, QueryState state) {
        return this.asNumber(exp.apply((ReadableRow)CypherRow$.MODULE$.empty(), state));
    }

    private NumericHelper$() {
    }
}

