/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AvgFunction$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u0010 \u0001AB\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005u!)1\t\u0001C\u0001\t\")q\t\u0001C\u0001\u0011\"9\u0011\u000b\u0001a\u0001\n\u0013\u0011\u0006bB-\u0001\u0001\u0004%IA\u0017\u0005\u0007A\u0002\u0001\u000b\u0015B*\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\"9a\r\u0001a\u0001\n\u00139\u0007BB5\u0001A\u0003&1\rC\u0004k\u0001\u0001\u0007I\u0011\u00022\t\u000f-\u0004\u0001\u0019!C\u0005Y\"1a\u000e\u0001Q!\n\rDqa\u001c\u0001A\u0002\u0013%!\rC\u0004q\u0001\u0001\u0007I\u0011B9\t\rM\u0004\u0001\u0015)\u0003d\u0011\u001d!\b\u00011A\u0005\n\tDq!\u001e\u0001A\u0002\u0013%a\u000f\u0003\u0004y\u0001\u0001\u0006Ka\u0019\u0005\bs\u0002\u0001\r\u0011\"\u0005c\u0011\u001dQ\b\u00011A\u0005\u0012mDa! \u0001!B\u0013\u0019\u0007\"\u0002@\u0001\t\u0003z\bbBA\u000f\u0001\u0011\u0005\u0013qD\u0004\b\u0003_y\u0002\u0012AA\u0019\r\u0019qr\u0004#\u0001\u00024!11I\u0007C\u0001\u0003wA\u0001\"!\u0010\u001b\u0005\u0004%\tA\u0015\u0005\b\u0003\u007fQ\u0002\u0015!\u0003T\u0005-\teo\u001a$v]\u000e$\u0018n\u001c8\u000b\u0005\u0001\n\u0013aC1hOJ,w-\u0019;j_:T!AI\u0012\u0002\u000bAL\u0007/Z:\u000b\u0005\u0011*\u0013aC5oi\u0016\u0014\bO]3uK\u0012T!AJ\u0014\u0002\u000fI,h\u000e^5nK*\u0011\u0001&K\u0001\tS:$XM\u001d8bY*\u0011!fK\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00051j\u0013!\u00028f_RR'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tT\u0007\u0005\u00023g5\tq$\u0003\u00025?\t\u0019\u0012iZ4sK\u001e\fG/[8o\rVt7\r^5p]B\u0011!GN\u0005\u0003o}\u0011aET;nKJL7m\u0014:EkJ\fG/[8o\u0003\u001e<'/Z4bi&|g.\u0012=qe\u0016\u001c8/[8o\u0003\u00151\u0018\r\\;f+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005}\u001a\u0013\u0001C2p[6\fg\u000eZ:\n\u0005\u0005c$AC#yaJ,7o]5p]\u00061a/\u00197vK\u0002\na\u0001P5oSRtDCA#G!\t\u0011\u0004\u0001C\u00039\u0007\u0001\u0007!(\u0001\u0003oC6,W#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015\u0001\u00027b]\u001eT\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002Q\u0017\n11\u000b\u001e:j]\u001e\fQaY8v]R,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\u0005\u0019>tw-A\u0005d_VtGo\u0018\u0013fcR\u00111L\u0018\t\u0003)rK!!X+\u0003\tUs\u0017\u000e\u001e\u0005\b?\u001a\t\t\u00111\u0001T\u0003\rAH%M\u0001\u0007G>,h\u000e\u001e\u0011\u0002!5|g\u000e\u001e5t%Vtg.\u001b8h\u0003Z<W#A2\u0011\u0005Q#\u0017BA3V\u0005\u0019!u.\u001e2mK\u0006!Rn\u001c8uQN\u0014VO\u001c8j]\u001e\feoZ0%KF$\"a\u00175\t\u000f}K\u0011\u0011!a\u0001G\u0006\tRn\u001c8uQN\u0014VO\u001c8j]\u001e\feo\u001a\u0011\u0002\u001d\u0011\f\u0017p\u001d*v]:LgnZ!wO\u0006\u0011B-Y=t%Vtg.\u001b8h\u0003Z<w\fJ3r)\tYV\u000eC\u0004`\u0019\u0005\u0005\t\u0019A2\u0002\u001f\u0011\f\u0017p\u001d*v]:LgnZ!wO\u0002\n\u0011c]3d_:$7OU;o]&tw-\u0011<h\u0003U\u0019XmY8oIN\u0014VO\u001c8j]\u001e\feoZ0%KF$\"a\u0017:\t\u000f}{\u0011\u0011!a\u0001G\u0006\u00112/Z2p]\u0012\u001c(+\u001e8oS:<\u0017I^4!\u0003=q\u0017M\\8t%Vtg.\u001b8h\u0003Z<\u0017a\u00058b]>\u001c(+\u001e8oS:<\u0017I^4`I\u0015\fHCA.x\u0011\u001dy&#!AA\u0002\r\f\u0001C\\1o_N\u0014VO\u001c8j]\u001e\feo\u001a\u0011\u0002\u0013\u00054xMT;nE\u0016\u0014\u0018!D1wO:+XNY3s?\u0012*\u0017\u000f\u0006\u0002\\y\"9q,FA\u0001\u0002\u0004\u0019\u0017AC1wO:+XNY3sA\u00051!/Z:vYR$B!!\u0001\u0002\u0012A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001C:u_J\f'\r\\3\u000b\u0007\u0005-1&\u0001\u0004wC2,Xm]\u0005\u0005\u0003\u001f\t)AA\u0003WC2,X\rC\u0004\u0002\u0014]\u0001\r!!\u0006\u0002\u000bM$\u0018\r^3\u0011\t\u0005]\u0011\u0011D\u0007\u0002C%\u0019\u00111D\u0011\u0003\u0015E+XM]=Ti\u0006$X-A\u0003baBd\u0017\u0010F\u0003\\\u0003C\ti\u0003C\u0004\u0002$a\u0001\r!!\n\u0002\t\u0011\fG/\u0019\t\u0005\u0003O\tI#D\u0001&\u0013\r\tY#\n\u0002\f%\u0016\fG-\u00192mKJ{w\u000fC\u0004\u0002\u0014a\u0001\r!!\u0006\u0002\u0017\u00053xMR;oGRLwN\u001c\t\u0003ei\u00192AGA\u001b!\r!\u0016qG\u0005\u0004\u0003s)&AB!osJ+g\r\u0006\u0002\u00022\u0005a1\u000bS!M\u0019>;vlU%[\u000b\u0006i1\u000bS!M\u0019>;vlU%[\u000b\u0002\u0002")
public class AvgFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private long count;
    private double monthsRunningAvg;
    private double daysRunningAvg;
    private double secondsRunningAvg;
    private double nanosRunningAvg;
    private double avgNumber;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    public static long SHALLOW_SIZE() {
        return AvgFunction$.MODULE$.SHALLOW_SIZE();
    }

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration, QueryState state) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration, state);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "AVG";
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    private double monthsRunningAvg() {
        return this.monthsRunningAvg;
    }

    private void monthsRunningAvg_$eq(double x$1) {
        this.monthsRunningAvg = x$1;
    }

    private double daysRunningAvg() {
        return this.daysRunningAvg;
    }

    private void daysRunningAvg_$eq(double x$1) {
        this.daysRunningAvg = x$1;
    }

    private double secondsRunningAvg() {
        return this.secondsRunningAvg;
    }

    private void secondsRunningAvg_$eq(double x$1) {
        this.secondsRunningAvg = x$1;
    }

    private double nanosRunningAvg() {
        return this.nanosRunningAvg;
    }

    private void nanosRunningAvg_$eq(double x$1) {
        this.nanosRunningAvg = x$1;
    }

    public double avgNumber() {
        return this.avgNumber;
    }

    public void avgNumber_$eq(double x$1) {
        this.avgNumber = x$1;
    }

    public Value result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return Values.NO_VALUE;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return Values.doubleValue((double)this.avgNumber());
            }
        }
        if (bl) {
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingDurations().equals(aggregatingType)) {
                return DurationValue.approximate((double)this.monthsRunningAvg(), (double)this.daysRunningAvg(), (double)this.secondsRunningAvg(), (double)this.nanosRunningAvg()).normalize();
            }
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("invalid aggregation type " + this.aggregatingType()));
    }

    @Override
    public void apply(ReadableRow data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable)number -> {
            AvgFunction.$anonfun$apply$1(this, number);
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable)duration -> {
            AvgFunction.$anonfun$apply$2(this, duration);
            return BoxedUnit.UNIT;
        }, state);
    }

    private final void AggregatingNumbers$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(AvgFunction $this, NumberValue number) {
        $this.count_$eq($this.count() + 1L);
        $this.avgNumber_$eq(ValueMath.incrementalAverage((double)$this.avgNumber(), (double)number.doubleValue(), (double)$this.count()));
    }

    public static final /* synthetic */ void $anonfun$apply$2(AvgFunction $this, DurationValue duration) {
        $this.count_$eq($this.count() + 1L);
        $this.monthsRunningAvg_$eq($this.monthsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.MONTHS) - $this.monthsRunningAvg()) / (double)$this.count());
        $this.daysRunningAvg_$eq($this.daysRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.DAYS) - $this.daysRunningAvg()) / (double)$this.count());
        $this.secondsRunningAvg_$eq($this.secondsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.SECONDS) - $this.secondsRunningAvg()) / (double)$this.count());
        $this.nanosRunningAvg_$eq($this.nanosRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.NANOS) - $this.nanosRunningAvg()) / (double)$this.count());
    }

    public AvgFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
        this.count = 0L;
        this.monthsRunningAvg = 0.0;
        this.daysRunningAvg = 0.0;
        this.secondsRunningAvg = 0.0;
        this.nanosRunningAvg = 0.0;
        this.avgNumber = 0.0;
    }
}

